/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.web.rest;

import cn.gtmap.gtc.clients.RoleManagerClient;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.clients.manage.FlowableNodeClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessInstanceClient;
import cn.gtmap.gtc.workflow.clients.manage.TaskHandleClient;
import cn.gtmap.gtc.workflow.domain.common.BaseResult;
import cn.gtmap.gtc.workflow.domain.manage.BackTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.ForwardTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.service.feign.init.BdcInitFeignService;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import cn.gtmap.realestate.portal.ui.core.dto.WorkFlowDTO;
import cn.gtmap.realestate.portal.ui.core.vo.ForWardTaskVO;
import cn.gtmap.realestate.portal.ui.core.vo.ForWardVO;
import cn.gtmap.realestate.portal.ui.web.main.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/workflow/process-instances"})
@Api(tags={"\u6d41\u7a0b\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3"})
public class WorkflowHandleController
extends BaseController {
    @Autowired
    private ProcessInstanceClient processInstanceClient;
    @Autowired
    private TaskHandleClient taskHandleClient;
    @Autowired
    private FlowableNodeClient flowableNodeClient;
    @Autowired
    private RoleManagerClient roleManagerClient;
    @Autowired
    private BdcInitFeignService bdcInitFeignService;

    @PutMapping
    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlowDTO", value="\u5de5\u4f5c\u6d41\u53c2\u6570", required=true, dataType="WorkFlowDTO")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public TaskData startUpProcess(@RequestBody WorkFlowDTO workFlowDTO) {
        if (StringUtils.isBlank((CharSequence)workFlowDTO.getProcessDefKey())) {
            throw new MissingArgumentException("\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userName = workFlowDTO.getUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = this.userManagerUtils.getCurrentUserName();
        }
        return this.processInstanceClient.directStartProcessInstance(workFlowDTO.getProcessDefKey(), userName, workFlowDTO.getProcessInstanceName());
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u5f53\u524d\u4efb\u52a1")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string"), @ApiImplicitParam(name="gzlslid", value="\u5de5\u4f5c\u6d41\u5b9e\u4f8bID", paramType="query", dataType="string")})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteTask(@RequestParam(value="taskId") String taskId, @RequestParam(value="gzlslid") String gzlslid) throws Exception {
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)gzlslid)) {
            throw new MissingArgumentException("\u5220\u9664\u5f53\u524d\u4efb\u52a1taskId\u548cgzlslid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean delete = this.taskHandleClient.deleteTask(taskId);
        if (delete) {
            this.bdcInitFeignService.deleteYwxx(gzlslid);
        }
    }

    @GetMapping(value={"/forward/isEnd"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u529e\u7ed3")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public boolean isEnd(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u529e\u7ed3\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.isForwardEndEvent(taskId);
    }

    @PostMapping(value={"/end"})
    @ApiOperation(value="\u6d41\u7a0b\u529e\u7ed3")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="forwardTaskDto", value="\u8f6c\u53d1\u6d41\u7a0b\u4efb\u52a1", required=true, dataType="ForwardTaskDto")})
    @ResponseStatus(value=HttpStatus.OK)
    public void processEnd(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u529e\u7ed3\u6d41\u7a0b\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ForwardTaskDto forwardTaskDto = new ForwardTaskDto();
        forwardTaskDto.setTaskId(taskId);
        this.taskHandleClient.processEnd(forwardTaskDto);
    }

    @PostMapping(value={"/forward"})
    @ApiOperation(value="\u8f6c\u53d1\u6d41\u7a0b\u4efb\u52a1")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="forwardTaskDto", value="\u8f6c\u53d1\u6d41\u7a0b\u4efb\u52a1", required=true, dataType="ForwardTaskDto")})
    @ResponseStatus(value=HttpStatus.OK)
    public void forwardTask(ForwardTaskDto forwardTaskDto) {
        String taskId = forwardTaskDto.getTaskId();
        String opinion = forwardTaskDto.getOpinion();
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)opinion)) {
            throw new MissingArgumentException("taskId,opinion,\u8f6c\u53d1\u6d41\u7a0b\u7684id\u548c\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.taskHandleClient.complete((List)Lists.newArrayList((Object[])new ForwardTaskDto[]{forwardTaskDto}));
    }

    @GetMapping(value={"/forward/taskAndRole"})
    @ApiOperation(value="\u83b7\u53d6\u8f6c\u53d1\u6d3b\u52a8\u3001\u89d2\u8272\u3001\u8282\u70b9\u7c7b\u578b")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public ForWardVO queryForwardTaskAndRole(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u8f6c\u53d1\u6d3b\u52a8\u3001\u89d2\u8272\u3001\u8282\u70b9\u7c7b\u578b\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List forwardTaskDtos = this.flowableNodeClient.getForwardUserTasks(taskId);
        ArrayList forWardTaskVOS = Lists.newArrayList();
        forwardTaskDtos.forEach(forwardTaskDto -> {
            List roleIds = forwardTaskDto.getRoleIds();
            if (CollectionUtils.isNotEmpty((Collection)roleIds)) {
                List roleDtos = this.roleManagerClient.queryRolesByIds(roleIds);
                ForWardTaskVO forWardTaskVO = new ForWardTaskVO();
                forWardTaskVO.setForwardTaskDto(forwardTaskDto);
                forWardTaskVO.setRoleDtoList(roleDtos);
                forWardTaskVOS.add(forWardTaskVO);
            }
        });
        String nodeType = this.flowableNodeClient.getForwardNodeType(taskId);
        ForWardVO forWardVO = new ForWardVO();
        forWardVO.setForWardTaskVOList((List)forWardTaskVOS);
        forWardVO.setNodeType(nodeType);
        return forWardVO;
    }

    @GetMapping(value={"/forward"})
    @ApiOperation(value="\u83b7\u53d6\u8f6c\u53d1\u7684\u6d3b\u52a8")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public List<ForwardTaskDto> listFordWardDtos(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u8f6c\u53d1\u4efb\u52a1\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.getForwardUserTasks(taskId);
    }

    @GetMapping(value={"/forward/roles"})
    @ApiOperation(value="\u83b7\u53d6\u8f6c\u53d1\u7684\u89d2\u8272")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleIds", value="\u89d2\u8272id", paramType="query", dataType="String")})
    @ResponseStatus(value=HttpStatus.OK)
    public List<RoleDto> listForWardRoles(@RequestParam(value="roleIds") List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            throw new MissingArgumentException("\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.roleManagerClient.queryRolesByIds(roleIds);
    }

    @GetMapping(value={"/forward/users"})
    @ApiOperation(value="\u83b7\u53d6\u8f6c\u53d1\u7684\u7528\u6237")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public List<UserDto> listForwardUsers(@RequestParam(value="roleId") String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u8f6c\u53d1\u7684\u7528\u6237roleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.roleManagerClient.listEnableUsersByRoleId(roleId);
    }

    @GetMapping(value={"/taskNodeType"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9\u7c7b\u578b")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public String queryTaskNodeType(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u4efb\u52a1\u8282\u70b9\u7c7b\u578btaskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.getForwardNodeType(taskId);
    }

    @PostMapping(value={"/back"})
    @ApiOperation(value="\u9000\u56de\u4efb\u52a1\u6d41\u7a0b")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="backTaskDtos", value="taskid activityId opinion\u4e3a\u5fc5\u586b\u9879", required=true, dataType="BackTaskDto")})
    @ResponseStatus(value=HttpStatus.OK)
    public void backTask(@RequestBody List<BackTaskDto> backTaskDtos) {
        if (CollectionUtils.isEmpty(backTaskDtos)) {
            throw new MissingArgumentException("\u8f6c\u53d1\u4efb\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.taskHandleClient.back(backTaskDtos);
    }

    @GetMapping(value={"/back/isAllow"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u9000\u56de")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResult allowBack(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u9000\u56de\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.isAllowBack(taskId);
    }

    @GetMapping(value={"/back/userTasks"})
    @ApiOperation(value="\u83b7\u53d6\u9000\u56de\u8282\u70b9\u5217\u8868")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public List<BackTaskDto> listBackUserTasks(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u9000\u56de\u8282\u70b9\u5217\u8868\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.getBackUserTasks(taskId);
    }

    @PostMapping(value={"/task/claim"})
    @ApiOperation(value="\u8ba4\u9886\u4efb\u52a1")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskIds", value="\u8ba4\u9886\u4efb\u52a1ID", required=true, dataType="String")})
    @ResponseStatus(value=HttpStatus.OK)
    public void claimTask(@RequestParam(value="taskIds") List<String> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            throw new MissingArgumentException("\u9700\u8981\u8ba4\u9886\u7684\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userName = this.userManagerUtils.getCurrentUserName();
        this.taskHandleClient.taskClaim(userName, taskIds);
    }

    @PostMapping(value={"/hang"})
    @ApiOperation(value="\u6d41\u7a0b\u6302\u8d77")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public void taskHang(@RequestParam(value="processInstanceId") String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new MissingArgumentException("\u6d41\u7a0b\u6302\u8d77\u7684processInstanceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.taskHandleClient.taskHang(processInstanceId);
    }

    @PostMapping(value={"/activate"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public void taskActivation(@RequestParam(value="processInstanceId") String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new MissingArgumentException("\u6fc0\u6d3b\u6d41\u7a0b\u7684processInstanceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.taskHandleClient.taskActivation(processInstanceId);
    }

    @GetMapping(value={"/task/isAllowFetchBack"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u53d6\u56de(code 0: \u6210\u529f\uff0c 1\uff1a\u4e0d\u5141\u8bb8 )")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResult isAllowFetchBack(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u53d6\u56de\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.flowableNodeClient.isAllowFetchBack(taskId);
    }

    @GetMapping(value={"/task/fetchBack"})
    @ApiOperation(value="\u53d6\u56de")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public void fetchBack(@RequestParam(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u53d6\u56de\u7684taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.taskHandleClient.fetchBack(taskId);
    }

    @GetMapping(value={"/process/param"})
    @ApiOperation(value="\u751f\u6210\u4e00\u4e2a UUID")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f")})
    @ResponseStatus(value=HttpStatus.OK)
    public String initParam() {
        return UUIDGenerator.generate();
    }
}

