/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.web.rest;

import cn.gtmap.gtc.clients.AuthorityManagerClient;
import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.sso.domain.enums.ModuleTypeEnum;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.portal.ui.core.dto.BdcModuleDTO;
import cn.gtmap.realestate.portal.ui.web.main.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/rest/v1.0/user"})
@Api(tags={"\u95e8\u6237\u7f51\u7ad9\u670d\u52a1\u63a5\u53e3"})
public class BdcUserController
extends BaseController {
    @Autowired
    private UserManagerClient userManagerClient;
    @Autowired
    private AuthorityManagerClient authorityManagerClient;
    @Value(value="${app.oauth}")
    private String logout;

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    @ApiOperation(value="\u9000\u51fa\u7cfb\u7edf")
    public String logOut(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            new SecurityContextLogoutHandler().logout(request, response, authentication);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        return "redirect:".concat(this.queryAccountLogoutPath().concat("?redirect_uri=" + this.queryAbsContextPath(request).concat("/view/index.html")));
    }

    private String queryAccountLogoutPath() {
        return this.logout.concat("/logout");
    }

    private String queryAbsContextPath(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    @GetMapping(value={"/info"})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u57fa\u672c\u8d44\u6599")
    public Object queryUserInfo() {
        UserDto userDto = this.userManagerUtils.getCurrentUser();
        String userId = userDto.getId();
        userDto = this.userManagerUtils.getUserByUserid(userId);
        return userDto;
    }

    @PutMapping(value={"/password"})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="old", value="\u539f\u5bc6\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="password", value="\u7528\u6237\u5bc6\u7801", required=true, dataType="string", paramType="query")})
    public String updateUserPwd(String old, String password) {
        if (StringUtils.isBlank((CharSequence)old) || StringUtils.isBlank((CharSequence)password)) {
            throw new MissingArgumentException("\u4fee\u6539\u5bc6\u7801\u539f\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserDto userDto = this.userManagerUtils.getCurrentUser();
        Boolean isTrue = this.userManagerClient.checkUserPassword(old, userDto.getId());
        if (!isTrue.booleanValue()) {
            return "fail";
        }
        userDto.setPassword(password);
        this.userManagerClient.updateUserInfo(userDto.getId(), userDto);
        return "success";
    }

    @GetMapping(value={"/modules/{clientId}/{moduleType}"})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u4e0b\u7528\u6237\u53ef\u8bbf\u95ee\u7684\u6a21\u5757")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u5e94\u7528 id", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="moduleType", value="\u6a21\u5757\u5217\u8868", required=true, dataType="string", paramType="path")})
    public List<ModuleDto> listUserModules(@PathVariable(value="clientId") String clientId, @PathVariable(value="moduleType") String moduleType) {
        if (StringUtils.isBlank((CharSequence)clientId) || StringUtils.isBlank((CharSequence)moduleType)) {
            throw new MissingArgumentException("\u5e94\u7528 ID \u548c\u6a21\u5757\u7c7b\u578b\u53c2\u6570\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String username = this.userManagerUtils.getCurrentUserName();
        return this.authorityManagerClient.findClientUserModules(username, clientId, moduleType);
    }

    @GetMapping(value={"/submenu/{code}"})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u6a21\u5757\u4e0b\u7ea7\u53ef\u8bbf\u95ee\u6a21\u5757\u5217\u8868")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u5f53\u524d\u6a21\u5757 code \u503c", required=true, paramType="path")})
    public List<ModuleDto> listSubModules(@PathVariable(value="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new MissingArgumentException("\u83b7\u53d6\u5f53\u524d\u6a21\u5757\u4e0b\u7ea7\u53ef\u8bbf\u95ee\u6a21\u5757\u5217\u8868\u65f6\u9700\u4f20\u5165 code \u503c\uff01");
        }
        String username = this.userManagerUtils.getCurrentUserName();
        return this.authorityManagerClient.findSubUserModules(username, code, ModuleTypeEnum.CLASSIFICATION.value() + "," + ModuleTypeEnum.MENU.value());
    }

    @GetMapping(value={"/menu/{clientId}"})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5168\u90e8\u7684\u53ef\u8bbf\u95ee\u6a21\u5757\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u5e94\u7528 id", required=true, paramType="path")})
    public List<BdcModuleDTO> listAllModules(@PathVariable(value="clientId") String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5168\u90e8\u7684\u53ef\u8bbf\u95ee\u6a21\u5757\u5217\u8868, \u5e94\u7528 ID \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List moduleDtoList = this.listUserModules(clientId, ModuleTypeEnum.CLASSIFICATION.value() + "," + ModuleTypeEnum.MENU.value());
        ArrayList<BdcModuleDTO> menuList = new ArrayList<BdcModuleDTO>();
        ArrayList<ModuleDto> restList = new ArrayList<ModuleDto>();
        HashMap<String, BdcModuleDTO> difMap = new HashMap<String, BdcModuleDTO>();
        for (ModuleDto moduleDto : moduleDtoList) {
            BdcModuleDTO bdcModuleDTO = new BdcModuleDTO(moduleDto);
            if (StringUtils.equals((CharSequence)moduleDto.getType(), (CharSequence)ModuleTypeEnum.CLASSIFICATION.value())) {
                menuList.add(bdcModuleDTO);
                difMap.put(bdcModuleDTO.getId(), bdcModuleDTO);
                continue;
            }
            restList.add(moduleDto);
        }
        this.combineMenu(restList, difMap);
        return menuList;
    }

    private void combineMenu(List<ModuleDto> restList, Map<String, BdcModuleDTO> difMap) {
        ArrayList<ModuleDto> restNew = new ArrayList<ModuleDto>();
        HashMap<String, BdcModuleDTO> newMap = new HashMap<String, BdcModuleDTO>();
        for (ModuleDto dto : restList) {
            if (difMap.containsKey(dto.getParentId())) {
                BdcModuleDTO bdcModuleDTO = new BdcModuleDTO(dto);
                difMap.get(dto.getParentId()).getChildTree().add(bdcModuleDTO);
                newMap.put(dto.getId(), bdcModuleDTO);
                continue;
            }
            restNew.add(dto);
        }
        if (restNew.size() < restList.size()) {
            this.combineMenu(restNew, newMap);
        }
    }
}

