/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.web.rest;

import cn.gtmap.gtc.formclient.common.client.FormStateClient;
import cn.gtmap.gtc.formclient.common.dto.FormStateDTO;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.clients.manage.ProcessTaskClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessTaskRestClient;
import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import cn.gtmap.realestate.common.core.annotations.LayuiPageable;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.portal.ui.config.QueryParamsConfig;
import cn.gtmap.realestate.portal.ui.service.ProcessService;
import cn.gtmap.realestate.portal.ui.web.main.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/task"})
@Api(tags={"\u4efb\u52a1\u5217\u8868\u670d\u52a1\u63a5\u53e3"})
public class BdcTaskController
extends BaseController {
    @Autowired
    private ProcessTaskRestClient processTaskRestClient;
    @Autowired
    private ProcessTaskClient processTaskClient;
    @Autowired
    private QueryParamsConfig queryParamsConfig;
    @Autowired
    private FormStateClient formStateClient;
    @Autowired
    private ProcessService processService;

    @PostMapping(value={"/todo"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u5f85\u529e\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u9875\u6570", dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="\u6570\u91cf", dataType="string", paramType="query"), @ApiImplicitParam(name="sort", value="\u6392\u5e8f", dataType="string", paramType="query")})
    public Object queryTodoTask(@LayuiPageable Pageable pageable, HttpServletRequest httpServletRequest) {
        Page todoTaskPage = this.processTaskRestClient.todoTaskExtendList(this.querySearchParams(httpServletRequest), Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getPageNumber()));
        return this.addLayUiCode(todoTaskPage);
    }

    @PostMapping(value={"/complete"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u5df2\u529e\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u9875\u6570", dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="\u6570\u91cf", dataType="string", paramType="query"), @ApiImplicitParam(name="sort", value="\u6392\u5e8f", dataType="string", paramType="query")})
    public Object queryCompleteTask(@LayuiPageable Pageable pageable, HttpServletRequest httpServletRequest) {
        Page completeTaskPage = this.processTaskRestClient.completeTaskExtendList(this.querySearchParams(httpServletRequest), Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getPageNumber()));
        return this.addLayUiCode(completeTaskPage);
    }

    @PostMapping(value={"/all"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u9879\u76ee\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u9875\u6570", dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="\u6570\u91cf", dataType="string", paramType="query"), @ApiImplicitParam(name="sort", value="\u6392\u5e8f", dataType="string", paramType="query")})
    public Object queryAllTask(@LayuiPageable Pageable pageable, HttpServletRequest httpServletRequest) {
        Page allProcessInsPage = this.processTaskRestClient.queryProcessInsWithProject(this.querySearchParams(httpServletRequest), Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getPageNumber()));
        return this.addLayUiCode(allProcessInsPage);
    }

    @GetMapping(value={"/{taskId}"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1ID\u53bb\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, dataType="String", paramType="path")})
    public TaskData getTaskById(@PathVariable(value="taskId") String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new MissingArgumentException("\u6839\u636e\u4efb\u52a1ID\u53bb\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\uff0c\u4efb\u52a1 ID \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.processTaskClient.getTaskById(taskId);
    }

    @GetMapping(value={"/list"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u65b0\u5efa\u4efb\u52a1\u5217\u8868")
    public Object listCategoryProcess(@RequestParam(value="processDefName", required=false) String processDefName) {
        UserDto userDto = this.userManagerUtils.getCurrentUser();
        return this.processService.listCategoryProcess(userDto, processDefName);
    }

    @GetMapping(value={"/form-center/{formViewKey}"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formViewKey", value="formKey", required=true, dataType="String", paramType="path")})
    public List<FormStateDTO> listResource(@PathVariable(name="formViewKey") String formViewKey) {
        if (StringUtils.isBlank((CharSequence)formViewKey)) {
            throw new MissingArgumentException("\u83b7\u53d6\u4efb\u52a1\u7684\u8d44\u6e90\u5217\u8868 formViewKey \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] forms = formViewKey.split(",");
        List<FormStateDTO> list = new ArrayList();
        if (forms.length == 1) {
            list = this.formStateClient.listByFormViewKey(formViewKey);
        } else {
            HashSet<String> formKeySet = new HashSet<String>(Arrays.asList(forms));
            HashSet formModelSet = new HashSet();
            for (String key : formKeySet) {
                List formStateDTOList = this.formStateClient.listByFormViewKey(key);
                list.addAll(formStateDTOList.stream().filter(formStateDTO -> formModelSet.add(formStateDTO.getFormModelId())).collect(Collectors.toList()));
            }
        }
        list.sort((o1, o2) -> {
            if (NumberUtils.isNumber((String)o1.getRelOrder()) && NumberUtils.isNumber((String)o2.getRelOrder())) {
                return Integer.parseInt(o1.getRelOrder()) - Integer.parseInt(o2.getRelOrder());
            }
            return -1;
        });
        return list;
    }

    @PostMapping(value={"/claim/list"})
    @ApiOperation(value="\u83b7\u53d6\u8ba4\u9886\u4efb\u52a1\u5217\u8868")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u9875\u6570", dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="\u6570\u91cf", dataType="string", paramType="query"), @ApiImplicitParam(name="sort", value="\u6392\u5e8f", dataType="string", paramType="query")})
    @ResponseStatus(value=HttpStatus.OK)
    public Object listClaimTask(@LayuiPageable Pageable pageable, HttpServletRequest httpServletRequest) {
        String userName = this.userManagerUtils.getCurrentUserName();
        Page taskExtendDtoPage = this.processTaskRestClient.claimTaskExtendList(this.querySearchParams(httpServletRequest), userName, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getPageNumber()));
        return this.addLayUiCode(taskExtendDtoPage);
    }

    @GetMapping(value={"/process/last"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u5f53\u524d\u8fd0\u884c\u7684\u4eba\u5de5\u8282\u70b9\u5217\u8868\u6216\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u5217\u8868")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public List<TaskData> processLastTasks(@RequestParam(value="processInstanceId") String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new MissingArgumentException("\u83b7\u53d6\u5f53\u524d\u6d41\u7a0b\u6700\u540e\u4e00\u4e2a\u7ed3\u70b9\uff0c processInstanceId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.processTaskClient.processLastTasks(processInstanceId);
    }

    public List<RequestCondition> querySearchParams(HttpServletRequest httpServletRequest) {
        ArrayList<RequestCondition> list = new ArrayList<RequestCondition>();
        if (MapUtils.isNotEmpty((Map)this.queryParamsConfig.getParamMap()) && httpServletRequest != null) {
            for (Map.Entry param : this.queryParamsConfig.getParamMap().entrySet()) {
                String value = httpServletRequest.getParameter((String)param.getKey());
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                RequestCondition requestCondition = new RequestCondition();
                requestCondition.setRequestKey((String)((Map)param.getValue()).get("requestKey"));
                requestCondition.setRequestValue(value);
                list.add(requestCondition);
            }
        }
        return list;
    }
}

