/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.web.rest;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.portal.ui.web.main.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/files"})
@Api(tags={"\u9644\u4ef6\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3"})
public class BdcStorageController
extends BaseController {
    @Autowired
    private StorageClient storageClient;

    @GetMapping(value={"/root"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u6587\u6863\u62e5\u6709\u8005\u6240\u6709\u6839\u8282\u70b9\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u5e94\u7528 Id", paramType="query"), @ApiImplicitParam(name="spaceId", value="\u5b58\u50a8\u7a7a\u95f4 Id", paramType="query"), @ApiImplicitParam(name="owner", value="\u62e5\u6709\u8005", required=true, paramType="query"), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="enabled", value="\u6587\u4ef6\u72b6\u6001", paramType="query"), @ApiImplicitParam(name="type", value="\u6587\u4ef6\u7c7b\u578b", paramType="query")})
    public List<StorageDto> listRootStorages(@RequestParam(name="clientId", required=false) String clientId, @RequestParam(name="spaceId", required=false) String spaceId, @RequestParam(name="owner") String owner, @RequestParam(name="name", required=false) String name, @RequestParam(name="enabled", required=false) Integer enabled, @RequestParam(name="type", required=false) Integer type) {
        if (StringUtils.isBlank((CharSequence)owner)) {
            throw new MissingArgumentException("\u9644\u4ef6\u62e5\u6709\u8005\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.storageClient.listAllRootStorages(clientId, spaceId, owner, name, enabled, type);
    }

    @GetMapping(value={"/subfiles"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u76ee\u5f55id\u67e5\u8be2\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e94\u7528 Id", paramType="query"), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="enabled", value="\u6587\u4ef6\u72b6\u6001", paramType="query"), @ApiImplicitParam(name="type", value="\u6587\u4ef6\u7c7b\u578b", paramType="query")})
    public List<StorageDto> listSubStorages(@RequestParam(name="id") String id, @RequestParam(name="name", required=false) String name, @RequestParam(name="enabled", required=false) Integer enabled, @RequestParam(name="type", required=false) Integer type) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new MissingArgumentException("\u6839\u636e\u76ee\u5f55id\u67e5\u8be2\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u5e94\u7528 ID\uff01");
        }
        return this.storageClient.listAllSubsetStorages(id, name, enabled, type);
    }

    @GetMapping(value={"/all"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u6587\u6863\u62e5\u6709\u8005\u6240\u6709\u6587\u4ef6\u53ca\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u5e94\u7528 Id", paramType="query"), @ApiImplicitParam(name="spaceId", value="\u5b58\u50a8\u7a7a\u95f4 Id", paramType="query"), @ApiImplicitParam(name="owner", value="\u62e5\u6709\u8005", paramType="query"), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="enabled", value="\u6587\u4ef6\u72b6\u6001", paramType="query"), @ApiImplicitParam(name="type", value="\u6587\u4ef6\u7c7b\u578b", paramType="query")})
    public List<Map> listAllStorages(String clientId, String spaceId, String owner, String name, Integer enabled, Integer type) {
        List storageDtos = this.listRootStorages(clientId, spaceId, owner, name, enabled, type);
        return this.combineFolder(storageDtos);
    }

    private List<Map> combineFolder(List<StorageDto> storageDtos) {
        ArrayList<Map> menuList = new ArrayList<Map>();
        for (StorageDto storageDto : storageDtos) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", storageDto.getName());
            map.put("url", storageDto.getDownUrl());
            map.put("type", storageDto.getType());
            map.put("nodeid", storageDto.getId());
            map.put("owner", storageDto.getOwner());
            List subStorages = this.listSubStorages(storageDto.getId(), "", Integer.valueOf(1), null);
            if (CollectionUtils.isNotEmpty((Collection)subStorages)) {
                map.put("child", this.combineFolder(subStorages));
            }
            menuList.add(map);
        }
        return menuList;
    }

    @PostMapping(value={"/new"})
    @ApiOperation(value="\u65b0\u5efa\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clientId", value="\u5e94\u7528 Id", paramType="query"), @ApiImplicitParam(name="spaceId", value="\u5b58\u50a8\u7a7a\u95f4 Id", paramType="query"), @ApiImplicitParam(name="nodeId", value="\u4e0a\u7ea7\u6587\u4ef6\u5939Id", paramType="query"), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="owner", value="\u62e5\u6709\u8005", required=true, paramType="query")})
    public void createFolder(@RequestParam(name="clientId", required=false) String clientId, @RequestParam(name="spaceId", required=false) String spaceId, @RequestParam(name="nodeId", required=false) String nodeId, @RequestParam(name="name") String name, @RequestParam(name="owner") String owner) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)owner)) {
            throw new MissingArgumentException("\u65b0\u5efa\u6587\u4ef6\u5939\u65f6\u6587\u4ef6\u540d\u79f0\u548c\u62e5\u6709\u8005\u5747\u4e0d\u4e3a\u7a7a\uff01");
        }
        this.storageClient.createFolder(clientId, spaceId, nodeId, name, owner);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6587\u4ef6")
    @ApiImplicitParam(name="id", value="\u5f85\u5220\u9664\u6587\u4ef6 id", paramType="query")
    public boolean deleteFile(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new MissingArgumentException("\u5220\u9664\u6587\u4ef6\u672a\u4f20\u5165\u6307\u5b9a\u9644\u4ef6\u7684 id\uff01");
        }
        List<String> ids = Arrays.asList(id.split(","));
        return this.storageClient.deleteStorages(ids);
    }

    @PostMapping(value={"/name"})
    @ApiOperation(value="\u6587\u4ef6\u91cd\u547d\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9009\u4e2d\u6587\u4ef6 id", paramType="query"), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u65b0\u540d\u79f0", paramType="query")})
    public boolean renameFile(String id, String name) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)name)) {
            throw new MissingArgumentException("\u6587\u4ef6\u91cd\u547d\u540d\u65f6\u9700\u4f20\u5165\u9009\u4e2d\u6587\u4ef6\u7684 id \u548c\u6587\u4ef6\u65b0\u540d\u79f0\uff01");
        }
        return this.storageClient.rename(id, name);
    }
}

