/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.web.rest;

import cn.gtmap.gtc.clients.CollectionManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserCollectionDto;
import cn.gtmap.realestate.common.core.enums.BdcSclxEnum;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.portal.ui.web.main.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/collect"})
@Api(tags={"\u6536\u85cf\u529f\u80fd"})
public class BdcCollectController
extends BaseController {
    @Autowired
    CollectionManagerClient collectionManagerClient;

    @PutMapping(value={"/user"})
    @ApiOperation(value="\u4fdd\u5b58\u6536\u85cf\u5173\u7cfb")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="userCollectionDto", value="\u6536\u85cf\u4fe1\u606f", required=true, dataType="UserCollectionDto")
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserCollectionDto saveUserCollect(@RequestBody UserCollectionDto userCollectionDto) {
        if (userCollectionDto == null) {
            throw new AppException("\u4fdd\u5b58\u7684\u6536\u85cf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userName = this.userManagerUtils.getCurrentUserName();
        userCollectionDto.setType(BdcSclxEnum.DJLC.getType());
        userCollectionDto.setTypeName(BdcSclxEnum.DJLC.getTypeName());
        return this.collectionManagerClient.saveUserCollection(userName, userCollectionDto);
    }

    @DeleteMapping(value={"/user"})
    @ApiOperation(value="\u5220\u9664\u6536\u85cf\u5173\u7cfb")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="code", value="\u6536\u85cf\u4ee3\u7801\uff08\u552f\u4e00\u503c\uff09", required=true, paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteUserCollect(@RequestParam(name="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new MissingArgumentException("\u8981\u5220\u9664\u7684code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userName = this.userManagerUtils.getCurrentUserName();
        this.collectionManagerClient.deleteRelation(userName, code);
    }

    @PutMapping
    @ApiOperation(value="\u4fdd\u5b58\u6536\u85cf\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="userCollectionDto", value="\u6536\u85cf\u4fe1\u606f", required=true, dataType="UserCollectionDto")
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserCollectionDto saveCollect(@RequestBody UserCollectionDto userCollectionDto) {
        if (userCollectionDto == null) {
            throw new AppException("\u4fdd\u5b58\u7684\u6536\u85cf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)userCollectionDto.getType())) {
            userCollectionDto.setType(BdcSclxEnum.DJLC.getType());
        }
        if (StringUtils.isBlank((CharSequence)userCollectionDto.getTypeName())) {
            userCollectionDto.setTypeName(BdcSclxEnum.DJLC.getTypeName());
        }
        return this.collectionManagerClient.saveCollection(userCollectionDto);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6536\u85cf\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="code", value="\u6536\u85cf\u4ee3\u7801\uff08\u552f\u4e00\u503c\uff09", required=true, paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCollect(@RequestParam(name="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new MissingArgumentException("\u8981\u5220\u9664\u7684code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.collectionManagerClient.deleteCollection(code);
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u6536\u85cf\u4fe1\u606f\u5217\u8868")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u83b7\u53d6\u6210\u529f"), @ApiResponse(code=500, message="\u8bf7\u6c42\u53c2\u6570\u9519\u8bef")})
    @ApiImplicitParam(name="type", value="\u6536\u85cf\u7c7b\u578b", required=true, paramType="query", dataType="string")
    @ResponseStatus(value=HttpStatus.OK)
    public List<UserCollectionDto> listUserCollectionDto(@RequestParam(name="type", required=false) String type) {
        String userName = this.userManagerUtils.getCurrentUserName();
        if (StringUtils.isBlank((CharSequence)type)) {
            type = BdcSclxEnum.DJLC.getType();
        }
        return this.collectionManagerClient.listUserCollectionByType(userName, type);
    }
}

