/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.portal.ui.service.impl;

import cn.gtmap.gtc.clients.CollectionManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.clients.manage.ProcessTaskClient;
import cn.gtmap.gtc.workflow.domain.manage.CategoryProcessDto;
import cn.gtmap.gtc.workflow.domain.manage.ProcessDefData;
import cn.gtmap.realestate.common.core.enums.BdcSclxEnum;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import cn.gtmap.realestate.portal.ui.core.dto.BdcCategoryProcessDto;
import cn.gtmap.realestate.portal.ui.core.dto.BdcProcessDefData;
import cn.gtmap.realestate.portal.ui.service.ProcessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessServiceImpl
implements ProcessService {
    @Autowired
    private ProcessTaskClient processTaskClient;
    @Autowired
    private CollectionManagerClient collectionManagerClient;
    @Value(value="${workflow.list.size}")
    private Integer size;

    public Map<String, Object> listCategoryProcess(UserDto userDto, String processDefName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (userDto != null) {
            ArrayList<BdcCategoryProcessDto> resultlist = new ArrayList<BdcCategoryProcessDto>();
            List list = this.processTaskClient.listCategoryProcess(userDto.getUsername());
            List userCollectionDtos = this.collectionManagerClient.listUserCollectionByType(userDto.getUsername(), BdcSclxEnum.DJLC.getType());
            HashSet codeSet = Sets.newHashSet();
            userCollectionDtos.forEach(userCollectionDto -> codeSet.add(userCollectionDto.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (CategoryProcessDto categoryProcessDto : list) {
                    BdcCategoryProcessDto bdcCategoryProcessDto = new BdcCategoryProcessDto();
                    if (StringUtils.isNotBlank((CharSequence)processDefName)) {
                        categoryProcessDto.setProcessList(categoryProcessDto.getProcessList().stream().filter(processDefData -> StringUtils.contains((CharSequence)processDefData.getName(), (CharSequence)processDefName)).collect(Collectors.toList()));
                    }
                    BeanUtils.copyProperties((Object)categoryProcessDto, (Object)bdcCategoryProcessDto);
                    if (CollectionUtils.isNotEmpty((Collection)categoryProcessDto.getProcessList())) {
                        ArrayList<BdcProcessDefData> processlist = new ArrayList<BdcProcessDefData>();
                        for (ProcessDefData processDefData2 : bdcCategoryProcessDto.getProcessList()) {
                            BdcProcessDefData bdcProcessDefData = new BdcProcessDefData();
                            BeanUtils.copyProperties((Object)processDefData2, (Object)bdcProcessDefData);
                            bdcProcessDefData.setCommonUse(codeSet.contains(bdcProcessDefData.getProcessDefKey()) ? CommonConstantUtils.SF_S_DM : CommonConstantUtils.SF_F_DM);
                            processlist.add(bdcProcessDefData);
                        }
                        bdcCategoryProcessDto.setProcessList(processlist);
                    }
                    resultlist.add(bdcCategoryProcessDto);
                }
            }
            result.put("size", this.size);
            result.put("content", resultlist);
        }
        return result;
    }
}

