/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.service.impl;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.realestate.certificate.core.mapper.BdcZsMapper;
import cn.gtmap.realestate.certificate.core.service.BdcQlrService;
import cn.gtmap.realestate.certificate.core.service.BdcXmService;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.certificate.service.BdcFzjlService;
import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcFzjlDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcFzjlZsDTO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BdcFzjlServiceImpl
implements BdcFzjlService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcZsMapper bdcZsMapper;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    MessageProvider messageProvider;

    private static String generateFzjlBz(BdcXmDO bdcXmDO, Integer zslx, List<String> zsidList) {
        String xmBz;
        StringBuilder bz = new StringBuilder();
        if (CollectionUtils.isNotEmpty(zsidList)) {
            if (CommonConstantUtils.ZSLX_ZS.equals(zslx)) {
                bz = bz.append("\u4e0d\u52a8\u4ea7\u6743\u8bc1\u4e66").append("\uff1a").append(CollectionUtils.size(zsidList)).append("\u672c\u3002");
            }
            if (CommonConstantUtils.ZSLX_ZM.equals(zslx)) {
                bz = bz.append("\u4e0d\u52a8\u4ea7\u6743\u8bc1\u660e\u4e66").append("\uff1a").append(CollectionUtils.size(zsidList)).append("\u672c\u3002");
            }
        }
        if (StringUtils.isBlank((CharSequence)(xmBz = bdcXmDO.getBz()))) {
            return bz.toString();
        }
        if (StringUtils.indexOf((CharSequence)xmBz, (CharSequence)bz.toString()) > -1) {
            return xmBz;
        }
        return xmBz.concat("\n").concat(bz.toString());
    }

    private static List<BdcFzjlZsDTO> generateBdcZsDTO(List<BdcZsDO> bdcZsDOList, List<String> zsidList, boolean sfhb) {
        ArrayList<BdcFzjlZsDTO> bdcFzjlZsDTOList = new ArrayList<BdcFzjlZsDTO>();
        for (BdcZsDO bdcZsDO : bdcZsDOList) {
            BdcFzjlZsDTO bdcFzjlZsDTO = new BdcFzjlZsDTO();
            BeanUtils.copyProperties((Object)bdcZsDO, (Object)bdcFzjlZsDTO);
            if (sfhb) {
                String bdcqzh = bdcZsDO.getBdcqzh();
                bdcFzjlZsDTO.setBdcqzh(StringUtils.isBlank((CharSequence)bdcqzh) ? "" : bdcqzh + "\u7b49");
                bdcFzjlZsDTO.setZsidList(zsidList);
                bdcFzjlZsDTOList.add(bdcFzjlZsDTO);
                break;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(bdcZsDO.getZsid());
            bdcFzjlZsDTO.setZsidList(stringList);
            bdcFzjlZsDTOList.add(bdcFzjlZsDTO);
        }
        return bdcFzjlZsDTOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateFzjlLzr(List<BdcFzjlZsDTO> bdcFzjlZsDTOList) {
        if (CollectionUtils.isEmpty(bdcFzjlZsDTOList) || null == bdcFzjlZsDTOList.get(0)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        int result = 0;
        for (BdcFzjlZsDTO bdcFzjlZsDTO : bdcFzjlZsDTOList) {
            if (null == bdcFzjlZsDTO) continue;
            int temp = this.bdcZsService.updateLzr(bdcFzjlZsDTO);
            result += temp;
        }
        return result;
    }

    public BdcFzjlDTO queryFzjl(String xmid) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        BdcXmDO bdcXmDO = (BdcXmDO)this.entityMapper.selectByPrimaryKey(BdcXmDO.class, (Object)xmid);
        List bdcZsDOList = this.bdcZsService.queryBdcZsByXmid(xmid);
        if (CollectionUtils.isNotEmpty((Collection)bdcZsDOList) && null != bdcZsDOList.get(0)) {
            BdcZsDO bdcZsDOTemp = (BdcZsDO)bdcZsDOList.get(0);
            List zsidList = this.bdcZsMapper.getXmZsid(xmid);
            BdcFzjlDTO bdcFzjlDTO = this.generateFzjl(bdcXmDO, bdcZsDOTemp);
            String bz = BdcFzjlServiceImpl.generateFzjlBz((BdcXmDO)bdcXmDO, (Integer)bdcZsDOTemp.getZslx(), (List)zsidList);
            bdcFzjlDTO.setBz(bz);
            List bdcFzjlZsDTOList = BdcFzjlServiceImpl.generateBdcZsDTO((List)bdcZsDOList, (List)zsidList, (boolean)false);
            bdcFzjlDTO.setBdcFzjlZsDTOList(bdcFzjlZsDTOList);
            this.generateFzjlSqrxx(xmid, bdcFzjlDTO);
            return bdcFzjlDTO;
        }
        return new BdcFzjlDTO();
    }

    public BdcFzjlDTO queryHbFzjl(String gzlslid) {
        BdcFzjlDTO bdcFzjlDTO;
        if (StringUtils.isBlank((CharSequence)gzlslid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        List bdcXmDOList = this.bdcXmService.queryListBdcXm(null, gzlslid);
        BdcXmDO bdcXmDO = new BdcXmDO();
        if (CollectionUtils.isNotEmpty((Collection)bdcXmDOList) && null != bdcXmDOList.get(0)) {
            bdcXmDO = (BdcXmDO)bdcXmDOList.get(0);
        }
        List bdcZsDOList = this.bdcZsService.queryBdcZsByXmid(bdcXmDO.getXmid());
        BdcZsDO bdcZsDOTemp = new BdcZsDO();
        if (CollectionUtils.isNotEmpty((Collection)bdcZsDOList)) {
            bdcZsDOTemp = (BdcZsDO)bdcZsDOList.get(0);
        }
        List zsidList = this.bdcZsMapper.getGzlZsid(gzlslid);
        String zl = (bdcFzjlDTO = this.generateFzjl(bdcXmDO, bdcZsDOTemp)).getZl();
        bdcFzjlDTO.setZl(StringUtils.isBlank((CharSequence)zl) ? "" : zl + "\u7b49");
        String bz = BdcFzjlServiceImpl.generateFzjlBz((BdcXmDO)bdcXmDO, (Integer)bdcZsDOTemp.getZslx(), (List)zsidList);
        bdcFzjlDTO.setBz(bz);
        List bdcFzjlZsDTOList = BdcFzjlServiceImpl.generateBdcZsDTO((List)bdcZsDOList, (List)zsidList, (boolean)true);
        bdcFzjlDTO.setBdcFzjlZsDTOList(bdcFzjlZsDTOList);
        this.generateFzjlSqrxx(bdcXmDO.getXmid(), bdcFzjlDTO);
        return bdcFzjlDTO;
    }

    private BdcFzjlDTO generateFzjl(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO) {
        BdcFzjlDTO bdcFzjlDTO = new BdcFzjlDTO();
        bdcFzjlDTO.setSlbh(bdcXmDO.getSlbh());
        bdcFzjlDTO.setXmid(bdcXmDO.getXmid());
        bdcFzjlDTO.setSzr(bdcZsDO.getSzr());
        bdcFzjlDTO.setFzr(bdcZsDO.getFzr());
        bdcFzjlDTO.setFzrq(bdcZsDO.getFzsj());
        bdcFzjlDTO.setZl(bdcZsDO.getZl());
        return bdcFzjlDTO;
    }

    public List<BdcFzjlDTO> queryListBdcFzjl(String gzlslid, boolean sfhb) {
        if (StringUtils.isBlank((CharSequence)gzlslid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        ArrayList<BdcFzjlDTO> bdcFzjlDTOList = new ArrayList<BdcFzjlDTO>();
        if (sfhb) {
            BdcFzjlDTO bdcFzjlDTO = this.queryHbFzjl(gzlslid);
            bdcFzjlDTOList.add(bdcFzjlDTO);
        } else {
            List bdcXmDOList = this.bdcXmService.queryListBdcXm(null, gzlslid);
            if (CollectionUtils.isNotEmpty((Collection)bdcXmDOList)) {
                for (BdcXmDO bdcXmDO : bdcXmDOList) {
                    BdcFzjlDTO bdcFzjlDTO = this.queryFzjl(bdcXmDO.getXmid());
                    bdcFzjlDTOList.add(bdcFzjlDTO);
                }
            }
        }
        return bdcFzjlDTOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateFzjlBz(String xmid, boolean sfhb, String bz) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        int result = 0;
        if (sfhb) {
            List bdcXmDOList = this.bdcXmService.queryListBdcXm(xmid, null);
            for (BdcXmDO bdcXmDOTemp : bdcXmDOList) {
                result += this.bdcXmService.updateXmBz(bdcXmDOTemp.getXmid(), bz);
            }
        } else {
            return this.bdcXmService.updateXmBz(xmid, bz);
        }
        return result;
    }

    public int updateFzr(String gzlslid, UserDto fzr) {
        if (StringUtils.isBlank((CharSequence)gzlslid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        List zsidList = this.bdcZsMapper.getGzlZsid(gzlslid);
        return this.bdcZsService.updateFzr(zsidList, fzr);
    }

    private void generateFzjlSqrxx(String xmid, BdcFzjlDTO bdcFzjlDTO) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        List bdcQlrDOList = this.bdcQlrService.queryListBdcQlr(xmid, CommonConstantUtils.QLRLB_QLR_DM);
        StringBuilder sqr = new StringBuilder();
        StringBuilder sqrlxdh = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
            for (BdcQlrDO bdcQlrDO : bdcQlrDOList) {
                if (null == bdcQlrDO) continue;
                sqr = sqr.append(StringUtils.isNotBlank((CharSequence)bdcQlrDO.getQlrmc()) ? bdcQlrDO.getQlrmc() : "").append(" ");
                sqrlxdh = sqrlxdh.append(StringUtils.isNotBlank((CharSequence)bdcQlrDO.getDh()) ? bdcQlrDO.getDh() : "").append(" ");
            }
        }
        bdcFzjlDTO.setSqr(sqr.toString());
        bdcFzjlDTO.setSqrlxdh(sqrlxdh.toString());
    }
}

