/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.service.impl;

import cn.gtmap.realestate.certificate.core.bo.BdcBdcqzhBO;
import cn.gtmap.realestate.certificate.service.BdcXmBdcqzhService;
import cn.gtmap.realestate.certificate.service.BdcZsBdcqzhService;
import cn.gtmap.realestate.certificate.service.impl.BaseBdcBdcqzhServiceImpl;
import cn.gtmap.realestate.common.core.annotations.RedissonLock;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcXtZsbhmbDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcBdcqzhDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bdcBdcqzhServiceImpl")
public class BdcBdcqzhServiceImpl
implements BdcXmBdcqzhService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcBdcqzhServiceImpl.class);
    private static final String CLASS_NAME = BdcBdcqzhServiceImpl.class.getName();
    @Autowired
    private BaseBdcBdcqzhServiceImpl baseBdcBdcqzhService;
    @Resource(name="bdcBdcqzhYlzhServiceImpl")
    private BdcZsBdcqzhService bdcqzhYlzhService;
    @Resource(name="bdcBdcqzhFhServiceImpl")
    private BdcZsBdcqzhService bdcqzhFhService;
    @Resource(name="bdcBdcqzhMrServiceImpl")
    private BdcZsBdcqzhService bdcqzhMrService;

    @Transactional(rollbackFor={Exception.class})
    @RedissonLock(lockKey="REDISSON_LOCK_BDCQZH", description="\u83b7\u53d6\u4e0d\u52a8\u4ea7\u8bc1\u4e66\uff08\u660e\uff09\u53f7")
    public List<BdcBdcqzhDTO> generateBdcqzh(String xmid) {
        BdcXmDO bdcXmDO = this.baseBdcBdcqzhService.getBdcXm(xmid);
        BdcXtZsbhmbDO bdcXtZsbhmbDO = this.baseBdcBdcqzhService.getBdcXtZsbhmb(bdcXmDO);
        List bdcZsDOList = this.baseBdcBdcqzhService.getBdcZs(xmid);
        ArrayList<BdcBdcqzhDTO> bdcBdcqzhDTOList = new ArrayList<BdcBdcqzhDTO>(bdcZsDOList.size());
        for (BdcZsDO bdcZsDO : bdcZsDOList) {
            if (null == bdcZsDO || !StringUtils.isBlank((CharSequence)bdcZsDO.getBdcqzh())) continue;
            if (null == bdcZsDO.getZslx()) {
                LOGGER.error("{}\uff1a\u83b7\u53d6\u8bc1\u53f7\uff1a{}\u9879\u76ee\u5bf9\u5e94\u8bc1\u4e66\u8bb0\u5f55\u8bc1\u4e66\u7c7b\u578bZSLX\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u751f\u6210\u8bc1\u53f7\u4e2d\u6b62\uff01", (Object)CLASS_NAME, (Object)xmid);
                throw new AppException("\u83b7\u53d6\u8bc1\u53f7\uff1a\u9879\u76ee\u5bf9\u5e94\u8bc1\u4e66\u8bb0\u5f55\u8bc1\u4e66\u7c7b\u578bZSLX\u5b57\u6bb5\u4e3a\u7a7a\uff01");
            }
            BdcBdcqzhBO bdcBdcqzhBO = new BdcBdcqzhBO(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
            BdcBdcqzhDTO bdcBdcqzhDTO = this.resolveBdcqzh(bdcBdcqzhBO);
            this.baseBdcBdcqzhService.saveBdcqzh(bdcBdcqzhDTO);
            bdcBdcqzhDTOList.add(bdcBdcqzhDTO);
        }
        return bdcBdcqzhDTOList;
    }

    private BdcBdcqzhDTO resolveBdcqzh(BdcBdcqzhBO bdcBdcqzhBO) {
        BdcBdcqzhDTO bdcBdcqzhDTO;
        if (1 == bdcBdcqzhBO.getYlzhkg() && null != (bdcBdcqzhDTO = this.bdcqzhYlzhService.resolveBdcqzh(bdcBdcqzhBO))) {
            return bdcBdcqzhDTO;
        }
        if (1 == bdcBdcqzhBO.getZsfhkg() && null != (bdcBdcqzhDTO = this.bdcqzhFhService.resolveBdcqzh(bdcBdcqzhBO))) {
            return bdcBdcqzhDTO;
        }
        return this.bdcqzhMrService.resolveBdcqzh(bdcBdcqzhBO);
    }
}

