/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.core.service.impl;

import cn.gtmap.realestate.certificate.core.mapper.BdcYzhMapper;
import cn.gtmap.realestate.certificate.core.service.BdcYzhService;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.certificate.util.Object2MapUtils;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.domain.certificate.BdcYzhDO;
import cn.gtmap.realestate.common.core.domain.certificate.BdcYzhsymxDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcYzhDTO;
import cn.gtmap.realestate.common.core.dto.rules.BdcGzyzTsxxDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.qo.certificate.BdcYzhQO;
import cn.gtmap.realestate.common.core.qo.certificate.BdcYzhSyqkQO;
import cn.gtmap.realestate.common.core.qo.rules.BdcGzQtYzQO;
import cn.gtmap.realestate.common.core.service.feign.rules.BdcGzQtYzFeignService;
import cn.gtmap.realestate.common.core.support.i18n.MessageProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcYzhServiceImpl
implements BdcYzhService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcYzhMapper bdcYzhMapper;
    @Autowired
    private RedissonClient redissonClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcYzhServiceImpl.class);
    private static final Integer MAX_COUNT = 10;
    private static final String YZH_YZBSM = "yzyzhky";
    private static final String YZMS_ALERT = "alert";
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    MessageProvider messageProvider;
    @Autowired
    BdcGzQtYzFeignService bdcGzQtYzFeignService;

    public BdcYzhDTO queryBdcYzhAndYzhmx(String yzhid) {
        if (StringUtils.isBlank((CharSequence)yzhid)) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        BdcYzhDTO bdcYzhDTO = new BdcYzhDTO();
        BdcYzhQO bdcYzhQO = new BdcYzhQO();
        bdcYzhQO.setYzhid(yzhid);
        List bdcYzhDTOList = this.bdcYzhMapper.queryBdcYzh(bdcYzhQO);
        if (CollectionUtils.isNotEmpty((Collection)bdcYzhDTOList) && null != bdcYzhDTOList.get(0)) {
            bdcYzhDTO = (BdcYzhDTO)bdcYzhDTOList.get(0);
            List bdcYzhsymxDOList = this.queryBdcYzhsymx(bdcYzhDTO.getYzhid());
            bdcYzhDTO.setBdcYzhsymxDOList(bdcYzhsymxDOList);
        }
        return bdcYzhDTO;
    }

    public List<BdcYzhsymxDO> queryBdcYzhsymx(String yzhid) {
        if (StringUtils.isBlank((CharSequence)yzhid)) {
            throw new MissingArgumentException("\u7f3a\u5931\u5370\u5236\u53f7ID");
        }
        Example example = new Example(BdcYzhsymxDO.class);
        example.createCriteria().andEqualTo("yzhid", (Object)yzhid);
        List bdcYzhsymxDOList = this.entityMapper.selectByExampleNotNull(example);
        if (CollectionUtils.isNotEmpty((Collection)bdcYzhsymxDOList)) {
            return bdcYzhsymxDOList;
        }
        return new ArrayList<BdcYzhsymxDO>();
    }

    public List<BdcYzhDTO> queryListBdcYzh(BdcYzhQO bdcYzhQO) {
        if (null == bdcYzhQO) {
            throw new MissingArgumentException("\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570");
        }
        return this.bdcYzhMapper.queryBdcYzh(bdcYzhQO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BdcYzhsymxDO updateBdcYzhSyqk(BdcYzhSyqkQO bdcYzhSyqkQO) {
        if (null == bdcYzhSyqkQO || StringUtils.isBlank((CharSequence)bdcYzhSyqkQO.getYzhid())) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        if (StringUtils.isNotBlank((CharSequence)bdcYzhSyqkQO.getZsid())) {
            BdcZsDO bdcZsDO = new BdcZsDO();
            bdcZsDO.setZsid(bdcYzhSyqkQO.getZsid());
            bdcZsDO.setQzysxlh(bdcYzhSyqkQO.getQzysxlh());
            this.bdcZsService.updateBdcZs(bdcZsDO);
        }
        BdcYzhDO bdcYzhDO = new BdcYzhDO();
        bdcYzhDO.setYzhid(bdcYzhSyqkQO.getYzhid());
        bdcYzhDO.setSyqk(bdcYzhSyqkQO.getSyqk());
        bdcYzhDO.setZsid(bdcYzhSyqkQO.getZsid());
        this.entityMapper.updateByPrimaryKeySelective((Object)bdcYzhDO);
        BdcYzhsymxDO bdcYzhsymxDO = new BdcYzhsymxDO();
        bdcYzhsymxDO.setSyr(bdcYzhSyqkQO.getSyr());
        bdcYzhsymxDO.setSyrid(bdcYzhSyqkQO.getSyrid());
        bdcYzhsymxDO.setSyyy(bdcYzhSyqkQO.getSyyy());
        bdcYzhsymxDO.setSyqk(bdcYzhSyqkQO.getSyqk());
        bdcYzhsymxDO.setSysj(new Date());
        bdcYzhsymxDO.setYzhid(bdcYzhSyqkQO.getYzhid());
        bdcYzhsymxDO.setYzhsymxid(UUIDGenerator.generate());
        int result = this.entityMapper.insertSelective((Object)bdcYzhsymxDO);
        if (result > 0) {
            return bdcYzhsymxDO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public BdcYzhDTO queryBdcZsYzh(String zsid, BdcYzhQO bdcYzhQO) {
        if (StringUtils.isBlank((CharSequence)zsid) && null == bdcYzhQO) {
            throw new MissingArgumentException(this.messageProvider.getMessage("error.1002"));
        }
        int yzhNum = 1;
        String syyy = "\u8bc1\u4e66\u5370\u5236\u53f7\u83b7\u53d6";
        bdcYzhQO.setZsid(null);
        BdcYzhDTO bdcYzhDTO = (BdcYzhDTO)this.queryBatchYzh(yzhNum, bdcYzhQO).get(0);
        if (null != bdcYzhDTO && StringUtils.isNotBlank((CharSequence)bdcYzhDTO.getYzhid())) {
            BdcYzhSyqkQO bdcYzhSyqkQO = new BdcYzhSyqkQO();
            BeanUtils.copyProperties((Object)bdcYzhDTO, (Object)bdcYzhSyqkQO);
            bdcYzhSyqkQO.setZsid(zsid);
            bdcYzhSyqkQO.setSyqk(CommonConstantUtils.SYQK_YSY);
            bdcYzhSyqkQO.setSyyy(syyy);
            bdcYzhSyqkQO.setSyr(bdcYzhQO.getSyr());
            bdcYzhSyqkQO.setSyrid(bdcYzhQO.getSyrid());
            BdcYzhsymxDO bdcYzhsymxDO = this.updateBdcYzhSyqk(bdcYzhSyqkQO);
            ArrayList<BdcYzhsymxDO> bdcYzhsymxDOList = new ArrayList<BdcYzhsymxDO>();
            bdcYzhsymxDOList.add(bdcYzhsymxDO);
            bdcYzhDTO.setBdcYzhsymxDOList(bdcYzhsymxDOList);
        }
        return bdcYzhDTO;
    }

    public List<BdcYzhDTO> queryBatchYzh(int num, BdcYzhQO bdcYzhQO) {
        ArrayList<BdcYzhDTO> bdcYzhDTOList;
        block9: {
            bdcYzhDTOList = new ArrayList<BdcYzhDTO>();
            RLock rLock = null;
            try {
                rLock = this.redissonClient.getLock("REDISSON_LOCK_BDCYZH");
                if (!rLock.tryLock(60L, 30L, TimeUnit.SECONDS)) break block9;
                int count = 0;
                while (CollectionUtils.size(bdcYzhDTOList) < num) {
                    BdcYzhDTO bdcYzhDTO = this.getMinBdcYzh(bdcYzhQO);
                    if (null != bdcYzhDTO) {
                        bdcYzhDTOList.add(bdcYzhDTO);
                    }
                    if (count >= MAX_COUNT) {
                        break;
                    }
                    ++count;
                }
            }
            catch (Exception e) {
                LOGGER.error(this.messageProvider.getMessage("error.1003"), (Throwable)e);
                throw new AppException(Integer.valueOf(1003), this.messageProvider.getMessage("error.1003"));
            }
            finally {
                if (null != rLock) {
                    rLock.unlock();
                }
            }
        }
        return bdcYzhDTOList;
    }

    public BdcYzhDTO getMinBdcYzh(BdcYzhQO bdcYzhQO) {
        List bdcYzhDTOList = this.bdcYzhMapper.queryBdcYzh(bdcYzhQO);
        if (CollectionUtils.isNotEmpty((Collection)bdcYzhDTOList) && null != bdcYzhDTOList.get(0)) {
            return (BdcYzhDTO)bdcYzhDTOList.get(0);
        }
        return null;
    }

    public BdcGzyzTsxxDTO queryYzhYzxx(BdcYzhQO bdcYzhQO) {
        BdcGzQtYzQO bdcGzQtYzQO = new BdcGzQtYzQO();
        bdcGzQtYzQO.setYzbsm(YZH_YZBSM);
        bdcGzQtYzQO.setYzms(YZMS_ALERT);
        Map map = Object2MapUtils.object2MapExceptNull((Object)bdcYzhQO);
        bdcGzQtYzQO.setBdcgzyzsjmap(map);
        return this.bdcGzQtYzFeignService.queryBdcGzQtyzTsxx(bdcGzQtYzQO);
    }
}

