/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.service.impl;

import cn.gtmap.realestate.certificate.service.impl.BaseBdcBdcqzhServiceImpl;
import cn.gtmap.realestate.certificate.service.impl.BdcBdcqzhBhzServiceImpl;
import cn.gtmap.realestate.certificate.service.impl.BdcBdcqzhFhServiceImpl;
import cn.gtmap.realestate.certificate.service.impl.BdcBdcqzhMrServiceImpl;
import cn.gtmap.realestate.certificate.service.impl.BdcBdcqzhYlzhServiceImpl;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcXtZsbhmbDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcBdcqzhDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bdcBdcqzhServiceImpl")
public class BdcBdcqzhServiceImpl
extends BaseBdcBdcqzhServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcBdcqzhServiceImpl.class);
    private static final String CLASS_NAME = BdcBdcqzhServiceImpl.class.getName();
    @Autowired
    private BdcBdcqzhBhzServiceImpl bdcqzhBhzService;
    @Autowired
    private BdcBdcqzhYlzhServiceImpl bdcqzhYlzhService;
    @Autowired
    private BdcBdcqzhFhServiceImpl bdcqzhFhService;
    @Autowired
    private BdcBdcqzhMrServiceImpl bdcqzhMrService;

    @Transactional(rollbackFor={Exception.class})
    public List<BdcBdcqzhDTO> generateBdcqzh(String xmid) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            LOGGER.warn("{}\uff1a\u53c2\u6570\u9879\u76eeID\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7ec8\u6b62\uff01", (Object)CLASS_NAME);
            return Collections.emptyList();
        }
        BdcXmDO bdcXmDO = super.getBdcXm(xmid);
        BdcXtZsbhmbDO bdcXtZsbhmbDO = super.getBdcXtZsbhmb(bdcXmDO);
        ArrayList<BdcBdcqzhDTO> bdcBdcqzhDTOList = this.bdcqzhBhzService.generateBdcqzh(xmid);
        if (CollectionUtils.isNotEmpty((Collection)bdcBdcqzhDTOList)) {
            return bdcBdcqzhDTOList;
        }
        RLock rLock = null;
        try {
            rLock = this.redissonUtils.lock("REDISSON_LOCK_BDCQZH", 60L, 30L);
            List bdcZsDOList = super.getBdcZs(xmid);
            bdcBdcqzhDTOList = new ArrayList<BdcBdcqzhDTO>(bdcZsDOList.size());
            for (BdcZsDO bdcZsDO : bdcZsDOList) {
                if (null == bdcZsDO || !StringUtils.isBlank((CharSequence)bdcZsDO.getBdcqzh())) continue;
                BdcBdcqzhDTO bdcBdcqzhDTO = this.resolveBdcqzh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
                this.saveBdcqzh(bdcBdcqzhDTO);
                bdcBdcqzhDTOList.add(bdcBdcqzhDTO);
            }
            ArrayList<BdcBdcqzhDTO> arrayList = bdcBdcqzhDTOList;
            return arrayList;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AppException("\u83b7\u53d6\u8bc1\u4e66\uff08\u660e\uff09\u53f7\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
        finally {
            if (null != rLock) {
                rLock.unlock();
            }
        }
    }

    public BdcBdcqzhDTO resolveBdcqzh(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO, BdcXtZsbhmbDO bdcXtZsbhmbDO) {
        BdcBdcqzhDTO bdcBdcqzhDTO;
        if (this.ylzh.booleanValue() && null != (bdcBdcqzhDTO = this.bdcqzhYlzhService.resolveBdcqzh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO))) {
            return bdcBdcqzhDTO;
        }
        if (this.fh.booleanValue() && null != (bdcBdcqzhDTO = this.bdcqzhFhService.resolveBdcqzh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO))) {
            return bdcBdcqzhDTO;
        }
        return this.bdcqzhMrService.resolveBdcqzh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
    }
}

