/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.web.rest;

import cn.gtmap.realestate.certificate.config.PropsConfig;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.certificate.service.BdcZsPrintService;
import cn.gtmap.realestate.certificate.util.QRcodeUtils;
import cn.gtmap.realestate.certificate.web.BaseController;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.util.IPPortUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e0d\u52a8\u4ea7\u8bc1\u4e66\u6253\u5370\u670d\u52a1\u63a5\u53e3"})
public class BdcZsPrintRestController
extends BaseController {
    private static final String PROJECT_PATH = "/realestate-certificate/rest/v1.0/zs/print/";
    @Autowired
    PropsConfig propsConfig;
    @Autowired
    BdcZsPrintService bdcZsPrintService;
    @Autowired
    BdcZsService bdcZsService;

    @GetMapping(value={"/realestate-certificate/rest/v1.0/zs/print/{xmid}/{zslx}"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u8bc1\u4e66\u6253\u5370")
    @ApiImplicitParams(value={@ApiImplicitParam(name="xmid", value="\u9879\u76eeID", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="zslx", value="\u8bc1\u4e66\u7c7b\u578b(\u8bc1\u4e66\uff1azs\uff0c\u8bc1\u660e:zm,\u9996\u6b21\u8bc1\u660e\u5355\uff1azmd)", required=true, dataType="string", paramType="path")})
    public void zsPrinting(@PathVariable(name="xmid") String xmid, @PathVariable(name="zslx") String zslx, HttpServletResponse response) throws IOException {
        String serverPath = IPPortUtils.serverPath();
        if (StringUtils.isBlank((CharSequence)serverPath)) {
            throw new MissingArgumentException("\u670d\u52a1\u5730\u5740\u83b7\u53d6\u5f02\u5e38\uff01");
        }
        String zsPrintXmlUrl = serverPath + PROJECT_PATH + xmid + "/" + zslx + "/xml";
        String fr3Url = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        String templetPath = this.propsConfig.getTemplatePathOfMapItem((Object)zslx);
        if (StringUtils.isNotBlank((CharSequence)templetPath)) {
            fr3Url = fr3Url + "<frs><fr url=\"eprt://v2|designMode=false|frURL=" + templetPath + "|dataURL=" + zsPrintXmlUrl + "|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini|hiddeMode=" + true + "\"/></frs>";
            this.LOGGER.info(fr3Url);
            response.setContentType("text/xml;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.write(fr3Url);
            out.flush();
            out.close();
        }
    }

    @GetMapping(value={"/realestate-certificate/rest/v1.0/zs/print/{xmid}/{zslx}/xml"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8bc1\u4e66\u6253\u5370XMl")
    @ApiImplicitParams(value={@ApiImplicitParam(name="xmid", value="\u9879\u76eeID", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="zslx", value="\u8bc1\u4e66\u7c7b\u578b\u4ee3\u7801", required=true, dataType="String", paramType="path")})
    public String zsPrintXml(@PathVariable(name="xmid") String xmid, @PathVariable(name="zslx") String zslx) {
        return this.bdcZsPrintService.zsPrintXml(xmid, zslx);
    }

    @GetMapping(value={"/realestate-certificate/rest/v1.0/zs/print/{zsid}/ewm"})
    @ResponseStatus(code=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8bc1\u4e66\u4e8c\u7ef4\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="zsid", value="\u8bc1\u4e66ID", required=true, dataType="String", paramType="path")})
    public void ewmStream(@PathVariable(name="zsid") String zsid, HttpServletResponse response) {
        String content = "";
        if (StringUtils.isNotBlank((CharSequence)zsid)) {
            content = zsid;
            BdcZsDO bdcZsDO = this.bdcZsService.queryBdcZs(zsid);
            if (null != bdcZsDO && StringUtils.isNotBlank((CharSequence)bdcZsDO.getEwmnr())) {
                content = bdcZsDO.getEwmnr();
            }
        }
        response.setContentType("image/jpg;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment; filename=test.jpg");
        QRcodeUtils.encoderQRCode((String)content, null, (HttpServletResponse)response);
    }
}

