/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.service.impl;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.realestate.certificate.core.dto.BdcFzjlDTO;
import cn.gtmap.realestate.certificate.core.dto.BdcLzrDTO;
import cn.gtmap.realestate.certificate.core.mapper.BdcZsMapper;
import cn.gtmap.realestate.certificate.core.service.BdcQlrService;
import cn.gtmap.realestate.certificate.core.service.BdcXmService;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.certificate.service.BdcFzjlService;
import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BdcFzjlServiceImpl
implements BdcFzjlService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcZsMapper bdcZsMapper;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcQlrService bdcQlrService;

    private static String generateFzjlBz(Integer zslx, List<String> zsidList) {
        StringBuilder bz = new StringBuilder();
        if (CollectionUtils.isNotEmpty(zsidList)) {
            if (CommonConstantUtils.ZSLX_ZS.equals(zslx)) {
                bz = bz.append("\u8bc1\u4e66").append("\uff1a").append(CollectionUtils.size(zsidList)).append("\u672c\u3002");
            }
            if (CommonConstantUtils.ZSLX_ZM.equals(zslx)) {
                bz = bz.append("\u8bc1\u660e").append("\uff1a").append(CollectionUtils.size(zsidList)).append("\u672c\u3002");
            }
        }
        return bz.toString();
    }

    private static List<BdcLzrDTO> generateBdcZsDTO(List<BdcZsDO> bdcZsDOList, List<String> zsidList, boolean batch) {
        ArrayList<BdcLzrDTO> bdcLzrDTOList = new ArrayList<BdcLzrDTO>();
        for (BdcZsDO bdcZsDO : bdcZsDOList) {
            BdcLzrDTO bdcLzrDTO = new BdcLzrDTO();
            bdcLzrDTO.setQlr(bdcZsDO.getQlr());
            bdcLzrDTO.setLzr(bdcZsDO.getLzr());
            bdcLzrDTO.setLzrzjh(bdcZsDO.getLzrzjh());
            if (batch) {
                bdcLzrDTO.setBdcqzh(bdcZsDO.getBdcqzh() + "\u7b49");
                bdcLzrDTO.setZsidList(zsidList);
                bdcLzrDTOList.add(bdcLzrDTO);
                break;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(bdcZsDO.getZsid());
            bdcLzrDTO.setZsidList(stringList);
            bdcLzrDTO.setBdcqzh(bdcZsDO.getBdcqzh());
            bdcLzrDTOList.add(bdcLzrDTO);
        }
        return bdcLzrDTOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateFzjlLzr(String xmid, List<BdcLzrDTO> bdcLzrDTOList) {
        if (StringUtils.isBlank((CharSequence)xmid) || CollectionUtils.isEmpty(bdcLzrDTOList) || null == bdcLzrDTOList.get(0)) {
            throw new MissingArgumentException("\u7f3a\u5931\u9879\u76eeID\u6216\u8bc1\u4e66\u9886\u8bc1\u4eba\u4fe1\u606f\uff01");
        }
        int result = 0;
        for (BdcLzrDTO bdcLzrDTO : bdcLzrDTOList) {
            if (null == bdcLzrDTO) continue;
            int temp = this.bdcZsService.updateLzr(bdcLzrDTO);
            result += temp;
        }
        return result;
    }

    public BdcFzjlDTO queryBdcFzjl(String xmid, boolean batch) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException("\u7f3a\u5931\u9879\u76eeID");
        }
        BdcXmDO bdcXmDO = (BdcXmDO)this.entityMapper.selectByPrimaryKey(BdcXmDO.class, (Object)xmid);
        List bdcZsDOList = this.bdcZsService.queryBdcZsByXmid(xmid);
        if (CollectionUtils.isNotEmpty((Collection)bdcZsDOList) && null != bdcZsDOList.get(0)) {
            BdcZsDO bdcZsDOTemp = (BdcZsDO)bdcZsDOList.get(0);
            BdcFzjlDTO bdcFzjlDTO = new BdcFzjlDTO();
            bdcFzjlDTO.setSlbh(bdcXmDO.getSlbh());
            bdcFzjlDTO.setXmid(xmid);
            bdcFzjlDTO.setSzr(bdcZsDOTemp.getSzr());
            bdcFzjlDTO.setFzr(bdcZsDOTemp.getFzr());
            bdcFzjlDTO.setFzrq(DateUtils.format((Date)bdcZsDOTemp.getFzsj(), (String)"yyyy-MM-dd"));
            bdcFzjlDTO.setZl(bdcZsDOTemp.getZl());
            if (batch) {
                bdcFzjlDTO.setZl(bdcFzjlDTO.getZl() + "\u7b49");
            }
            List zsidList = this.bdcZsMapper.getBatchZsid(xmid);
            String bz = BdcFzjlServiceImpl.generateFzjlBz((Integer)bdcZsDOTemp.getZslx(), (List)zsidList);
            bdcFzjlDTO.setBz(bz);
            List bdcLzrDTOList = BdcFzjlServiceImpl.generateBdcZsDTO((List)bdcZsDOList, (List)zsidList, (boolean)batch);
            bdcFzjlDTO.setBdcZsDTOList(bdcLzrDTOList);
            this.generateFzjlSqrxx(xmid, bdcFzjlDTO);
            return bdcFzjlDTO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateFzjlBz(String xmid, boolean batch, String bz) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException("\u7f3a\u5931xmid!");
        }
        int result = 0;
        if (batch) {
            List bdcXmDOList = this.bdcXmService.queryListBdcXm(xmid, null);
            for (BdcXmDO bdcXmDOTemp : bdcXmDOList) {
                result += this.bdcXmService.updateXmBz(bdcXmDOTemp.getXmid(), bz);
            }
        } else {
            return this.bdcXmService.updateXmBz(xmid, bz);
        }
        return result;
    }

    public int updateFzr(String xmid, UserDto fzr) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException("\u7f3a\u5931\u9879\u76eeID");
        }
        List zsidList = this.bdcZsMapper.getBatchZsid(xmid);
        return this.bdcZsService.updateFzr(zsidList, fzr);
    }

    private void generateFzjlSqrxx(String xmid, BdcFzjlDTO bdcFzjlDTO) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            throw new MissingArgumentException("\u7f3a\u5931\u9879\u76eeID");
        }
        List bdcQlrDOList = this.bdcQlrService.queryListBdcQlr(xmid, CommonConstantUtils.QLRLB_QLR_DM);
        StringBuilder sqr = new StringBuilder();
        StringBuilder sqrlxdh = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
            for (BdcQlrDO bdcQlrDO : bdcQlrDOList) {
                if (null == bdcQlrDO) continue;
                sqr = sqr.append(bdcQlrDO.getQlrmc()).append(" ");
                sqrlxdh = sqrlxdh.append(bdcQlrDO.getDh()).append(" ");
            }
        }
        bdcFzjlDTO.setSqr(sqr.toString());
        bdcFzjlDTO.setSqrlxdh(sqrlxdh.toString());
    }
}

