/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.service.impl;

import cn.gtmap.realestate.certificate.core.service.BdcXmService;
import cn.gtmap.realestate.certificate.core.service.BdcXtFhService;
import cn.gtmap.realestate.certificate.core.service.BdcXtYlzhService;
import cn.gtmap.realestate.certificate.core.service.BdcXtZsbhmbService;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.certificate.service.BdcBdcqzhService;
import cn.gtmap.realestate.common.core.domain.BdcCshFwkgSlDO;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.BdcXmLsgxDO;
import cn.gtmap.realestate.common.core.domain.BdcXtFhDO;
import cn.gtmap.realestate.common.core.domain.BdcXtYlzhDO;
import cn.gtmap.realestate.common.core.domain.BdcXtZsbhmbDO;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcBdcqzhDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcXtFhDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcZhDTO;
import cn.gtmap.realestate.common.core.enums.BdcZslxEnum;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.ex.EntityNotFoundException;
import cn.gtmap.realestate.common.core.service.feign.init.BdcXmFeignService;
import cn.gtmap.realestate.common.util.CommonConstantUtils;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import cn.gtmap.realestate.common.util.redisson.RedissonUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcBdcqzhServiceImpl
implements BdcBdcqzhService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcBdcqzhServiceImpl.class);
    private static final String CLASS_NAME = BdcBdcqzhServiceImpl.class.getName();
    @Value(value="${certificate.switch.ylzh}")
    private Boolean ylzh;
    @Value(value="${certificate.switch.fh}")
    private Boolean fh;
    @Value(value="${certificate.switch.sqdm}")
    private Boolean sqdm;
    @Autowired
    private RedissonUtils redissonUtils;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcXtZsbhmbService bdcXtZsbhmbService;
    @Autowired
    private BdcXtYlzhService bdcXtYlzhService;
    @Autowired
    private BdcXtFhService bdcXtFhService;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcXmFeignService bdcXmFeignService;

    @Transactional(rollbackFor={Exception.class})
    public List<BdcBdcqzhDTO> generateBdcqzh(String xmid) {
        if (StringUtils.isBlank((CharSequence)xmid)) {
            LOGGER.warn("{}\uff1a\u53c2\u6570\u9879\u76eeID\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7ec8\u6b62\uff01", (Object)CLASS_NAME);
            return Collections.emptyList();
        }
        ArrayList<BdcBdcqzhDTO> bdcBdcqzhDTOList = this.resolveBhz(xmid);
        if (CollectionUtils.isNotEmpty((Collection)bdcBdcqzhDTOList)) {
            return bdcBdcqzhDTOList;
        }
        BdcXmDO bdcXmDO = this.getBdcXm(xmid);
        List bdcZsDOList = this.getBdcZs(xmid);
        BdcXtZsbhmbDO bdcXtZsbhmbDO = this.getBdcXtZsbhmb(bdcXmDO);
        RLock rLock = null;
        try {
            rLock = this.redissonUtils.lock("BDCQZH:" + UUIDGenerator.generate(), 60L, 30L);
            bdcBdcqzhDTOList = new ArrayList<BdcBdcqzhDTO>(bdcZsDOList.size());
            for (BdcZsDO bdcZsDO : bdcZsDOList) {
                if (null == bdcZsDO || !StringUtils.isBlank((CharSequence)bdcZsDO.getBdcqzh())) continue;
                BdcBdcqzhDTO bdcBdcqzhDTO = this.resolveBdcqzh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
                this.saveBdcqzh(bdcBdcqzhDTO);
                bdcBdcqzhDTOList.add(bdcBdcqzhDTO);
            }
            ArrayList<BdcBdcqzhDTO> arrayList = bdcBdcqzhDTOList;
            return arrayList;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AppException("\u83b7\u53d6\u8bc1\u4e66\uff08\u660e\uff09\u53f7\u5904\u7406\u5f02\u5e38\uff01");
        }
        finally {
            if (null != rLock) {
                rLock.unlock();
            }
        }
    }

    private List<BdcBdcqzhDTO> resolveBhz(String xmid) {
        BdcCshFwkgSlDO bdcCshFwkgSlDO = this.bdcXmFeignService.queryFwkgsl(xmid);
        if (null == bdcCshFwkgSlDO || !CommonConstantUtils.SF_F_DM.equals(bdcCshFwkgSlDO.getSfhz())) {
            return Collections.emptyList();
        }
        List dqBdcZsDOList = this.getBdcZs(xmid);
        if (CollectionUtils.isEmpty((Collection)dqBdcZsDOList)) {
            throw new AppException("\u83b7\u53d6\u8bc1\u53f7\u4e0d\u6362\u8bc1\u573a\u666f\uff0c\u5f53\u524d\u9879\u76ee\u5bf9\u5e94\u8bc1\u4e66\u4e3a\u7a7a\uff01");
        }
        List bdcXmLsgxDOList = this.bdcXmService.queryBdcXmLsgxByXmid(xmid);
        if (CollectionUtils.isEmpty((Collection)bdcXmLsgxDOList)) {
            throw new AppException("\u83b7\u53d6\u8bc1\u53f7\u4e0d\u6362\u8bc1\u573a\u666f\uff0c\u9879\u76ee\u5386\u53f2\u5173\u7cfb\u4e3a\u7a7a\uff01");
        }
        String yxmid = ((BdcXmLsgxDO)bdcXmLsgxDOList.get(0)).getYxmid();
        List yBdcZsDOList = this.bdcZsService.queryBdcZsByXmid(yxmid);
        ArrayList<BdcBdcqzhDTO> bdcBdcqzhDTOList = new ArrayList<BdcBdcqzhDTO>(yBdcZsDOList.size());
        for (int i = 0; i < yBdcZsDOList.size(); ++i) {
            BdcZsDO yBdcZsDO = (BdcZsDO)CollectionUtils.get((Object)yBdcZsDOList, (int)i);
            BdcZsDO dqBdcZsDO = (BdcZsDO)CollectionUtils.get((Object)dqBdcZsDOList, (int)i);
            if (null == yBdcZsDO || StringUtils.isBlank((CharSequence)yBdcZsDO.getBdcqzh()) || null == dqBdcZsDO || StringUtils.isBlank((CharSequence)dqBdcZsDO.getZsid())) continue;
            BdcBdcqzhDTO bdcBdcqzhDTO = new BdcBdcqzhDTO();
            bdcBdcqzhDTO.setZsid(dqBdcZsDO.getZsid());
            bdcBdcqzhDTO.setZslx(yBdcZsDO.getZslx());
            bdcBdcqzhDTO.setBdcqzh(yBdcZsDO.getBdcqzh().replace("\uff08\u9500\uff09", ""));
            bdcBdcqzhDTO.setNf(yBdcZsDO.getNf());
            bdcBdcqzhDTO.setSqsjc(yBdcZsDO.getSqsjc());
            bdcBdcqzhDTO.setSzsxqc(yBdcZsDO.getSzsxqc());
            bdcBdcqzhDTO.setZhlsh(yBdcZsDO.getZhlsh());
            bdcBdcqzhDTOList.add(bdcBdcqzhDTO);
            if (!StringUtils.contains((CharSequence)yBdcZsDO.getBdcqzh(), (CharSequence)"\uff08\u9500\uff09")) {
                BdcZsDO yBdcZsDo = new BdcZsDO();
                yBdcZsDo.setZsid(yBdcZsDO.getZsid());
                yBdcZsDo.setBdcqzh(yBdcZsDO.getBdcqzh() + "\uff08\u9500\uff09");
                this.bdcZsService.updateBdcZs(yBdcZsDo);
            }
            this.saveBdcqzh(bdcBdcqzhDTO);
        }
        return bdcBdcqzhDTOList;
    }

    private BdcXmDO getBdcXm(String xmid) {
        List bdcXmDOList = this.bdcXmService.queryListBdcXm(xmid, null);
        if (CollectionUtils.isEmpty((Collection)bdcXmDOList)) {
            LOGGER.warn("{}\uff1a\u67e5\u8be2{}\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7ec8\u6b62\uff01", (Object)CLASS_NAME, (Object)xmid);
            throw new EntityNotFoundException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u9879\u76ee\uff01");
        }
        return (BdcXmDO)bdcXmDOList.get(0);
    }

    private List<BdcZsDO> getBdcZs(String xmid) {
        List bdcZsDOList = this.bdcZsService.queryBdcZsByXmid(xmid);
        if (CollectionUtils.isEmpty((Collection)bdcZsDOList)) {
            LOGGER.warn("{}\uff1a\u9879\u76eeID{}\u672a\u67e5\u8be2\u5230\u5173\u8054\u8bc1\u4e66\u4fe1\u606f\uff0c\u83b7\u53d6\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7ec8\u6b62\uff01", (Object)CLASS_NAME, (Object)xmid);
            throw new EntityNotFoundException("\u9879\u76ee\u65e0\u5bf9\u5e94\u8bc1\u4e66\u8bb0\u5f55\uff01");
        }
        return bdcZsDOList;
    }

    private BdcXtZsbhmbDO getBdcXtZsbhmb(BdcXmDO bdcXmDO) {
        BdcXtZsbhmbDO bdcXtZsbhmbDO = this.bdcXtZsbhmbService.queryBdcXtZsbhmb(bdcXmDO);
        if (null == bdcXtZsbhmbDO) {
            LOGGER.warn("{}\uff1a\u9879\u76eeID{}\u672a\u67e5\u8be2\u5230\u5173\u8054\u8bc1\u4e66\u7f16\u53f7\u6a21\u677f\uff0c\u83b7\u53d6\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u7ec8\u6b62\uff01", (Object)CLASS_NAME, (Object)bdcXmDO.getXmid());
            throw new EntityNotFoundException("\u9879\u76ee\u65e0\u5bf9\u5e94\u8bc1\u4e66\u7f16\u53f7\u6a21\u677f\uff01");
        }
        return bdcXtZsbhmbDO;
    }

    private BdcBdcqzhDTO resolveBdcqzh(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO, BdcXtZsbhmbDO bdcXtZsbhmbDO) {
        BdcBdcqzhDTO bdcBdcqzhDTO;
        if (this.ylzh.booleanValue() && null != (bdcBdcqzhDTO = this.getBdcqzhFromYlzh(bdcZsDO))) {
            return bdcBdcqzhDTO;
        }
        if (this.fh.booleanValue() && null != (bdcBdcqzhDTO = this.getBdcqzhFromFh(bdcXmDO, bdcZsDO))) {
            return bdcBdcqzhDTO;
        }
        return this.getBdcqzhDefault(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
    }

    private BdcBdcqzhDTO getBdcqzhFromYlzh(BdcZsDO bdcZsDO) {
        BdcXtYlzhDO bdcXtYlzhDO = this.bdcXtYlzhService.queryBdcXtYlzh(bdcZsDO.getZsid());
        if (null == bdcXtYlzhDO || StringUtils.isBlank((CharSequence)bdcXtYlzhDO.getYlzhid())) {
            return null;
        }
        BdcBdcqzhDTO bdcBdcqzhDTO = new BdcBdcqzhDTO();
        bdcBdcqzhDTO.setZsid(bdcZsDO.getZsid());
        bdcBdcqzhDTO.setZslx(bdcZsDO.getZslx());
        bdcBdcqzhDTO.setBdcqzh(bdcXtYlzhDO.getBdcqzh());
        bdcBdcqzhDTO.setNf(bdcXtYlzhDO.getNf());
        bdcBdcqzhDTO.setSqsjc(bdcXtYlzhDO.getSqsjc());
        bdcBdcqzhDTO.setSzsxqc(bdcXtYlzhDO.getSzsxqc());
        bdcBdcqzhDTO.setZhlsh(bdcXtYlzhDO.getZhlsh());
        bdcXtYlzhDO.setSyqk(CommonConstantUtils.SYQK_YSY);
        bdcXtYlzhDO.setZsid(bdcZsDO.getZsid());
        this.bdcXtYlzhService.updateBdcXtYlzhSyqk(bdcXtYlzhDO);
        return bdcBdcqzhDTO;
    }

    private BdcBdcqzhDTO getBdcqzhFromFh(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO) {
        BdcXtFhDTO bdcXtFhDTO = new BdcXtFhDTO();
        bdcXtFhDTO.setQxdm(bdcXmDO.getQxdm());
        bdcXtFhDTO.setNf(String.valueOf(Calendar.getInstance().get(1)));
        bdcXtFhDTO.setZslx(bdcZsDO.getZslx());
        BdcXtFhDO bdcXtFhDO = this.bdcXtFhService.queryBdcXtFh(bdcXtFhDTO);
        if (null == bdcXtFhDO || StringUtils.isBlank((CharSequence)bdcXtFhDO.getFczhid())) {
            return null;
        }
        BdcBdcqzhDTO bdcBdcqzhDTO = new BdcBdcqzhDTO();
        bdcBdcqzhDTO.setZsid(bdcZsDO.getZsid());
        bdcBdcqzhDTO.setZslx(bdcZsDO.getZslx());
        bdcBdcqzhDTO.setBdcqzh(bdcXtFhDO.getBdcqzh());
        bdcBdcqzhDTO.setNf(bdcXtFhDO.getNf());
        bdcBdcqzhDTO.setSqsjc(bdcXtFhDO.getSqsjc());
        bdcBdcqzhDTO.setSzsxqc(bdcXtFhDO.getSzsxqc());
        bdcBdcqzhDTO.setZhlsh(bdcXtFhDO.getZhlsh());
        bdcXtFhDO.setSyqk(CommonConstantUtils.SYQK_YSY);
        this.bdcXtFhService.updateBdcXtFhSyqk(bdcXtFhDO);
        return bdcBdcqzhDTO;
    }

    private BdcBdcqzhDTO getBdcqzhDefault(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO, BdcXtZsbhmbDO bdcXtZsbhmbDO) {
        String sqsjc = bdcXtZsbhmbDO.getSqsjc();
        String nf = bdcXtZsbhmbDO.getNf();
        String szsxqc = bdcXtZsbhmbDO.getSzsxqc();
        String zhlx = BdcZslxEnum.getZhlx((Integer)bdcZsDO.getZslx());
        String lsh = this.getLsh(bdcXmDO, bdcZsDO, bdcXtZsbhmbDO);
        StringBuilder builder = new StringBuilder();
        builder.append(sqsjc);
        builder.append("(");
        builder.append(nf);
        builder.append(")");
        builder.append(szsxqc);
        builder.append(zhlx);
        builder.append("\u7b2c");
        builder.append(lsh);
        builder.append("\u53f7");
        String bdcqzh = builder.toString();
        BdcBdcqzhDTO bdcBdcqzhDTO = new BdcBdcqzhDTO();
        bdcBdcqzhDTO.setZsid(bdcZsDO.getZsid());
        bdcBdcqzhDTO.setZslx(bdcZsDO.getZslx());
        bdcBdcqzhDTO.setBdcqzh(bdcqzh);
        bdcBdcqzhDTO.setNf(nf);
        bdcBdcqzhDTO.setSqsjc(sqsjc);
        bdcBdcqzhDTO.setSzsxqc(szsxqc);
        bdcBdcqzhDTO.setZhlsh(lsh);
        return bdcBdcqzhDTO;
    }

    private String getLsh(BdcXmDO bdcXmDO, BdcZsDO bdcZsDO, BdcXtZsbhmbDO bdcXtZsbhmbDO) {
        String zssxh;
        BdcZhDTO bdcZhDTO = new BdcZhDTO();
        bdcZhDTO.setZslx(bdcZsDO.getZslx());
        bdcZhDTO.setNf(String.valueOf(Calendar.getInstance().get(1)));
        bdcZhDTO.setQxdm(bdcXmDO.getQxdm());
        bdcZhDTO.setYlzhByKg(this.ylzh);
        bdcZhDTO.setFhByKg(this.fh);
        Integer sxh = this.bdcZsService.queryMaxSxh(bdcZhDTO);
        if (null == sxh) {
            sxh = 0;
        }
        if ((zssxh = String.valueOf(sxh = Integer.valueOf(sxh + 1))).length() < bdcXtZsbhmbDO.getBdcqzhws()) {
            while ((zssxh = StringUtils.join((Object[])new String[]{"0", zssxh})).length() < bdcXtZsbhmbDO.getBdcqzhws()) {
            }
        }
        if (this.sqdm.booleanValue()) {
            zssxh = bdcXtZsbhmbDO.getSqdm() + zssxh.substring(2);
        }
        return zssxh;
    }

    private void saveBdcqzh(BdcBdcqzhDTO bdcBdcqzhDTO) {
        if (null == bdcBdcqzhDTO || StringUtils.isBlank((CharSequence)bdcBdcqzhDTO.getZsid())) {
            return;
        }
        BdcZsDO bdcZsDO = new BdcZsDO();
        bdcZsDO.setZsid(bdcBdcqzhDTO.getZsid());
        bdcZsDO.setBdcqzh(bdcBdcqzhDTO.getBdcqzh());
        bdcZsDO.setZhlsh(bdcBdcqzhDTO.getZhlsh());
        bdcZsDO.setNf(bdcBdcqzhDTO.getNf());
        bdcZsDO.setSqsjc(bdcBdcqzhDTO.getSqsjc());
        bdcZsDO.setSzsxqc(bdcBdcqzhDTO.getSzsxqc());
        this.bdcZsService.updateBdcZs(bdcZsDO);
    }
}

