/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.certificate.core.service.impl;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.realestate.certificate.core.dto.BdcLzrDTO;
import cn.gtmap.realestate.certificate.core.mapper.BdcZsMapper;
import cn.gtmap.realestate.certificate.core.qo.BdcZsQO;
import cn.gtmap.realestate.certificate.core.service.BdcZsService;
import cn.gtmap.realestate.common.core.domain.BdcZsDO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcZhDTO;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.ex.UserInformationAccessException;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BdcZsServiceImpl
implements BdcZsService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcZsMapper bdcZsMapper;

    public BdcZsDO queryBdcZs(String zsid) {
        if (StringUtils.isNotBlank((CharSequence)zsid)) {
            Example example = new Example(BdcZsDO.class);
            example.createCriteria().andEqualTo("zsid", (Object)zsid);
            List bdcZsList = this.entityMapper.selectByExampleNotNull(example);
            if (CollectionUtils.isNotEmpty((Collection)bdcZsList)) {
                return (BdcZsDO)bdcZsList.get(0);
            }
        }
        return null;
    }

    public List<BdcZsDO> queryBdcZsByXmid(String xmid) {
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("xmid", xmid);
            return this.bdcZsMapper.listBdcZs(map);
        }
        return new ArrayList<BdcZsDO>();
    }

    public List<BdcZsDO> listBdcZs(BdcZsQO bdcZsQO) {
        if (null != bdcZsQO) {
            Example example = new Example(BdcZsDO.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank((CharSequence)bdcZsQO.getBdcdyh())) {
                criteria.andEqualTo("bdcdyh", (Object)bdcZsQO.getBdcdyh());
            }
            if (StringUtils.isNotBlank((CharSequence)bdcZsQO.getBdcqzh())) {
                criteria.andEqualTo("bdcqzh", (Object)bdcZsQO.getBdcqzh());
            }
            if (StringUtils.isNotBlank((CharSequence)bdcZsQO.getZl())) {
                criteria.andEqualTo("zl", (Object)bdcZsQO.getZl());
            }
            return this.entityMapper.selectByExampleNotNull(example);
        }
        return new ArrayList<BdcZsDO>();
    }

    public int updateBdcZs(BdcZsDO bdcZsDO) {
        if (StringUtils.isBlank((CharSequence)bdcZsDO.getZsid())) {
            throw new NullPointerException("\u66f4\u65b0\u65f6\u5b9e\u4f53\u5bf9\u8c61BdcZsDO\u4e3b\u952ezsid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.entityMapper.updateByPrimaryKeySelective((Object)bdcZsDO);
    }

    public int updateLzr(BdcLzrDTO bdcLzrDTO) {
        if (CollectionUtils.isNotEmpty((Collection)bdcLzrDTO.getZsidList())) {
            Date lzsj = new Date();
            int result = 0;
            for (String zsid : bdcLzrDTO.getZsidList()) {
                BdcZsDO bdcZsDO = new BdcZsDO();
                bdcZsDO.setZsid(zsid);
                bdcZsDO.setLzr(bdcLzrDTO.getLzr());
                bdcZsDO.setLzrzjh(bdcLzrDTO.getLzrzjh());
                bdcZsDO.setLzsj(lzsj);
                result += this.updateBdcZs(bdcZsDO);
            }
            return result;
        }
        return 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateFzr(List<String> zsidList, UserDto fzr) {
        if (null == fzr) {
            throw new UserInformationAccessException("\u65e0\u6cd5\u83b7\u53d6\u53d1\u8bc1\u4eba\u4fe1\u606f");
        }
        int result = 0;
        Date fzsj = new Date();
        String fzrName = fzr.getUsername();
        String fzrId = fzr.getId();
        for (String zsid : zsidList) {
            BdcZsDO bdcZsDO = new BdcZsDO();
            bdcZsDO.setZsid(zsid);
            bdcZsDO.setFzrid(fzrId);
            bdcZsDO.setFzr(fzrName);
            bdcZsDO.setFzsj(fzsj);
            result += this.entityMapper.updateByPrimaryKeySelective((Object)bdcZsDO);
        }
        return result;
    }

    public int countBdcZs(BdcZsQO bdcZsQO) {
        if (null == bdcZsQO) {
            throw new MissingArgumentException("\u7f3a\u5931\u8bc1\u4e66\u67e5\u8be2\u53c2\u6570");
        }
        return this.bdcZsMapper.countBdcZs(bdcZsQO);
    }

    public Integer queryMaxSxh(BdcZhDTO bdcZhDTO) {
        if (null == bdcZhDTO || StringUtils.isBlank((CharSequence)bdcZhDTO.getQxdm())) {
            return null;
        }
        return this.bdcZsMapper.queryMaxSxh(bdcZhDTO);
    }
}

