
function initXmTable() {
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        $(document).keydown(function (event) {
            if (event.keyCode == 13) { //绑定回车
                $("#queryXm").click();
            }
        });


        //不动产单元号的表头
        var unitTableTitle = [{type: 'checkbox', fixed: 'left'},
            {field: 'bdcdyh', title: '不动产单元号', width: "24%", templet: '#bdcdyh', event: 'cshBdcXm'},
            {field: 'bdcqzh', title: '不动产权证号', width: "24%"},
            {field: 'zl', title: '坐落', width: "24%"},
            {field: 'qlrmc', title: '权利人', width: "12%"},
            {field: 'zt', title: '状态', width: "17%", templet: '#bdcdyzt', align: "center"},
            {field: 'cz', title: '操作', width: "6%", templet: '#bdcdycz'}
        ]

        //提交表单
        form.on("submit(queryXm)", function (data) {
            var url = acceptUiUrl + '/bdcdyh/listXmByPageJson'
            tableReload('xmid', data.field, url)
            return false;
        })

        var tableConfig = {
            id: 'xmid',
            toolbar: "#toolbarXm",
            // url: '/selectBdcdyh/schs/page',
            cols: [unitTableTitle]
        }

        //加载表格
        loadDataTablbeByUrl('#xmList', tableConfig);
        //表格初始化
        table.init('xmList', tableConfig)
        //头工具栏事件
        table.on('toolbar(xmList)', function (obj) {
            var data = obj.data; //获得当前行数据
            var layEvent = obj.event; //获得 lay-event 对应的值
            var tr = obj.tr; //获得当前行 tr 的DOM对象
            if (layEvent == "addXmShoppingCar") { //添加到购物车
                var loadMsg = loading();
                var checkStatus = table.checkStatus(obj.config.id), checkData = checkStatus.data;
                if (checkData != null && checkData.length > 0) {
                    checkXm(checkData)
                }
            }
            if (layEvent == "selectedXx") { //已选择不动产单元
                layer.open({
                    type: 2,
                    title: "已选信息",
                    area: ['1150px', '600px'],
                    fixed: false, //不固定
                    maxmin: true, //开启最大化最小化按钮
                    content: acceptUiUrl + '/view/query/gwc.html?jbxxid=' + processInsId
                });
            }
            if (layEvent == "allSelect") {  //全选
                $('.layui-unselect').click();
            }
        });
        table.on('tool(xmList)', function (obj) { //bdcdyhList为table的lay-filter对应的值
            if (obj.event === 'cshBdcXm') {
                var checkData = obj.data;
                if (checkData !== null) {
                    var loadMsg = loading();
                    checkXmSingle(checkData);//单个验证
                }
            }
        });
    })
}


function checkXmSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcGzYzsjDTO = new Object();
    bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
    selectDataList.push(bdcGzYzsjDTO);
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    // bdcGzZhQO.gzldyid = processInsId;
    var result = qzyzBdcdyh(bdcGzZhQO);
    if (result.msg === "success") {
        $.ajax({
            url: acceptUiUrl + '/bdcGzyz?gzlslid=' + processInsId,
            type: 'POST',
            dataType: 'json',
            contentType: "application/json;charset=UTF-8",
            data: JSON.stringify(bdcGzZhQO),
            success: function (data) {
                if (data.msg == "success") {
                    addXmShoppingCarSingle(checkData);
                } else {
                    layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告', btnAlign: 'c'}, function (index) {
                        layer.alert("暂未开放");
                    });
                }
            },error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    } else {
        layer.confirm(result.msg, {icon: 5, btn: '详情', title: '警告', btnAlign: 'c'}, function (index) {
            layer.alert("暂未开放");
        });
    }
}

function checkXm(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcGzYzsjDTO = new Object();
        bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
        selectDataList.push(bdcGzYzsjDTO);
    }
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    // bdcGzZhQO.gzldyid = processInsId;
    var result = qzyzBdcdyh(bdcGzZhQO);
    if (result.msg === "success") {
        $.ajax({
            url: acceptUiUrl + '/bdcGzyz?gzlslid=' + processInsId,
            type: 'POST',
            dataType: 'json',
            contentType: "application/json;charset=UTF-8",
            data: JSON.stringify(bdcGzZhQO),
            success: function (data) {
                if (data.msg == "success") {
                    addXmShoppingCar(checkData);
                } else {
                    layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告', btnAlign: 'c'}, function (index) {
                        layer.alert("暂未开放");
                    });
                }
            },error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    } else {
        layer.confirm(result.msg, {icon: 5, btn: '详情', title: '警告', btnAlign: 'c'}, function (index) {
            layer.alert("暂未开放");
        });
    }
}

function addXmShoppingCarSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcSlYwxxDTO = new Object();
    bdcSlYwxxDTO.xmid = selectData.xmid;
    bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
    bdcSlYwxxDTO.ybdcqz = selectData.bdcqzh;
    bdcSlYwxxDTO.zl = selectData.zl;
    bdcSlYwxxDTO.qlr = selectData.qlrmc;
    selectDataList.push(bdcSlYwxxDTO);
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                cshSelectedXxSingle(processInsId);
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function addXmShoppingCar(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcSlYwxxDTO = new Object();
        bdcSlYwxxDTO.xmid = selectData.xmid;
        bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
        bdcSlYwxxDTO.ybdcqz = selectData.bdcqzh;
        bdcSlYwxxDTO.zl = selectData.zl;
        bdcSlYwxxDTO.qlr = selectData.qlrmc;
        selectDataList.push(bdcSlYwxxDTO);
    }
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    // bdcCshSlxmDTO.gzldyid = processDefinitionId;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                ityzl_SHOW_TIP_LAYER("添加成功");
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}


