/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.accept.ui.web;

import cn.gtmap.realestate.accept.ui.web.main.BaseController;
import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.dto.init.BdcXmZhxxDTO;
import cn.gtmap.realestate.common.core.qo.init.BdcQlrQO;
import cn.gtmap.realestate.common.core.qo.init.BdcXmQO;
import cn.gtmap.realestate.common.core.service.feign.init.BdcQlrFeignService;
import cn.gtmap.realestate.common.core.service.feign.init.BdcXmFeignService;
import cn.gtmap.realestate.common.core.service.feign.register.BdcEntityFeignService;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONTokener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/slym/qlr"})
public class SlymQlrController
extends BaseController {
    @Autowired
    private BdcQlrFeignService bdcQlrFeignService;
    @Autowired
    private BdcXmFeignService bdcXmFeignService;
    @Autowired
    private BdcEntityFeignService bdcEntityFeignService;

    @ResponseBody
    @GetMapping(value={""})
    public Object queryQlr(String qlrid) {
        BdcQlrDO bdcQlrDO = new BdcQlrDO();
        if (StringUtils.isNotBlank((CharSequence)qlrid)) {
            BdcQlrQO bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setQlrid(qlrid);
            List bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
                bdcQlrDO = (BdcQlrDO)bdcQlrDOList.get(0);
            }
        }
        return bdcQlrDO;
    }

    @ResponseBody
    @GetMapping(value={"/list"})
    public Object listQlr(String processInsId) {
        BdcXmQO bdcXmQO = new BdcXmQO();
        bdcXmQO.setGzlslid(processInsId);
        List bdcXmDOList = this.bdcXmFeignService.listBdcXm(bdcXmQO);
        if (CollectionUtils.isNotEmpty((Collection)bdcXmDOList)) {
            BdcQlrQO bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setXmid(((BdcXmDO)bdcXmDOList.get(0)).getXmid());
            List bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
            this.setSxh(bdcQlrDOList);
            return bdcQlrDOList;
        }
        return null;
    }

    @ResponseBody
    @GetMapping(value={"/list/xm"})
    public Object queryQlrList(String xmid, String qlrlb) {
        List bdcQlrDOList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)xmid)) {
            BdcQlrQO bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setXmid(xmid);
            bdcQlrQO.setQlrlb(qlrlb);
            bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
        }
        return bdcQlrDOList;
    }

    @ResponseBody
    @PatchMapping(value={"/list/jdlc"})
    public Integer updateBdcQlr(@RequestBody String json) {
        Integer count = 0;
        for (Object obj : JSON.parseArray((String)json)) {
            count = count + this.bdcEntityFeignService.updateByJsonEntity(JSON.toJSONString(obj), BdcQlrDO.class.getName());
        }
        return count;
    }

    @ResponseBody
    @PatchMapping(value={"/list/zhlc"})
    public Integer updateZhBdcQlr(@RequestBody String json) {
        Integer count = 0;
        com.alibaba.fastjson.JSONArray jsonArray = com.alibaba.fastjson.JSONObject.parseArray((String)json);
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                com.alibaba.fastjson.JSONObject obj = (com.alibaba.fastjson.JSONObject)jsonArray.get(i);
                List jsonObjectList = this.queryZhBdcQlr(obj, "update");
                if (!CollectionUtils.isNotEmpty((Collection)jsonObjectList)) continue;
                for (com.alibaba.fastjson.JSONObject object : jsonObjectList) {
                    count = count + this.bdcEntityFeignService.updateByJsonEntity(com.alibaba.fastjson.JSONObject.toJSONString((Object)object), BdcQlrDO.class.getName());
                }
            }
        }
        return count;
    }

    @ResponseBody
    @PatchMapping(value={"/list/pllc"})
    public Integer updatePlBdcQlr(@RequestBody String json, @RequestParam(value="processInsId") String processInsId) {
        Integer count = 0;
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        Object jsonObject = new JSONTokener(json).nextValue();
        if (jsonObject instanceof JSONObject) {
            com.alibaba.fastjson.JSONObject obj = com.alibaba.fastjson.JSONObject.parseObject((String)json);
            if (obj != null) {
                jsonArray.add((Object)obj);
            }
        } else if (jsonObject instanceof JSONArray) {
            jsonArray = com.alibaba.fastjson.JSONObject.parseArray((String)json);
        }
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                com.alibaba.fastjson.JSONObject obj = (com.alibaba.fastjson.JSONObject)jsonArray.get(i);
                List bdcQlrDOList = this.listBdcQlrByMc(obj.get((Object)"qlrid").toString(), processInsId);
                if (!CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) continue;
                for (BdcQlrDO bdcQlr : bdcQlrDOList) {
                    obj.put("qlrid", (Object)bdcQlr.getQlrid());
                    obj.put("xmid", (Object)bdcQlr.getXmid());
                    count = count + this.bdcEntityFeignService.updateByJsonEntity(com.alibaba.fastjson.JSONObject.toJSONString((Object)obj), BdcQlrDO.class.getName());
                }
            }
        }
        return count;
    }

    @ResponseBody
    @PostMapping(value={"/jdlc"})
    public Object insertBdcQlr(@RequestBody BdcQlrDO bdcQlrDO) {
        if (bdcQlrDO != null) {
            bdcQlrDO.setQlrid(UUIDGenerator.generate());
        }
        return this.bdcQlrFeignService.insertBdcQlr(bdcQlrDO);
    }

    @ResponseBody
    @PostMapping(value={"/zhlc"})
    public BdcQlrDO insertZhBdcQlr(@RequestBody String json) {
        BdcQlrDO returnQlr = null;
        com.alibaba.fastjson.JSONObject obj = com.alibaba.fastjson.JSONObject.parseObject((String)json);
        List jsonObjectList = this.queryZhBdcQlr(obj, "insert");
        if (CollectionUtils.isNotEmpty((Collection)jsonObjectList)) {
            for (com.alibaba.fastjson.JSONObject object : jsonObjectList) {
                BdcQlrDO bdcQlrDO = (BdcQlrDO)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)object, BdcQlrDO.class);
                BdcQlrDO bdcqlr = this.bdcQlrFeignService.insertBdcQlr(bdcQlrDO);
                if (obj.get((Object)"qlrlb") == null || !StringUtils.equals((CharSequence)obj.get((Object)"qlrlb").toString(), (CharSequence)bdcqlr.getQlrlb())) continue;
                returnQlr = bdcqlr;
            }
        }
        return returnQlr;
    }

    @ResponseBody
    @PostMapping(value={"/pllc"})
    public Object insertPlBdcQlr(@RequestBody BdcQlrDO bdcQlrDO, @RequestParam(value="processInsId") String processInsId) {
        List bdcQlrDOList;
        if (bdcQlrDO != null && CollectionUtils.isNotEmpty((Collection)(bdcQlrDOList = this.bdcQlrFeignService.insertBatchBdcQlr(bdcQlrDO, processInsId)))) {
            return bdcQlrDOList.get(0);
        }
        return null;
    }

    @ResponseBody
    @DeleteMapping(value={"/jdlc"})
    public void deleteBdcQlr(@RequestParam(value="qlrid") String qlrid, @RequestParam(value="xmid") String xmid, @RequestParam(value="qlrlb") String qlrlb, @RequestParam(value="sxh") Integer sxh) {
        this.bdcQlrFeignService.deleteBdcQlr(qlrid);
        this.changeSxhForDel(xmid, qlrlb, sxh);
    }

    @ResponseBody
    @DeleteMapping(value={"/zhlc"})
    public void deleteZhBdcQlr(@RequestParam(value="qlrid") String qlrid, @RequestParam(value="xmid") String xmid, @RequestParam(value="qlrlb") String qlrlb, @RequestParam(value="sxh") Integer sxh) {
        com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
        obj.put("qlrid", (Object)qlrid);
        obj.put("xmid", (Object)xmid);
        obj.put("qlrlb", (Object)qlrlb);
        List jsonObjectList = this.queryZhBdcQlr(obj, "DELETE");
        if (CollectionUtils.isNotEmpty((Collection)jsonObjectList)) {
            for (com.alibaba.fastjson.JSONObject object : jsonObjectList) {
                BdcQlrDO bdcQlrDO = (BdcQlrDO)com.alibaba.fastjson.JSONObject.toJavaObject((JSON)object, BdcQlrDO.class);
                this.bdcQlrFeignService.deleteBdcQlr(bdcQlrDO.getQlrid());
                this.changeSxhForDel(bdcQlrDO.getXmid(), bdcQlrDO.getQlrlb(), sxh);
            }
        }
    }

    @ResponseBody
    @DeleteMapping(value={"/pllc"})
    public void deletePlBdcQlr(@RequestParam(value="qlrid") String qlrid, @RequestParam(value="processInsId") String processInsId, @RequestParam(value="sxh") Integer sxh) {
        List bdcQlrDOList = this.listBdcQlrByMc(qlrid, processInsId);
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
            for (BdcQlrDO bdcQlrDO : bdcQlrDOList) {
                this.bdcQlrFeignService.deleteBdcQlr(bdcQlrDO.getQlrid());
                this.changeSxhForDel(bdcQlrDO.getXmid(), bdcQlrDO.getQlrlb(), sxh);
            }
        }
    }

    @ResponseBody
    @GetMapping(value={"/sxh"})
    public Integer changeQlrSxh(String qlrid, String czlx, String lclx, String processInsId) {
        Integer count = 0;
        ArrayList<BdcQlrDO> bdcQlrDOS = new ArrayList<BdcQlrDO>();
        BdcQlrDO bdcQlrDO = (BdcQlrDO)this.queryQlr(qlrid);
        if (bdcQlrDO != null) {
            BdcQlrQO bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setXmid(bdcQlrDO.getXmid());
            bdcQlrQO.setQlrlb(bdcQlrDO.getQlrlb());
            List bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList) && bdcQlrDOList.size() > 1) {
                for (int i = 0; i < bdcQlrDOList.size(); ++i) {
                    BdcQlrDO bdcQlr = (BdcQlrDO)bdcQlrDOList.get(i);
                    if (!StringUtils.equals((CharSequence)bdcQlr.getQlrid(), (CharSequence)qlrid)) continue;
                    BdcQlrDO changeBdcQlr = null;
                    if (StringUtils.equals((CharSequence)czlx, (CharSequence)"up") && i != 0) {
                        changeBdcQlr = (BdcQlrDO)bdcQlrDOList.get(i - 1);
                    }
                    if (StringUtils.equals((CharSequence)czlx, (CharSequence)"down") && i != bdcQlrDOList.size() - 1) {
                        changeBdcQlr = (BdcQlrDO)bdcQlrDOList.get(i + 1);
                    }
                    if (changeBdcQlr == null) continue;
                    int sxh1 = bdcQlrDO.getSxh();
                    int sxh2 = changeBdcQlr.getSxh();
                    bdcQlrDO.setSxh(Integer.valueOf(sxh2));
                    changeBdcQlr.setSxh(Integer.valueOf(sxh1));
                    bdcQlrDOS.add(bdcQlrDO);
                    bdcQlrDOS.add(changeBdcQlr);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(bdcQlrDOS)) {
            if (StringUtils.equals((CharSequence)lclx, (CharSequence)"jdlc")) {
                for (BdcQlrDO bdcQlr : bdcQlrDOS) {
                    count = count + this.bdcQlrFeignService.updateBdcQlr(bdcQlr);
                }
            }
            if (StringUtils.equals((CharSequence)lclx, (CharSequence)"zhlc")) {
                count = this.updateZhBdcQlr(com.alibaba.fastjson.JSONObject.toJSONString(bdcQlrDOS));
            }
            if (StringUtils.equals((CharSequence)lclx, (CharSequence)"pllc")) {
                count = this.updatePlBdcQlr(com.alibaba.fastjson.JSONObject.toJSONString(bdcQlrDOS), processInsId);
            }
        }
        return count;
    }

    private List<com.alibaba.fastjson.JSONObject> queryZhBdcQlr(com.alibaba.fastjson.JSONObject obj, String type) {
        ArrayList<com.alibaba.fastjson.JSONObject> jsonObjectList = new ArrayList<com.alibaba.fastjson.JSONObject>();
        jsonObjectList.add(obj);
        com.alibaba.fastjson.JSONObject object = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)obj));
        List bdcXmZhxxDTOList = this.bdcXmFeignService.queryBdcXmZhxx(object.get((Object)"xmid").toString());
        if (CollectionUtils.isNotEmpty((Collection)bdcXmZhxxDTOList)) {
            for (int j = 0; j < bdcXmZhxxDTOList.size(); ++j) {
                BdcXmZhxxDTO bdcXmZhxxDTO = (BdcXmZhxxDTO)bdcXmZhxxDTOList.get(j);
                if (StringUtils.equals((CharSequence)bdcXmZhxxDTO.getXmid(), (CharSequence)obj.get((Object)"xmid").toString())) continue;
                if (bdcXmZhxxDTO.getSxh() == 2 && StringUtils.equals((CharSequence)object.get((Object)"qlrlb").toString(), (CharSequence)"1")) {
                    if (StringUtils.equals((CharSequence)type, (CharSequence)"update") || StringUtils.equals((CharSequence)type, (CharSequence)"DELETE")) {
                        jsonObjectList.add(this.getUpdateQlr(object, bdcXmZhxxDTO.getXmid(), "2"));
                    }
                    if (StringUtils.equals((CharSequence)type, (CharSequence)"insert")) {
                        jsonObjectList.add(this.getInsertQlr(object, bdcXmZhxxDTO.getXmid(), "2"));
                    }
                }
                if (bdcXmZhxxDTO.getSxh() != 1 || !StringUtils.equals((CharSequence)object.get((Object)"qlrlb").toString(), (CharSequence)"2")) continue;
                if (StringUtils.equals((CharSequence)type, (CharSequence)"update") || StringUtils.equals((CharSequence)type, (CharSequence)"DELETE")) {
                    jsonObjectList.add(this.getUpdateQlr(object, bdcXmZhxxDTO.getXmid(), "1"));
                }
                if (!StringUtils.equals((CharSequence)type, (CharSequence)"insert")) continue;
                jsonObjectList.add(this.getInsertQlr(object, bdcXmZhxxDTO.getXmid(), "1"));
            }
        }
        return jsonObjectList;
    }

    private com.alibaba.fastjson.JSONObject getUpdateQlr(com.alibaba.fastjson.JSONObject object, String xmid, String qlrlb) {
        BdcQlrQO bdcQlrQO = new BdcQlrQO();
        bdcQlrQO.setQlrid(object.get((Object)"qlrid").toString());
        List bdcQlrDOs = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
        if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOs)) {
            bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setQlrlb(qlrlb);
            bdcQlrQO.setQlrmc(((BdcQlrDO)bdcQlrDOs.get(0)).getQlrmc());
            bdcQlrQO.setXmid(xmid);
            List bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
                BdcQlrDO bdcQlrDO = (BdcQlrDO)bdcQlrDOList.get(0);
                object.put("qlrlb", (Object)bdcQlrDO.getQlrlb());
                object.put("xmid", (Object)bdcQlrDO.getXmid());
                object.put("qlrid", (Object)bdcQlrDO.getQlrid());
            }
        }
        return object;
    }

    private com.alibaba.fastjson.JSONObject getInsertQlr(com.alibaba.fastjson.JSONObject object, String xmid, String qlrlb) {
        object.put("qlrlb", (Object)qlrlb);
        object.put("xmid", (Object)xmid);
        object.put("qlrid", (Object)UUIDGenerator.generate());
        return object;
    }

    private void changeSxhForDel(String xmid, String qlrlb, Integer sxh) {
        if (sxh != null) {
            BdcQlrQO bdcQlrQO = new BdcQlrQO();
            bdcQlrQO.setXmid(xmid);
            bdcQlrQO.setQlrlb(qlrlb);
            List bdcQlrDOList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrDOList)) {
                for (BdcQlrDO bdcQlrDO : bdcQlrDOList) {
                    if (bdcQlrDO.getSxh() <= sxh) continue;
                    bdcQlrDO.setSxh(Integer.valueOf(bdcQlrDO.getSxh() - 1));
                    this.bdcQlrFeignService.updateBdcQlr(bdcQlrDO);
                }
            }
        }
    }

    private List<BdcQlrDO> listBdcQlrByMc(String qlrid, String processInsId) {
        ArrayList<BdcQlrDO> bdcQlrDOList = new ArrayList<BdcQlrDO>();
        if (StringUtils.isNotBlank((CharSequence)processInsId) && StringUtils.isNotBlank((CharSequence)qlrid)) {
            BdcQlrQO bdcQlrQOq = new BdcQlrQO();
            bdcQlrQOq.setQlrid(qlrid);
            List bdcQlrs = this.bdcQlrFeignService.listBdcQlr(bdcQlrQOq);
            if (CollectionUtils.isNotEmpty((Collection)bdcQlrs)) {
                BdcXmQO bdcXmQO = new BdcXmQO();
                bdcXmQO.setGzlslid(processInsId);
                List bdcXmDOList = this.bdcXmFeignService.listBdcXm(bdcXmQO);
                if (CollectionUtils.isNotEmpty((Collection)bdcXmDOList)) {
                    for (BdcXmDO bdcXmDO : bdcXmDOList) {
                        BdcQlrQO bdcQlrQO = new BdcQlrQO();
                        bdcQlrQO.setXmid(bdcXmDO.getXmid());
                        bdcQlrQO.setQlrmc(((BdcQlrDO)bdcQlrs.get(0)).getQlrmc());
                        List bdcQlrList = this.bdcQlrFeignService.listBdcQlr(bdcQlrQO);
                        if (!CollectionUtils.isNotEmpty((Collection)bdcQlrList)) continue;
                        bdcQlrDOList.addAll(bdcQlrList);
                    }
                }
            }
        }
        return bdcQlrDOList;
    }

    private void setSxh(List<BdcQlrDO> bdcQlrDOList) {
        if (CollectionUtils.isNotEmpty(bdcQlrDOList)) {
            int qlrsxh = 0;
            int ywrsxh = 0;
            for (int i = 0; i < bdcQlrDOList.size(); ++i) {
                int sxh = 0;
                BdcQlrDO bdcQlrDO = bdcQlrDOList.get(i);
                if (StringUtils.equals((CharSequence)bdcQlrDO.getQlrlb(), (CharSequence)"1")) {
                    sxh = ++qlrsxh;
                }
                if (StringUtils.equals((CharSequence)bdcQlrDO.getQlrlb(), (CharSequence)"2")) {
                    sxh = ++ywrsxh;
                }
                if (bdcQlrDO.getSxh() != null && bdcQlrDO.getSxh() != 0) continue;
                bdcQlrDO.setSxh(Integer.valueOf(sxh));
                this.bdcQlrFeignService.updateBdcQlr(bdcQlrDO);
            }
        }
    }
}

