/**
 * author: 前端组
 * date: 2018-12-14
 * version 3.0.0
 * describe: 查询条件所需的日期初始化、复选框初始化及高级查询
 */
layui.use(['form','jquery','laydate','element'],function () {
    var $ = layui.jquery,
        form = layui.form,
        laydate = layui.laydate;
    $(function () {
        //精确到时分秒日期控件
        laydate.render({
            elem: '#exact',
            type: 'datetime'
        });
        //初始化日期控件
        laydate.render({
            elem: '#startTime'
        });
        laydate.render({
            elem: '#endTime'
        });

        //渲染单选框


        //渲染复选框
        var combotreeData = [
            {id: "100", text: "首次登记"},
            {id: "200", text: "转移登记"},
            {id: "300", text: "变更登记"},
            {id: "400", text: "注销登记"},
            {id: "500", text: "更正登记"},
            {id: "600", text: "异议登记"},
            {id: "700", text: "预告登记"},
            {id: "800", text: "查封登记"}
        ];
        $('#ddlLine').combotree({
            valueField: "id", //Value字段
            textField: "text", //Text字段
            multiple: true,
            data: combotreeData,
            onCheck: function (record) {
                console.log(record);
                console.log(record.checkState);
            }
        });

        //选中
        var selectData = [
            {id: "300", text: "变更登记"},
            {id: "400", text: "注销登记"},
            {id: "700", text: "预告登记"}
        ];
        $('#djLine').combotree({
            valueField: "id", //Value字段
            textField: "text", //Text字段
            multiple: true,
            data: combotreeData,
            onLoadSuccess: function (node, data) {
                $('#djLine').combotree('setValues', selectData);
            },
            onCheck: function (record) {
                console.log(record);
                console.log(record.checkState);
            }
        });

        //点击高级查询
        $('#seniorSearch').on('click',function () {
            $('.pf-senior-show').toggleClass('bdc-hide');
        });

        //使用js渲染下拉框
        var selectData = [
            {dm: '320402',mc: '天宁区'},
            {dm: '320404',mc: '钟楼区'},
            {dm: '320311',mc: '新北区'},
            {dm: '320412',mc: '武进区'}
        ];
        var xzqHtml = ' ';
        for(var i = 0; i< selectData.length; i++){
            xzqHtml += '<option value='+ selectData[i].dm + '>' + selectData[i].mc + '</option>'
        }
        $('#pfXzq').append(xzqHtml);
        form.render('select');
    });
});