//页面入口
layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
    var form = layui.form;
    //form验证
    form.on('checkbox', function () {
        $("[type='checkbox']").prop("checked", "");
        $(this).prop("checked", "checked");
        form.render('checkbox');
    });
    form.render();
    var element = layui.element;
    element.init();
    titleShowUi();
    var loadIndex = loadLayer();
    setTimeout(function () {
        try {
            $.when(loadData()).done(function () {
                layer.close(loadIndex);
            })
        } catch (e) {
            ERROR_CONFIRM("加载失败", e.message);
            return
        }
    }, 10);
});
var zdList;
var xmid;
function loadData() {
    var zd;
    var tableNames = [];
    tableNames.push("djlx");
    tableNames.push("bdclx");
    tableNames.push("cflx");
    tableNames.push("zjzl");
    tableNames.push("dybdclx");
    tableNames.push("gyfs");
    tableNames.push("tdsyqxz");
    tableNames.push("ygdjzl");
    tableNames.push("qy");
    tableNames.push("qlrlb");
    tableNames.push("tdyt");
    tableNames.push("fwyt");
    tableNames.push("hysylxa");
    tableNames.push("sjlx");
    tableNames.push("qllx");
    tableNames.push("mjdw");
    $.ajax({
        url: acceptUiUrl+"/bdczd",
        type: 'POST',
        dataType: 'json',
        data: {zdNameList: tableNames.join(",")},
        success: function (data) {
            if (isNotBlank(data)) {
                zdList = data;
                loadJbxx();
                loadQlr();
                loadSjcl();
                loadBdcdyh()
            }
        }
    });
}

function loadJbxx() {
    $.ajax({
        url: acceptUiUrl+"/slym/xm",
        type: 'GET',
        dataType: 'json',
        data: {processInsId: processInsId},
        success: function (data) {
            if (isNotBlank(data)) {
                xmid = data.xmid;
                //面积单位为空时默认为平方米
                if(data.mjdw === null || data.mjdw=== '') {
                    data.mjdw = '1'
                }
                generateJbxx(data);
            }
        }
    });
}


function loadQlr() {
    $.ajax({
        url: acceptUiUrl+"/slym/qlr/list",
        type: 'GET',
        dataType: 'json',
        data: {processInsId: processInsId},
        success: function (data) {
            generateQlrxx(data,"sqrxx");
        }
    });
}

function loadSjcl() {
    $.ajax({
        url: acceptUiUrl+"/slym/sjcl/list/pl",
        type: 'GET',
        dataType: 'json',
        data: {processInsId: processInsId},
        success: function (data) {
            generateSjcl(data);
        }
    });
}

function generateJbxx(bdcxmxx) {
    layui.use(['form', 'jquery', 'laytpl', 'element','laydate'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var json = {
            bdcxmxx: bdcxmxx,
            zd:zdList
        }
        var tpl = jbxxTpl.innerHTML,view = document.getElementById('sljbXx');
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            view.innerHTML = html;
        });
        form.render();
        renderDate(form)
        disabledAddFa();
    })
}


function generateQlrxx(data,id) {
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var json = {
            bdcQlrDOList: data,
            zd:zdList
        }
        var tpl = sqrTpl.innerHTML, view = document.getElementById(id);
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            view.innerHTML = html;
        });
        form.render();
        disabledAddFa();
    })
}
var sjclNumber=0;
function generateSjcl(data) {
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var json = {
            bdcSlSjclDOList: data,
            zd: zdList
        }
        sjclNumber = data.length;
        var tpl = sjclTpl.innerHTML, view = document.getElementById('sjclxx');
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            view.innerHTML = html;
        });
        form.render('select');
        disabledAddFa();
    })
}

function loadBdcdyh() {
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function() {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        $(document).keydown(function (event) {
            if (event.keyCode == 13) { //绑定回车
                $("#searchBdcdy").click();
            }
        });

        //不动产单元号的表头
        var unitTableTitle = [
            {field: 'bdcdyh', title: '不动产单元号', width: "24%", templet: '#bdcdyhTpl'},
            {field: 'zl', title: '坐落', width: "24%"},
            {field: 'zdzhmj', title: '宗地宗海面积(㎡)', width: "12%"},
            {field: 'zdzhyt', title: '宗地宗海用途', width: "12%",templet:'#zdzhytTpl'},
            {field: 'dzwmj', title: '定作物面积(㎡)', width: "12%"},
            {field: 'dzwyt', title: '定作物用途', width: "12%",templet:'#dzwytTpl'},
            {field: 'qllx', title: '权利类型', width: "12%",templet:'#qllxTpl'},
            {field: 'cz', title: '操作', width: "14%",templet:'#bdcdyczTpl'}
        ];
        var url = acceptUiUrl+'/slym/xm/listBdcdyByPageJson';
        //提交表单
        form.on("submit(searchBdcdy)", function () {
            var data = {};
            var bdcdyArray = $("#bdcdyForm").serializeArray();
            bdcdyArray.forEach(function (item) {
                data[item.name] = item.value;
            });
            data["processInsId"] = processInsId;
            tableReload('xmid', data, url)
            return false;
        })

        var tableConfig = {
            id: 'xmid',
            url:url,
            where: {processInsId: processInsId},
            toolbar: "#toolbarBdcdyh",
            cols: [unitTableTitle]
        }

        //加载表格
        loadDataTablbeByUrl('#bdcdyTable', tableConfig);
    })
}


function queryQllx(qllx) {
    if (isNotBlank(zdList.qllx)) {
        for (var i = 0; i < zdList.qllx.length; i++) {
            var qllxZd = zdList.qllx[i];
            if (qllx == qllxZd.DM) {
                qllx = qllxZd.MC;
                break;
            }
        }
    }
    return qllx;
}

function queryZdzhyt(zdzhyt) {
    if (isNotBlank(zdList)) {
        for (var i = 0; i < zdList.tdyt.length; i++) {
            var tdytZd = zdList.tdyt[i];
            if (zdzhyt == tdytZd.DM) {
                zdzhyt = tdytZd.MC;
                break;
            }
        }
    }
    return zdzhyt;
}

function queryDzwyt(dzwyt) {
    if (isNotBlank(zdList.fwyt)) {
        for (var i = 0; i < zdList.fwyt.length; i++) {
            var dzwytZd = zdList.fwyt[i];
            if (dzwyt == dzwytZd.DM) {
                dzwyt = dzwytZd.MC;
                break;
            }
        }
    }
    return dzwyt;
}
function openFull(url, title){
    var width=$(window).width()+"px";
    var height=$(window).height()+"px";
    var index = layer.open({
        title: title,
        type: 2,
        content: url,
        area: [width, height],
        maxmin: true,
        end: function(){
            $.ajax({
                url: acceptUiUrl+"/sjcl/sjclFs",
                type: 'PATCH',
                dataType: 'json',
                data: {gzlslid: processInsId,xmid: xmid}
            });
        }
    });
    layer.full(index);
}