
//页面入口
layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
    var loadIndex = loadLayer();
    setTimeout(function () {
        try {
            $.when(loadData()).done(function () {
                layer.close(loadIndex);
            })
        } catch (e) {
            ERROR_CONFIRM("加载失败", e.message);
            return
        }
    }, 10);

});

var zdList;

function loadData() {
    var tableNames = [];
    tableNames.push("zjzl");
    tableNames.push("qlrlb");
    tableNames.push("gyfs");
    $.ajax({
        url: acceptUiUrl+"/bdczd",
        type: 'POST',
        dataType: 'json',
        data: {zdNameList: tableNames.join(",")},
        success: function (data) {
            if (isNotBlank(data)) {
                zdList = data;
                if (isNotBlank(qlrid)) {
                    loadQlr()
                } else if (isNotBlank(xmid)) {
                    loadAddQlr();
                }
            }
        }
    });
}

function loadQlr() {
    $.ajax({
        url: acceptUiUrl+"/slym/qlr",
        type: 'GET',
        dataType: 'json',
        data: {qlrid: qlrid},
        success: function (data) {
            if (isNotBlank(data)) {
                generateQlr(data);
            }
        }
    });
}

function loadAddQlr() {
    $.ajax({
        url: acceptUiUrl+"/slym/qlr/list/xm",
        type: 'GET',
        dataType: 'json',
        data: {xmid: xmid,qlrlb:"1"},
        success: function (data) {
            var qlr = [];
            qlr["xmid"] = xmid;
            if (isNotBlank(data)) {
                if (data.length > 0) {
                    qlr["sfczr"] = "1";
                    qlr["gyfs"] = "1";
                    var sxh = 0;
                    for (var i = 0; i < data.length; i++) {
                        var qlrDo = data[i];
                        if (sxh < qlrDo["sxh"]) {
                            sxh = qlrDo["sxh"];
                        }
                    }
                    qlr["sxh"] = sxh + 1;
                }
            }else{
                qlr["sfczr"] = "0";
                qlr["gyfs"] = "0";
                qlr["sxh"] = 1;
            }
            generateQlr(qlr);
        }
    });
}

function changeQlrlb(qlrlb) {
    $.ajax({
        url: acceptUiUrl+"/slym/qlr/list/xm",
        type: 'GET',
        dataType: 'json',
        data: {xmid: xmid, qlrlb: qlrlb},
        success: function (data) {
            if (isNotBlank(data)) {
                if (data.length > 0) {
                    var sxh = 0;
                    for (var i = 0; i < data.length; i++) {
                        var qlrDo = data[i];
                        if (sxh < qlrDo["sxh"]) {
                            sxh = qlrDo["sxh"];
                        }
                    }
                    $("#sxh").val(sxh + 1);
                }
            } else {
                $("#sxh").val(1);
            }
        }
    });
}

function generateQlr(qlr) {
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var json = {
            qlr: qlr,
            zd: zdList
        }
        var tpl = addQlrTmpl.innerHTML, view = document.getElementById('qlrxx');
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            view.innerHTML = html;
        });
        form.render();
        renderDate(form);
        disabledAddFa();
        if (!isNotBlank(qlr.xmid)) {
            $("#xmid").val(xmid);
        }
        form.on('select(qlrlb)', function (data) {
            changeQlrlb(data.value);
        });
        //提交表单
        form.on("submit(updateQlr)", function (data) {
            var loadIndex = loadLayer();
            if (isNotBlank(data.field.qlrid)) {
                setTimeout(function () {
                    try {
                        $.when(updateQlr(data.field)).done(function () {
                            layer.close(loadIndex);
                            ityzl_SHOW_TIP_LAYER("提交成功");
                        })
                    } catch (e) {
                        ERROR_CONFIRM("提交失败", e.message);
                        return
                    }
                }, 10);
            } else {
                setTimeout(function () {
                    try {
                        $.when(insertQlr(data.field)).done(function () {
                            layer.close(loadIndex);
                            ityzl_SHOW_TIP_LAYER("提交成功");
                        })
                    } catch (e) {
                        ERROR_CONFIRM("提交失败", e.message);
                        return
                    }
                }, 10);
            }
        })
    })
}

function updateQlr(bdcQlrData) {
    var qlrData;
    var url = "";
    if (lclx == "pllc") {
        qlrData = bdcQlrData;
        url = acceptUiUrl+"/slym/qlr/list/pllc?processInsId=" + processInsId;
    } else {
        if (lclx == "jdlc") {
            url = acceptUiUrl+"/slym/qlr/list/jdlc";
        }
        if (lclx == "zhlc") {
            url = acceptUiUrl+"/slym/qlr/list/zhlc";
        }
        qlrData = [];
        qlrData.push(bdcQlrData)
    }
    var loadMsg = loading();
    $.ajax({
        url: url,
        type: 'PATCH',
        dataType: 'json',
        contentType: "application/json",
        data: JSON.stringify(qlrData),
        success: function (data) {
            if (data > 0) {
                ityzl_SHOW_TIP_LAYER("提交成功");
                setTimeout(layer.close(loadMsg), 1000);
                windowParentLoad();
            }
        }
    });
}

function insertQlr(bdcQlrData) {
    var url = "";
    if (lclx == "jdlc") {
        url = acceptUiUrl+"/slym/qlr/jdlc";
    }
    if (lclx == "pllc") {
        url = acceptUiUrl+"/slym/qlr/pllc?processInsId=" + processInsId;
    }
    if (lclx == "zhlc") {
        url = acceptUiUrl+"/slym/qlr/zhlc";
    }
    $.ajax({
        url: url,
        type: 'post',
        dataType: 'json',
        contentType: "application/json",
        data: JSON.stringify(bdcQlrData),
        success: function (data) {
            if (isNotBlank(data)) {
                qlrid = data.qlrid;
                loadQlr();
                ityzl_SHOW_TIP_LAYER("提交成功");
                windowParentLoad();
            }
        },
        error: function (e) {
            ityzl_SHOW_TIP_LAYER(e);
        }
    });
}

function windowParentLoad() {
    if (top != self) {
        if (lclx == "jdlc" || lclx == "pllc") {
            if (typeof (eval(window.parent.loadQlr)) == "function") {
                window.parent.loadQlr();
            }
        }
        if (lclx == "zhlc") {
            if (typeof (eval(window.parent.loadQlxx)) == "function") {
                window.parent.loadQlr();
            }
        }
    }
}

function cancelEdit() {
    window.parent.cancelEdit();
}