function initLjzTable() {
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        $(document).keydown(function (event) {
            if (event.keyCode == 13) { //绑定回车
                $("#queryLjz").click();
            }
        });
        //不动产单元号的表头
        var unitTableTitle = [{type: 'checkbox', fixed: 'left'},
            {field: 'zrzh', title: '自然幢号', width: "10%"},
            {field: 'lszd', title: '隶属宗地', width: "17%"},
            {field: 'fwmc', title: '房屋名称', width: "14%"},
            {field: 'zldz', title: '坐落', width: "22%"},
            {field: 'ljzh', title: '逻辑幢号', width: "15%"},
            {field: 'bdcdyh', title: '不动产单元号', width: "23%", templet: '#bdcdyh', event: 'cshLjz'}
        ]

        //提交表单
        form.on("submit(queryLjz)", function (data) {
            var url = acceptUiUrl + '/bdcdyh/listLjzByPageJson';
            tableReload('fwDcbIndex', data.field, url);
            return false;
        })

        var tableConfig = {
            id: 'fwDcbIndex',
            toolbar: "#toolbarLjz",
            cols: [unitTableTitle]
        }

        //加载表格
        loadDataTablbeByUrl('#ljzList', tableConfig);
        //表格初始化
        table.init('ljzList', tableConfig)
        //头工具栏事件
        table.on('toolbar(ljzList)', function (obj) {
            var data = obj.data; //获得当前行数据
            var layEvent = obj.event; //获得 lay-event 对应的值
            var tr = obj.tr; //获得当前行 tr 的DOM对象
            if (layEvent == "addLjzShoppingCar") { //添加到购物车
                var loadMsg = loading();
                var checkStatus = table.checkStatus(obj.config.id), checkData = checkStatus.data;
                if (checkData != null && checkData.length > 0) {
                    checkLjz(checkData)
                }
            }
            if (layEvent == "selectedXx") { //已选择不动产单元
                layer.open({
                    type: 2,
                    title: "已选信息",
                    area: ['1150px', '600px'],
                    fixed: false, //不固定
                    maxmin: true, //开启最大化最小化按钮
                    content: acceptUiUrl + '/view/query/gwc.html?jbxxid=' + processInsId
                });
            }
            if (layEvent == "allSelect") {  //全选
                $('.layui-unselect').click();
            }
        });
        table.on('tool(ljzList)', function (obj) { //bdcdyhList为table的lay-filter对应的值
            if (obj.event === 'cshLjz') {
                var checkData = obj.data;
                if (checkData.bdcdyh) {
                    var loadMsg = loading();
                    checkLjzSingle(checkData);//单个验证
                }
            }
        });
    })
}
function checkLjzSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcGzYzsjDTO = new Object();
    bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
    selectDataList.push(bdcGzYzsjDTO);
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    // bdcGzZhQO.gzldyid = processInsId;
    var result = qzyzBdcdyh(bdcGzZhQO);
    if (result.msg === "success") {
        $.ajax({
            url: acceptUiUrl + '/bdcGzyz?gzlslid=' + processInsId,
            type: 'POST',
            dataType: 'json',
            contentType: "application/json;charset=UTF-8",
            data: JSON.stringify(bdcGzZhQO),
            success: function (data) {
                if (data.msg == "success") {
                    addLjzShoppingCarSingle(checkData);
                } else {
                    layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
                        layer.alert("暂未开放");
                    });
                }
            },error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    } else {
        layer.confirm(result.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
            layer.alert("暂未开放");
        });
    }
}

function checkLjz(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcGzYzsjDTO = new Object();
        bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
        selectDataList.push(bdcGzYzsjDTO);
    }
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    // bdcGzZhQO.gzldyid = processInsId;
    var result = qzyzBdcdyh(bdcGzZhQO);
    if (result.msg === "success") {
        $.ajax({
            url: acceptUiUrl + '/bdcGzyz?gzlslid=' + processInsId,
            type: 'POST',
            dataType: 'json',
            contentType: "application/json;charset=UTF-8",
            data: JSON.stringify(bdcGzZhQO),
            success: function (data) {
                if (data.msg == "success") {
                    addLjzShoppingCar(checkData);
                } else {
                    layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
                        layer.alert("暂未开放");
                    });
                }
            },error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    } else {
        layer.confirm(result.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
            layer.alert("暂未开放");
        });
    }
}

function addLjzShoppingCarSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcSlYwxxDTO = new Object();
    bdcSlYwxxDTO.xmid = selectData.xmid;
    bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
    bdcSlYwxxDTO.zl = selectData.zl;
    bdcSlYwxxDTO.qlr = selectData.qlrmc;
    bdcSlYwxxDTO.cflx = selectData.cflx;
    selectDataList.push(bdcSlYwxxDTO);
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                cshSelectedXxSingle(processInsId);
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function addLjzShoppingCar(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcSlYwxxDTO = new Object();
        bdcSlYwxxDTO.xmid = selectData.xmid;
        bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
        bdcSlYwxxDTO.zl = selectData.zl;
        bdcSlYwxxDTO.qlr = selectData.qlrmc;
        bdcSlYwxxDTO.cflx = selectData.cflx;
        selectDataList.push(bdcSlYwxxDTO);
    }
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    // bdcCshSlxmDTO.gzldyid = gzldyid;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                ityzl_SHOW_TIP_LAYER("添加成功");
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

