function initCfTable() {
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        $(document).keydown(function (event) {
            if (event.keyCode == 13) { //绑定回车
                $("#queryCf").click();
            }
        });
        //不动产单元号的表头
        var unitTableTitle = [{type: 'checkbox', fixed: 'left'},
            {field: 'bdcdyh', title: '不动产单元号', width: "23.8%", templet: '#bdcdyh', event: 'cshBdcCf'},
            {field: 'cfwh', title: '查封文号', width: "19%"},
            {field: 'cflx', title: '查封类型', width: "11%", templet: '#cflx'},
            {field: 'cfjg', title: '查封机关', width: "11%"},
            {field: 'ywrmc', title: '被查封人', width: "10%"},
            {field: 'zt', title: '状态', width: "15.7%", templet: '#bdcdyzt', align: "center"},
            {field: 'cz', title: '操作', width: "6%", templet: '#bdcdycz'}
        ]

        //提交表单
        form.on("submit(queryCf)", function (data) {
            var url = acceptUiUrl + '/bdcdyh/listCfByPageJson';
            tableReload('qlid', data.field, url);
            return false;
        })

        var tableConfig = {
            id: 'qlid',
            toolbar: "#toolbarCf",
            cols: [unitTableTitle]
        }

        //加载表格
        loadDataTablbeByUrl('#cfList', tableConfig);
        //表格初始化
        table.init('cfList', tableConfig);
        //头工具栏事件
        table.on('toolbar(cfList)', function (obj) {
            var data = obj.data; //获得当前行数据
            var layEvent = obj.event; //获得 lay-event 对应的值
            var tr = obj.tr; //获得当前行 tr 的DOM对象
            if (layEvent == "addCfShoppingCar") { //添加到购物车
                var loadMsg = loading();
                var checkStatus = table.checkStatus(obj.config.id), checkData = checkStatus.data;
                if (checkData != null && checkData.length > 0) {
                    checkCf(checkData)
                }
            }
            if (layEvent == "selectedXx") { //已选择不动产单元
                layer.open({
                    type: 2,
                    title: "已选信息",
                    area: ['1150px', '600px'],
                    fixed: false, //不固定
                    maxmin: true, //开启最大化最小化按钮
                    content: acceptUiUrl + '/view/query/gwc.html?jbxxid=' + processInsId
                });
            }
            if (layEvent == "allSelect") {  //全选
                $('.layui-unselect').click();
            }
        });
        table.on('tool(cfList)', function (obj) { //bdcdyhList为table的lay-filter对应的值
            if (obj.event === 'cshBdcCf') {
                var checkData = obj.data;
                if (checkData !== null) {
                    var loadMsg = loading();
                    checkCfSingle(checkData);//单个验证
                }
            }
        });
    })
}


function checkCfSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcGzYzsjDTO = new Object();
    bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
    selectDataList.push(bdcGzYzsjDTO);
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    bdcGzZhQO.gzldyid = processInsId;
    $.ajax({
        url: acceptUiUrl + '/bdcGzyz',
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcGzZhQO),
        success: function (data) {
            if (data.msg == "success") {
                addCfShoppingCarSingle(checkData);
            } else {
                layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
                    layer.alert("暂未开放");
                });
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function checkCf(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcGzYzsjDTO = new Object();
        bdcGzYzsjDTO.bdcdyh = selectData.bdcdyh;
        selectDataList.push(bdcGzYzsjDTO);
    }
    var bdcGzZhQO = new Object();
    bdcGzZhQO.bdcgzyzsjdtolist = selectDataList;
    bdcGzZhQO.gzldyid = processInsId;

    $.ajax({
        url: acceptUiUrl + '/bdcGzyz',
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcGzZhQO),
        success: function (data) {
            if (data.msg == "success") {
                addCfShoppingCar(checkData);
            } else {
                layer.confirm(data.msg, {icon: 5, btn: '详情', title: '警告'}, function (index) {
                    layer.alert("暂未开放");
                });
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function addCfShoppingCarSingle(checkData) {
    var selectDataList = [];
    var selectData = checkData;
    var bdcSlYwxxDTO = new Object();
    bdcSlYwxxDTO.xmid = selectData.xmid;
    bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
    bdcSlYwxxDTO.zl = selectData.zl;
    bdcSlYwxxDTO.qlr = selectData.qlrmc;
    bdcSlYwxxDTO.cflx = selectData.cflx;
    selectDataList.push(bdcSlYwxxDTO);
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                cshSelectedXxSingle(processInsId);
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function addCfShoppingCar(checkData) {
    var selectDataList = [];
    for (var i = 0; i < checkData.length; i++) {
        var selectData = checkData[i];
        var bdcSlYwxxDTO = new Object();
        bdcSlYwxxDTO.xmid = selectData.xmid;
        bdcSlYwxxDTO.bdcdyh = selectData.bdcdyh;
        bdcSlYwxxDTO.zl = selectData.zl;
        bdcSlYwxxDTO.qlr = selectData.qlrmc;
        bdcSlYwxxDTO.cflx = selectData.cflx;
        selectDataList.push(bdcSlYwxxDTO);
    }
    var bdcCshSlxmDTO = new Object();
    bdcCshSlxmDTO.bdcSlYwxxDTOList = selectDataList;
    bdcCshSlxmDTO.gzlslid = processInsId;
    // bdcCshSlxmDTO.gzldyid = gzldyid;
    $.ajax({
        url: acceptUiUrl + "/addbdcdyh",
        type: 'POST',
        dataType: 'json',
        contentType: "application/json;charset=UTF-8",
        data: JSON.stringify(bdcCshSlxmDTO),
        success: function (data) {
            if (data.msg == "success") {
                ityzl_SHOW_TIP_LAYER("添加成功");
            } else {
                ityzl_SHOW_TIP_LAYER(data.msg);
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function changeCflx(cflx) {
    for (var i = 0; i < zdBdclxList.length; i++) {
        if (cflx === zdBdclxList[i].DM) {
            cflx = zdBdclxList[i].MC;
        }
    }
    return cflx;
}
