layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
    var form = layui.form;
    var element = layui.element;
    element.init();
    loadData();
});
var zdList;
var xmid;
function loadData() {
    var tableNames = [];
    tableNames.push("djlx");
    tableNames.push("bdclx");
    tableNames.push("zjzl");
    tableNames.push("tdyt");
    tableNames.push("fwyt");
    $.ajax({
        url: acceptUiUrl+"/bdczd",
        type: 'POST',
        dataType: 'json',
        data: {zdNameList: tableNames.join(",")},
        success: function (data) {
            if (isNotBlank(data)) {
                zdList = data;
                loadQlxx();
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function loadQlxx() {
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function() {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        $(document).keydown(function (event) {
            if (event.keyCode == 13) { //绑定回车
                $("#searchBdcdy").click();
            }
        });

        //不动产单元号的表头
        var unitTableTitle = [
            {field: 'bdcdyh', title: '不动产单元号', width: "26%", templet: '#bdcdyhTpl'},
            {field: 'zl', title: '坐落', width: "23%"},
            {field: 'dzwmj', title: '定作物面积(㎡)', width: "12%"},
            {field: 'dzwyt', title: '定作物用途', width: "12%",templet:'#dzwytTpl'},
            {field: 'qllx', title: '权利类型', width: "12%",templet:'#qllxTpl'},
            {field: 'cz', title: '操作', width: "15.1%",templet:'#bdcdyczTpl'}
        ];
        var url = acceptUiUrl+'/bdcdyh/queryqllsgx';
        //提交表单
        form.on("submit(searchBdcdy)", function () {
            var data = {};
            var bdcdyArray = $("#bdcdyForm").serializeArray();
            bdcdyArray.forEach(function (item) {
                data[item.name] = item.value;
            });
            tableReload('xmid', data, url)
            return false;
        })

        var tableConfig = {
            id: 'xmid',
            url:url,
            where: {bdcdyh: bdcdyh},
            cols: [unitTableTitle]
        }

        //加载表格
        loadDataTablbeByUrl('#qlxxTable', tableConfig);
    })
}

function queryQllx(qllx) {
    if (isNotBlank(zdList.qllx)) {
        for (var i = 0; i < zdList.qllx.length; i++) {
            var qllxZd = zdList.qllx[i];
            if (qllx == qllxZd.DM) {
                qllx = qllxZd.MC;
                break;
            }
        }
    }
    return qllx;
}

function queryDzwyt(dzwyt) {
    if (isNotBlank(zdList.fwyt)) {
        for (var i = 0; i < zdList.fwyt.length; i++) {
            var dzwytZd = zdList.fwyt[i];
            if (dzwyt == dzwytZd.DM) {
                dzwyt = dzwytZd.MC;
                break;
            }
        }
    }
    return dzwyt;
}