layui.use(['element', 'form', 'jquery', 'laydate', 'laypage', 'laytpl'], function () {
    var element = layui.element;
    var form = layui.form;
    var $ = layui.jquery;
    var laydate = layui.laydate;
    var laypage = layui.laypage;
    var laytpl = layui.laytpl;

    //无数据的情况
    if ($(".info-content-details").length < 1) {
        $(".no-info").show();
        $("#paging").hide();
    }
    //初始化已选择信息
    $("#cshSelectedXx").click(function () {
        var loadMsg = loading();
        cshSelectedXx();
    })

    //分页


    //修改事件
    $(document).on("click", ".clickP", function (e) {
        var template = this.id + "Template";
        var e = e || window.event; //浏览器兼容性
        if (e.stopPropagation) {
            e.stopPropagation();
        } else {
            e.cancelBubble = true;
        }
        var getThisTop = $(this).offset().top + 25;
        var getThisLeft = $(this).offset().left - 100;
        $("#alertFather").css({
            top: getThisTop,
            left: getThisLeft
        })

        var getData = {};
        var getTpl = $("#" + template + "").html(); //获取自己定义的模板元素
        laytpl(getTpl).render(getData, function (html) {
            $("#alertFather").html(html).show(); //加载到主元素中
            form.render('select', template); //重新渲染下拉框
        });

    })

    $(document).click(function (e) {
        var e = e || window.event; //浏览器兼容性
        var elem = e.target || e.srcElement;
        while (elem) { //循环判断至跟节点，防止点击的是div子元素
            if (elem.id && elem.id == 'alertFather') {
                return;
            }
            elem = elem.parentNode;
        }
        $("#alertFather").hide();

    })

    $(document).on("click", ".cancle-btn", function () {
        $("#alertFather").hide()
    })

    //展现隐藏的模块
    var flag = 1;
    $(document).on("click", ".info-content-right .layui-icon", function () {
        if (flag) {
            $(this).parents(".info-content-details").find(".info-details-hide").addClass("info-details-show");
            $(this).removeClass("layui-icon-up").addClass("layui-icon-down");
            flag = 0;
        } else {
            $(this).parents(".info-content-details").find(".info-details-hide").removeClass("info-details-show");
            $(this).removeClass("layui-icon-down").addClass("layui-icon-up");
            flag = 1;
        }
    })

    //全选
    $(document).on("click", ".select-all", function () {
        $("input[type=checkbox]").attr("checked", "checked");
        $(".layui-form-checkbox").addClass("layui-form-checked");

    })
    //批量删除
    $(document).on("click", ".delete-all", function (e) {
        layer.confirm('是否确认要删除', function (index) {
            var id = document.getElementsByName('agree');
            var value = [];
            for (var i = 0; i < id.length; i++) {
                if (id[i].checked)
                    value.push(id[i].value);
            }
            var xmids = value.toString();
            deleteAll(xmids);
            layer.closeAll('dialog');
        });
    })

    //全部展开
    var oflag = 1;
    $(document).on("click", ".show-all", function () {
        if (oflag) {
            $(".info-details-hide").addClass("info-details-show");
            $(".info-content-right").find(".layui-icon").removeClass("layui-icon-up").addClass("layui-icon-down");
            $(this).text("全部关闭子项")
            oflag = 0;
        } else {
            $(".info-details-hide").removeClass("info-details-show");
            $(".info-content-right").find(".layui-icon").removeClass("layui-icon-down").addClass("layui-icon-up");
            $(this).text("全部展开子项")
            oflag = 1;
        }
    })

    //删除一条数据
    $(document).on("click", ".delete-ul-btn", function () {
        $(this).parents(".info-show-child").remove();
    })

    form.on("submit(queryBdcdyh)", function (data) {
        loadSelectBdcdyh(1, 5, data.field)
        return false;
    })
})
var zdDjxlList = {};
$(function () {
    loadSelectBdcdyh(1, 5, new Object());
    loadZdbData();
});

function cshSelectedXx() {
    $.ajax({
        url: acceptUiUrl + '/slxxcsh',
        type: 'GET',
        dataType: 'json',
        data: {jbxxid: jbxxid},
        success: function (data) {
            if (data.msg == "success") {
                var index = parent.layer.getFrameIndex(window.name);
                parent.layer.close(index);
                var url = acceptUiUrl + "/view/slym/slym.html?processInsId=" + jbxxid;
                if (data.zhlc == "true") {
                    url = acceptUiUrl + "/view/slym/slymzh.html?processInsId=" + jbxxid
                } else if (data.jdlc == "true") {
                    url = acceptUiUrl + "/view/slym/slym.html?processInsId=" + jbxxid
                } else if (data.pllc == "true") {
                    url = acceptUiUrl + "/view/slym/slympl.html?processInsId=" + jbxxid;
                }
                window.open(url);
            } else {
                ityzl_SHOW_TIP_LAYER("初始化失败");
            }
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function loadZdbData() {
    var tableNames = [];
    tableNames.push("djxl");
    $.ajax({
        url: acceptUiUrl + "/bdczd",
        type: 'POST',
        dataType: 'json',
        async: false,
        data: {zdNameList: tableNames.join(",")},
        success: function (data) {
            zdDjxlList = data.djxl;
        },error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
}

function loadSelectBdcdyh(page, size, queryData) {
    $.ajax({
        url: acceptUiUrl + "/gwc/listBdcdyhByPageJson",
        type: 'GET',
        dataType: 'json',
        data: {
            page: page,
            size: size,
            sort: "bdcdyh",
            jbxxid: jbxxid,
            qlr: queryData.qlr,
            bdcdyh: queryData.bdcdyh,
            bdcqzh: queryData.bdcqzh
        },
        success: function (data) {
            if (data.bdcYxYwxxDTOList != null && data.bdcYxYwxxDTOList.length > 0) {
                initBdcdyh(data.bdcYxYwxxDTOList, data.bdcdyKgDTO)
                pageRender(data.count, data.curr + 1)
            } else {
                $("#bdcdyList").html("无数据")
                $("#bdcdyList").addClass('no-info')
                $("#bdcdyList").removeClass('info-content-details');
                $("#paging").hide();
            }
        },
        error: function (data) {
            ityzl_SHOW_TIP_LAYER(data.msg);
        }
    });
}


function initBdcdyh(bdcYxYwxxDTOList, bdcdyKg) {
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laytpl = layui.laytpl;
        var element = layui.element;
        if (bdcYxYwxxDTOList == null) {
            bdcYxYwxxDTOList = [{}]
        }
        var json = {
            data: bdcYxYwxxDTOList,
            bdcdyKg: bdcdyKg
        }
        //获取模板
        var tpl = $("#bdcdyTpl").html();
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            $("#bdcdyList").html(html);
            $("#bdcdyList").removeClass('no-info')
            $("#bdcdyList").addClass('info-content-details');
            $("#paging").show()
        });
        form.render();
        element.render();
    })
}

function pageRender(count, curr) {
    layui.use(['laypage'], function () {
        var laypage = layui.laypage;
        laypage.render({
            elem: 'paging',
            count: count,
            curr: curr,
            limit: 5,
            limits: [5],
            layout: ['prev', 'page', 'next', 'skip', 'count', 'limit'],
            jump: function (obj, first) {
                if (!first) {
                    loadSelectBdcdyh(obj.curr, obj.limit, new Object());
                }
                // console.log(obj)
                // console.log(obj.curr); //得到当前页，以便向服务端请求对应页的数据。
                // console.log(obj.limit); //得到每页显示的条数
            }
        });
    })
}

function queryQlrsjly(qlrsjly) {
    var qlrsjlyVal = "";
    if (isNotBlank(qlrsjly)) {
        if (qlrsjly == 1) {
            qlrsjlyVal = "权籍"
        }
        if (qlrsjly == 2) {
            qlrsjlyVal = "上一手权利人"
        }
        if (qlrsjly == 3) {
            qlrsjlyVal = "上一手义务人"
        }
    }
    return qlrsjlyVal;
}

function queryQlsjly(qlsjly) {
    var qlrsjlyVal = "";
    if (isNotBlank(qlsjly)) {
        if (qlsjly == "1") {
            qlrsjlyVal = "权籍"
        }
        if (qlsjly == "1") {
            qlrsjlyVal = "上一手"
        }
        if (qlsjly == "1,2") {
            qlrsjlyVal = "权籍+上一手"
        }
    }
    return qlrsjlyVal;
}


function querySf(dm, csz) {
    var value = csz;
    if (isNotBlank(dm)) {
        if (dm == 0) {
            value = "否"
        }
        if (dm == 1) {
            value = "是"
        }
    }
    return value;
}

function queryZszl(zslx) {
    var zslxva = "";
    if (isNotBlank(zslx)) {
        if (zslx == 1) {
            zslxva = "证书"
        }
        if (zslx == 2) {
            zslxva = "证明"
        }
    }
    return zslxva;
}


function deleteAll(xmids) {
    $.ajax({
        url: acceptUiUrl + '/gwc/deleteYxxm',
        dataType: 'json',
        data: {xmids: xmids},
        success: function (data) {
            if (data.msg == "success") {
                ityzl_SHOW_TIP_LAYER('删除成功');
                $('#queryBdcdyh').click();
            } else {
                ityzl_SHOW_TIP_LAYER('删除失败，请联系管理员');
            }
        },
        error: function (data) {
            ityzl_SHOW_TIP_LAYER(data.result);
        }
    });

}

function queryDjxl(djxl) {
    var djxlDm = parseInt(djxl);
    for (var i = 0; i < zdDjxlList.length; i++) {
        if (djxlDm === zdDjxlList[i].DM) {
            djxl = zdDjxlList[i].MC;
        }
    }
    return djxl;
}
