package cn.gtmap.realestate.supervise.utils;


import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.Cookie;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;

/**
 * @author hqz
 * @version 1.0, 2017/5/3
 * @description HttpClient访问工具类
 */
public class HttpClientUtil {

    private final static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String sendHttpClient(String url, Map<String, String> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());//使用连接池技术创建
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    i++;
                }
                postMethod.addParameters(postData);
                // too many open file 设置关闭 begin
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                // too many open file 设置关闭 end

                httpClient.executeMethod(postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }

                return json.toString();
            }
        } catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", e);
        }
        return null;
    }

    public static String sendHttpClient(String url, Map<String, String> paramMap,Cookie[] cookies) throws IOException {
        HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());//使用连接池技术创建
        PostMethod postMethod = new PostMethod(url);
        if(null!= cookies && cookies.length != 0){
            StringBuffer cookieStr = new StringBuffer();
            for(int i=0;i<cookies.length;i++){
                cookieStr.append(cookies[i].getName());
                cookieStr.append("=");
                cookieStr.append(cookies[i].getValue()).append(";");
            }
            postMethod.setRequestHeader("Cookie", cookieStr.toString());
        }
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    i++;
                }
                postMethod.addParameters(postData);
                // too many open file 设置关闭 begin
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                // too many open file 设置关闭 end

                httpClient.executeMethod(postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }

                return json.toString();
            }
        } catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", e);
        }
        return null;
    }

    public static String sendHttpDataClient(String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                // too many open file 设置关闭 begin
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                // too many open file 设置关闭 end
                httpClient.executeMethod(postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        } catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpDataClient Exception!{}", e);
        }
        return null;
    }


    public static String sendHttpClientJson(String min, String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());//使用连接池技术创建
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (StringUtils.isNotBlank(min)) {
                int milS = Integer.parseInt(min) * 60 * 1000;
                httpClient.setTimeout(milS);
                httpClient.setConnectionTimeout(milS);
            }
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                // too many open file 设置关闭 begin
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                // too many open file 设置关闭 end
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                httpClient.executeMethod(postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        } catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", e);
        }
        return null;
    }
}
