package cn.gtmap.realestate.supervise.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.multipart.MultipartFile;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 外网作风问题佐证材料表(ZfZzcl)实体类
 *
 * @author zhangjingen
 * @since 2023-12-11 13:54:34
 */
@Table(name = "ZF_WW_ZZCL")
public class ZfWwZzcl implements Serializable {
    /**
     * 主键
     */
    @Id
    private String id;
    /**
     * 问题信息ID
     */
    private String wtxxid;
    /**
     * 文件名称
     */
    private String wjmc;
    /**
     * 文件格式
     */
    private String wjgs;
    /**
     * 文件路径
     */
    private String wjlj;
    /**
     * 上传时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date scsj;

    @Transient
    private MultipartFile file;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWtxxid() {
        return wtxxid;
    }

    public void setWtxxid(String wtxxid) {
        this.wtxxid = wtxxid;
    }

    public String getWjmc() {
        return wjmc;
    }

    public void setWjmc(String wjmc) {
        this.wjmc = wjmc;
    }

    public String getWjgs() {
        return wjgs;
    }

    public void setWjgs(String wjgs) {
        this.wjgs = wjgs;
    }

    public String getWjlj() {
        return wjlj;
    }

    public void setWjlj(String wjlj) {
        this.wjlj = wjlj;
    }

    public Date getScsj() {
        return scsj;
    }

    public void setScsj(Date scsj) {
        this.scsj = scsj;
    }

    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }
}

