package cn.gtmap.realestate.supervise.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 外网作风问题信息历史表(ZfWtrw)实体类
 *
 * @author zhangjingen
 * @since 2023-12-11 13:54:34
 */
@Table(name = "ZF_WW_WTRWLS")
public class ZfWwWtrwls implements Serializable {
    /**
     * 主键
     */
    @Id
    private String id;
    /**
     * 问题编号
     */
    private String wtbh;
    /**
     * 市级代码
     */
    private String sjdm;
    /**
     * 区县代码
     */
    private String qxdm;
    /**
     * 问题标题
     */
    private String wtbt;
    /**
     * 反映人姓名
     */
    private String fyrxm;
    /**
     * 反映人联系电话
     */
    private String fyrlxdh;
    /**
     * 问题类型
     */
    private String wtlx;
    /**
     * 被反映网点代码
     */
    private String bfywddm;
    /**
     * 问题描述
     */
    private String wtms;
    /**
     * 事件发生日期 
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sjfsrq;
    /**
     * 上报状态（0：待办 1：已办 ）
     */
    private String rwzt;
    /**
     * 上报时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sbsj;
    /**
     * 整改状态（0：未整改 1：已整改 ）
     */
    private String zgzt;
    /**
     * 整改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date zgsj;
    /**
     * 整改措施
     */
    private String zgcs;
    /**
     * 删除人姓名
     */
    private String scrxm;
    /**
     * 删除时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date scsj;
    /**
     * 删除原因
     */
    private String scyy;
    /**
     * 填报时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date tbsj;
    /**
     * 导入时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date drsj;

    /**
     * 数据来源 1：网页端,2：移动端
     */
    private String sjly;

    @Transient
    private String isAdd;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWtbh() {
        return wtbh;
    }

    public void setWtbh(String wtbh) {
        this.wtbh = wtbh;
    }

    public String getSjdm() {
        return sjdm;
    }

    public void setSjdm(String sjdm) {
        this.sjdm = sjdm;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public String getWtbt() {
        return wtbt;
    }

    public void setWtbt(String wtbt) {
        this.wtbt = wtbt;
    }

    public String getFyrxm() {
        return fyrxm;
    }

    public void setFyrxm(String fyrxm) {
        this.fyrxm = fyrxm;
    }

    public String getFyrlxdh() {
        return fyrlxdh;
    }

    public void setFyrlxdh(String fyrlxdh) {
        this.fyrlxdh = fyrlxdh;
    }

    public String getWtlx() {
        return wtlx;
    }

    public void setWtlx(String wtlx) {
        this.wtlx = wtlx;
    }

    public String getBfywddm() {
        return bfywddm;
    }

    public void setBfywddm(String bfywddm) {
        this.bfywddm = bfywddm;
    }

    public String getWtms() {
        return wtms;
    }

    public void setWtms(String wtms) {
        this.wtms = wtms;
    }

    public Date getSjfsrq() {
        return sjfsrq;
    }

    public void setSjfsrq(Date sjfsrq) {
        this.sjfsrq = sjfsrq;
    }

    public String getRwzt() {
        return rwzt;
    }

    public void setRwzt(String rwzt) {
        this.rwzt = rwzt;
    }

    public Date getSbsj() {
        return sbsj;
    }

    public void setSbsj(Date sbsj) {
        this.sbsj = sbsj;
    }

    public String getZgzt() {
        return zgzt;
    }

    public void setZgzt(String zgzt) {
        this.zgzt = zgzt;
    }

    public Date getZgsj() {
        return zgsj;
    }

    public void setZgsj(Date zgsj) {
        this.zgsj = zgsj;
    }

    public String getZgcs() {
        return zgcs;
    }

    public void setZgcs(String zgcs) {
        this.zgcs = zgcs;
    }

    public String getScrxm() {
        return scrxm;
    }

    public void setScrxm(String scrxm) {
        this.scrxm = scrxm;
    }

    public Date getScsj() {
        return scsj;
    }

    public void setScsj(Date scsj) {
        this.scsj = scsj;
    }

    public String getScyy() {
        return scyy;
    }

    public void setScyy(String scyy) {
        this.scyy = scyy;
    }

    public Date getTbsj() {
        return tbsj;
    }

    public void setTbsj(Date tbsj) {
        this.tbsj = tbsj;
    }

    public Date getDrsj() {
        return drsj;
    }

    public void setDrsj(Date drsj) {
        this.drsj = drsj;
    }

    public String getSjly() {
        return sjly;
    }

    public void setSjly(String sjly) {
        this.sjly = sjly;
    }

    public String getIsAdd() {
        return isAdd;
    }

    public void setIsAdd(String isAdd) {
        this.isAdd = isAdd;
    }
}

