package cn.gtmap.realestate.supervise.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.io.Serializable;

/**
 * 作风问题信息表(ZfWtrw)实体类
 *
 * @author zhangjingen
 * @since 2023-10-24 13:54:34
 */
@Table(name = "ZF_WTRW")
public class ZfWtrw implements Serializable {
    /**
     * 主键
     */
    @Id
    private String id;
    /**
     * 问题编号
     */
    private String wtbh;
    /**
     * 市级代码
     */
    private String sjdm;
    /**
     * 区县代码
     */
    private String qxdm;
    /**
     * 问题标题
     */
    private String wtbt;
    /**
     * 投诉人姓名
     */
    private String tsrxm;
    /**
     * 投诉人联系 电话 
     */
    private String tsrlxdh;
    /**
     * 问题来源
     */
    private String wtly;
    /**
     * 问题类型
     */
    private String wtlx;
    /**
     * 被投诉对象名称
     */
    private String btsdxmc;
    /**
     * 投诉内容
     */
    private String tsnr;
    /**
     * 事件发生日期 
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sjfsrq;
    /**
     * 填报人
     */
    private String tbr;
    /**
     * 填报时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date tbsj;
    /**
     * 上报状态（0：未上报 1：已上报 ）
     */
    private String rwzt;
    /**
     * 上报时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sbsj;
    /**
     * 整改状态（0：未整改 1：已整改 ）
     */
    private String zgzt;
    /**
     * 整改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date zgsj;
    /**
     * 整改措施
     */
    private String zgcs;

    /**
     * 是否为我的已办提交保存(0:否,1:是)
     */
    @Transient
    private String wdyb;

    @Transient
    private String isAdd;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWtbh() {
        return wtbh;
    }

    public void setWtbh(String wtbh) {
        this.wtbh = wtbh;
    }

    public String getSjdm() {
        return sjdm;
    }

    public void setSjdm(String sjdm) {
        this.sjdm = sjdm;
    }

    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public String getWtbt() {
        return wtbt;
    }

    public void setWtbt(String wtbt) {
        this.wtbt = wtbt;
    }

    public String getTsrxm() {
        return tsrxm;
    }

    public void setTsrxm(String tsrxm) {
        this.tsrxm = tsrxm;
    }

    public String getTsrlxdh() {
        return tsrlxdh;
    }

    public void setTsrlxdh(String tsrlxdh) {
        this.tsrlxdh = tsrlxdh;
    }

    public String getWtly() {
        return wtly;
    }

    public void setWtly(String wtly) {
        this.wtly = wtly;
    }

    public String getWtlx() {
        return wtlx;
    }

    public void setWtlx(String wtlx) {
        this.wtlx = wtlx;
    }

    public String getBtsdxmc() {
        return btsdxmc;
    }

    public void setBtsdxmc(String btsdxmc) {
        this.btsdxmc = btsdxmc;
    }

    public String getTsnr() {
        return tsnr;
    }

    public void setTsnr(String tsnr) {
        this.tsnr = tsnr;
    }

    public Date getSjfsrq() {
        return sjfsrq;
    }

    public void setSjfsrq(Date sjfsrq) {
        this.sjfsrq = sjfsrq;
    }

    public String getTbr() {
        return tbr;
    }

    public void setTbr(String tbr) {
        this.tbr = tbr;
    }

    public Date getTbsj() {
        return tbsj;
    }

    public void setTbsj(Date tbsj) {
        this.tbsj = tbsj;
    }

    public String getRwzt() {
        return rwzt;
    }

    public void setRwzt(String rwzt) {
        this.rwzt = rwzt;
    }

    public Date getSbsj() {
        return sbsj;
    }

    public void setSbsj(Date sbsj) {
        this.sbsj = sbsj;
    }

    public String getZgzt() {
        return zgzt;
    }

    public void setZgzt(String zgzt) {
        this.zgzt = zgzt;
    }

    public Date getZgsj() {
        return zgsj;
    }

    public void setZgsj(Date zgsj) {
        this.zgsj = zgsj;
    }

    public String getZgcs() {
        return zgcs;
    }

    public void setZgcs(String zgcs) {
        this.zgcs = zgcs;
    }

    public String getWdyb() {
        return wdyb;
    }

    public void setWdyb(String wdyb) {
        this.wdyb = wdyb;
    }

    public String getIsAdd() {
        return isAdd;
    }

    public void setIsAdd(String isAdd) {
        this.isAdd = isAdd;
    }
}

