package cn.gtmap.realestate.supervise.aes;

import cn.gtmap.realestate.supervise.core.reflect.encrypt;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/6/19
 * @description 为配合mybatis插件实现的加密模板父类方法
 */
public abstract class SecurityUtil {

    /**
     * @param encrypted 密文字节数组
     *                  密钥
     * @return 解密后的字符串
     */
    public abstract String decrypt(String encrypted);

    /**
     * 密钥
     *
     * @param clearPwd 明文字符串
     * @return 密文字节数组
     */
    public abstract String encrypt(String clearPwd);


    /**
     * 获取解密秘钥的字节流，如果是对称加密解密和加密字节流相同如果不是就不同
     *
     * @return
     */
    public abstract byte[] getDecrKey();

    /**
     * 获取加密秘钥的字节流，如果是对称加密解密和加密字节流相同如果不是就不同
     *
     * @return
     */
    public abstract byte[] getEncrKey();


    /**
     * 对对象注解信息的缓存，记录mybatis过滤的java类包含的需要加密字段的名称
     */
    Map<Class<?>, List<String>> classParams = new HashMap<Class<?>, List<String>>();


    /**
     * @param source 需要装换的javabean对象
     * @param type   自己私自定义为1是加密2是解密
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public void dealField(Object source, int type) throws InvocationTargetException, IllegalAccessException {
        Method[] sourceMethods = source.getClass().getMethods();
        Class<?> c = source.getClass();
        List<String> encryptFields = getAllAnnoationInfo(c);
        Map<String, Object> changeValue = new HashMap<String, Object>();
        if (encryptFields.size() > 0) {
            for (int i = 0; i < sourceMethods.length; i++) {
                if (sourceMethods[i].getName().startsWith("get")) {
                    String lsName = sourceMethods[i].getName().substring(3);// 属性
                    if (encryptFields.contains(lsName.toLowerCase())) {
                        Object loValue = sourceMethods[i].invoke(source, null);  // 值
                        changeValue.put(lsName.toLowerCase(), loValue);
                    }
                }
            }


            for (int i = 0; i < sourceMethods.length; i++) {
                if (sourceMethods[i].getName().startsWith("set")) {
                    String lsName = sourceMethods[i].getName().substring(3);// 属性
                    if (encryptFields.contains(lsName.toLowerCase())) {
                        Object object = changeValue.get(lsName.toLowerCase());
                        if (null != object) {
                            String encryptBefore = changeValue.get(lsName.toLowerCase()).toString();
                            if (type == 1) {//加密
                                sourceMethods[i].invoke(source, encrypt(encryptBefore));
                            } else if (type == 2) {//解密
                                sourceMethods[i].invoke(source, decrypt(encryptBefore));
                            }
                        }

                    }
                }
            }
        }
    }

    /**
     * @param source 需要加密的对象
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public void EncryptField(Object source) throws InvocationTargetException, IllegalAccessException {
        dealField(source, 1);
    }

    /**
     * @param source 需要解密的对象
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public void DecryptField(Object source) throws InvocationTargetException, IllegalAccessException {
        dealField(source, 2);
    }

    /**
     * @param o 根据类的信息获取需要加密字段信息并缓存（反射比较花费时间尽一切可能减少反射的使用）
     * @return
     */
    public List<String> getAllAnnoationInfo(Class<?> o) {
        if (classParams.get(o) != null) {
            return classParams.get(o);
        } else {
            List<String> datas = new ArrayList<String>();
            Field[] field = o.getDeclaredFields();
            for (Field f : field) {
                encrypt encrypt = f.getAnnotation(encrypt.class);
                if (encrypt != null) {
                    datas.add(f.getName());
                    continue;
                }
            }
            classParams.put(o, datas);
            return datas;
        }
    }

}
