/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String sendHttpClient(String url, Map<String, String> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpClient(String url, Map<String, String> paramMap, Cookie[] cookies) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        if (null != cookies && cookies.length != 0) {
            StringBuffer cookieStr = new StringBuffer();
            for (int i = 0; i < cookies.length; ++i) {
                cookieStr.append(cookies[i].getName());
                cookieStr.append("=");
                cookieStr.append(cookies[i].getValue()).append(";");
            }
            postMethod.setRequestHeader("Cookie", cookieStr.toString());
        }
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpDataClient(String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpDataClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpClientJson(String min, String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (StringUtils.isNotBlank((CharSequence)min)) {
                int milS = Integer.parseInt(min) * 60 * 1000;
                httpClient.setTimeout(milS);
                httpClient.setConnectionTimeout(milS);
            }
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", (Throwable)e);
        }
        return null;
    }
}

