/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class PropertyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperty(String path) {
        Properties props = null;
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(path), "GBK");
            props = new Properties();
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    public static Properties readProperty(InputStream in) {
        Properties props = null;
        try {
            props = new Properties();
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public static int getIntProperty(String key, int defaultValue, Properties properties) {
        String property = properties.getProperty(key);
        int value = defaultValue;
        if (null != property) {
            value = Integer.valueOf(property);
        }
        return value;
    }

    public static Long getLongProperty(String key, Long defaultValue, Properties properties) {
        String property = properties.getProperty(key);
        Long result = defaultValue;
        if (null != property) {
            result = Long.valueOf(property);
        }
        return result;
    }

    public static Float getFloatProperty(String key, Float defaultValue, Properties properties) {
        String property = properties.getProperty(key);
        Float result = defaultValue;
        if (null != property) {
            result = Float.valueOf(Float.parseFloat(property));
        }
        return result;
    }

    public static Boolean getBooleanProperty(String key, Boolean defaultValue, Properties properties) {
        String property = properties.getProperty(key);
        Boolean result = defaultValue;
        if (null != property) {
            result = Boolean.valueOf(property);
        }
        return result;
    }

    private PropertyUtil() {
    }
}

