/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.util.DesConstants;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MsgSubUtil {
    public static void sub(String msg, List<String> keys, LinkedHashSet<String> values) {
        for (String key : keys) {
            if (StringUtils.isBlank((CharSequence)key)) continue;
            StringBuilder reg = new StringBuilder();
            for (String symbol : DesConstants.subSymbols) {
                if (StringUtils.isNotBlank((CharSequence)reg)) {
                    reg.append("|").append(key).append(symbol);
                    continue;
                }
                reg.append(key).append(symbol);
            }
            MsgSubUtil.msgSubstringHandle(msg.split(reg.toString()), values);
        }
    }

    private static void msgSubstringHandle(String[] strs, LinkedHashSet<String> values) {
        if (null != strs && strs.length > 1) {
            for (int i = 1; i < strs.length; ++i) {
                int valueStart;
                int valueEnd;
                String s = strs[i];
                if (s.startsWith(":{") || s.startsWith(":[{") || (valueEnd = MsgSubUtil.getValueEndIndex(s, valueStart = MsgSubUtil.getValueStartIndex(s))) <= valueStart) continue;
                String subStr = s.substring(valueStart, valueEnd);
                values.add(subStr);
            }
        }
    }

    private static int getValueStartIndex(String msg) {
        char ch;
        int valueStart = 0;
        while (DesConstants.vsSubSymbols.indexOf(ch = msg.charAt(valueStart)) > -1 && ++valueStart != msg.length()) {
        }
        return valueStart;
    }

    private static int getValueEndIndex(String msg, int valueEnd) {
        char ch;
        while (DesConstants.veSubSymbols.indexOf(ch = msg.charAt(valueEnd)) <= -1 && ++valueEnd != msg.length()) {
        }
        return valueEnd;
    }
}

