/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.enums.DesensitizerItem;
import cn.gtmap.realestate.enums.DesensitizerMethod;
import cn.gtmap.realestate.model.MsgHandleRunnable;
import cn.gtmap.realestate.model.ThreadPool;
import cn.gtmap.realestate.model.des.Ruler;
import cn.gtmap.realestate.service.DesensitizerService;
import cn.gtmap.realestate.service.ReplaceService;
import cn.gtmap.realestate.service.impl.des.ReplaceDesensitizer;
import cn.gtmap.realestate.service.impl.des.Sm4EncryptDesensitizer;
import cn.gtmap.realestate.service.impl.replace.ShowLeftReplace;
import cn.gtmap.realestate.service.impl.replace.ShowRightReplace;
import cn.gtmap.realestate.service.impl.replace.ShowTwoSidesReplace;
import cn.gtmap.realestate.util.DesConstants;
import com.alibaba.fastjson.JSON;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;

public class DesensitizeUtil {
    private static Map<String, String> msgHandle(String msg, DesensitizerMethod desensitizerMethod) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
            msg = msg.replaceAll("\\s*", "");
            msg = msg.replaceAll("[\\\\]+", "\\\\");
            if (null != DesConstants.rulers && DesConstants.rulers.size() > 0) {
                CountDownLatch latchSub = new CountDownLatch(DesConstants.rulers.size());
                LinkedHashMap<String, String> handleMap = new LinkedHashMap<String, String>();
                for (Ruler ruler : DesConstants.rulers) {
                    ThreadPool.execute(new MsgHandleRunnable(msg, latchSub, ruler.getRulerKeys(), handleMap, DesensitizeUtil.getDesensitizer(desensitizerMethod, ruler)));
                }
                try {
                    latchSub.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return handleMap;
            }
        }
        return null;
    }

    public static String desensitize(String msg) {
        Map<String, String> handleMap;
        if (DesConstants.desensitizerSwitch && null != (handleMap = DesensitizeUtil.msgHandle(msg, DesensitizerMethod.desensitize)) && handleMap.size() > 0) {
            for (Map.Entry<String, String> entry : handleMap.entrySet()) {
                msg = msg.replace(entry.getKey(), entry.getValue());
            }
        }
        return msg;
    }

    public static <T> T desensitize(Object obj, Class<T> clazz) {
        String str = JSON.toJSONString((Object)obj);
        try {
            str = DesensitizeUtil.desensitize(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)JSON.parseObject((String)str, clazz);
    }

    public static String reduction(String msg) {
        Map<String, String> handleMap;
        if (DesConstants.desensitizerSwitch && DesConstants.desensitizerItem != DesensitizerItem.replace && null != (handleMap = DesensitizeUtil.msgHandle(msg, DesensitizerMethod.reduction)) && handleMap.size() > 0) {
            for (Map.Entry<String, String> entry : handleMap.entrySet()) {
                msg = msg.replace(entry.getKey(), entry.getValue());
            }
        }
        return msg;
    }

    public static <T> T reduction(Object obj, Class<T> clazz) {
        String str = JSON.toJSONString((Object)obj);
        try {
            str = DesensitizeUtil.reduction(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)JSON.parseObject((String)str, clazz);
    }

    public static DesensitizerService getDesensitizer(DesensitizerMethod desensitizerMethod, Ruler replaceRuler) {
        DesensitizerService desensitizer;
        switch (DesConstants.desensitizerItem) {
            case replace: {
                desensitizer = new ReplaceDesensitizer(desensitizerMethod, replaceRuler);
                break;
            }
            case sm4: {
                desensitizer = new Sm4EncryptDesensitizer(desensitizerMethod);
                break;
            }
            default: {
                desensitizer = new ReplaceDesensitizer(desensitizerMethod, replaceRuler);
            }
        }
        return desensitizer;
    }

    public static ReplaceService getReplace(Ruler replaceRuler) {
        ReplaceService replace = null;
        switch (replaceRuler.getRulerItem()) {
            case left: {
                replace = new ShowLeftReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
                break;
            }
            case right: {
                replace = new ShowRightReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
                break;
            }
            case center: {
                replace = new ShowTwoSidesReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
            }
        }
        return replace;
    }

    private DesensitizeUtil() {
    }
}

