/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.enums.DesensitizerItem;
import cn.gtmap.realestate.model.des.Desensitizer;
import cn.gtmap.realestate.model.des.Ruler;
import cn.gtmap.realestate.util.FileUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DesConstants {
    private static Desensitizer desensitizer;
    public static boolean desensitizerSwitch;
    public static DesensitizerItem desensitizerItem;
    public static List<Ruler> rulers;
    public static List<String> subSymbols;
    public static String vsSubSymbols;
    public static String veSubSymbols;
    public static String symbol;
    public static final String SPACE_REGEX = "\\s*";
    public static final String BACKSLASH_REGEX = "[\\\\]+";
    public static final String BACKSLASH = "\\\\";
    public static final String SPACE = "";
    public static final String ENCRYPT_PREFIX = "PAMTG";
    public static final String OR_REGEX = "|";

    public static void initDesensitizer() {
        desensitizer = FileUtil.initDesensitizer();
        DesConstants.initDesensitizer(desensitizer);
    }

    public static void initDesensitizer(String desXmlPath) {
        desensitizer = FileUtil.initDesensitizer(desXmlPath);
        DesConstants.initDesensitizer(desensitizer);
    }

    public static void initDesensitizer(byte[] bytes) {
        desensitizer = FileUtil.initDesensitizer(bytes);
        DesConstants.initDesensitizer(desensitizer);
    }

    private static void initDesensitizer(Desensitizer desensitizer) {
        if (null != desensitizer) {
            desensitizerSwitch = desensitizer.isDesensitizerSwitch();
            if (null != desensitizer.getDesensitizerItem()) {
                desensitizerItem = desensitizer.getDesensitizerItem();
            }
            if (null != desensitizer.getRuler()) {
                rulers = desensitizer.getRuler();
            }
            if (null != desensitizer.getKeyStartSubSymbols()) {
                subSymbols = desensitizer.getKeyStartSubSymbols();
            }
            if (StringUtils.isNotBlank((CharSequence)desensitizer.getValueStartSubSymbols())) {
                vsSubSymbols = desensitizer.getValueStartSubSymbols();
            }
            if (StringUtils.isNotBlank((CharSequence)desensitizer.getValueEndSubSymbols())) {
                veSubSymbols = desensitizer.getValueEndSubSymbols();
            }
            if (StringUtils.isNotBlank((CharSequence)desensitizer.getReplaceSymbol())) {
                symbol = desensitizer.getReplaceSymbol();
            }
        }
    }

    static {
        desensitizerSwitch = false;
        desensitizerItem = DesensitizerItem.replace;
        subSymbols = Arrays.asList("\"", BACKSLASH, "\uff1a", "=", ";", ":");
        vsSubSymbols = "\"\\=\uff1b:";
        veSubSymbols = "\"\\,\uff0c]}";
        symbol = "*";
    }
}

