/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.service.impl.des;

import cn.gtmap.realestate.enums.DesensitizerMethod;
import cn.gtmap.realestate.model.des.Ruler;
import cn.gtmap.realestate.service.DesensitizerService;
import cn.gtmap.realestate.util.SM4Util;
import org.apache.commons.lang3.StringUtils;

public class Sm4EncryptDesensitizer
implements DesensitizerService {
    private DesensitizerMethod desensitizerMethod;
    private Ruler replaceRuler;

    public Sm4EncryptDesensitizer() {
    }

    public Sm4EncryptDesensitizer(DesensitizerMethod desensitizerMethod) {
        this.desensitizerMethod = desensitizerMethod;
    }

    public Sm4EncryptDesensitizer(DesensitizerMethod desensitizerMethod, Ruler replaceRuler) {
        this.desensitizerMethod = desensitizerMethod;
        this.replaceRuler = replaceRuler;
    }

    private String desHandle(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return "PAMTG" + SM4Util.encryptData_ECB((String)value, (String)SM4Util.BASE64_STR);
    }

    private String redHandle(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.startsWith("PAMTG")) {
            return SM4Util.decryptData_ECB((String)value.substring("PAMTG".length()), (String)SM4Util.BASE64_STR);
        }
        return value;
    }

    @Override
    public String handle(String value) {
        switch (this.desensitizerMethod) {
            case desensitize: {
                value = this.desHandle(value);
                break;
            }
            case reduction: {
                value = this.redHandle(value);
                break;
            }
        }
        return value;
    }

    @Override
    public DesensitizerMethod getDesensitizerMethod() {
        return this.desensitizerMethod;
    }

    @Override
    public void setDesensitizerMethod(DesensitizerMethod desensitizerMethod) {
        this.desensitizerMethod = desensitizerMethod;
    }

    @Override
    public Ruler getReplaceRuler() {
        return this.replaceRuler;
    }

    @Override
    public void setReplaceRuler(Ruler replaceRuler) {
        this.replaceRuler = replaceRuler;
    }
}

