/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.service.impl.des;

import cn.gtmap.realestate.enums.DesensitizerMethod;
import cn.gtmap.realestate.model.des.Ruler;
import cn.gtmap.realestate.service.DesensitizerService;
import cn.gtmap.realestate.service.ReplaceService;
import cn.gtmap.realestate.util.DesensitizeUtil;
import org.apache.commons.lang3.StringUtils;

public class ReplaceDesensitizer
implements DesensitizerService {
    private DesensitizerMethod desensitizerMethod;
    private Ruler replaceRuler;

    public ReplaceDesensitizer() {
    }

    public ReplaceDesensitizer(DesensitizerMethod desensitizerMethod, Ruler replaceRuler) {
        this.desensitizerMethod = desensitizerMethod;
        this.replaceRuler = replaceRuler;
    }

    private String desHandle(String value) {
        ReplaceService replace;
        if (StringUtils.isNotBlank((CharSequence)value) && null != (replace = DesensitizeUtil.getReplace(this.replaceRuler))) {
            return replace.replace(value);
        }
        return value;
    }

    private String redHandle(String value) {
        return value;
    }

    @Override
    public String handle(String value) {
        switch (this.desensitizerMethod) {
            case desensitize: {
                value = this.desHandle(value);
                break;
            }
            case reduction: {
                value = this.redHandle(value);
                break;
            }
        }
        return value;
    }

    @Override
    public DesensitizerMethod getDesensitizerMethod() {
        return this.desensitizerMethod;
    }

    @Override
    public void setDesensitizerMethod(DesensitizerMethod desensitizerMethod) {
        this.desensitizerMethod = desensitizerMethod;
    }

    @Override
    public Ruler getReplaceRuler() {
        return this.replaceRuler;
    }

    @Override
    public void setReplaceRuler(Ruler replaceRuler) {
        this.replaceRuler = replaceRuler;
    }
}

