/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.model;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static final int corePoolSize = Runtime.getRuntime().availableProcessors();
    private static final int maximumPoolSize = corePoolSize * 2;
    private static final int keepAliveTime = 60000;
    private static final TimeUnit unit = TimeUnit.MILLISECONDS;
    private static final BlockingQueue<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
    private static final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static final RejectedExecutionHandler handler = new ThreadPoolExecutor.DiscardPolicy();
    private static final ExecutorService executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60000L, unit, workQueue, threadFactory, handler);

    public static void execute(Runnable task) {
        executor.execute(task);
    }

    public static Future submit(Runnable task) {
        return executor.submit(task);
    }
}

