/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static final String IMAGE_FORMAT_JPG = "jpg";

    public static byte[] imageAddWaterMark(InputStream inputStream, Color color, Font font, String waterMarkContent, String imageFormat, Double degree, Integer x, Integer y) throws IOException {
        BufferedImage srcImg = ImageIO.read(inputStream);
        int srcImgWidth = ((Image)srcImg).getWidth(null);
        int srcImgHeight = ((Image)srcImg).getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
        g.setColor(color);
        g.setFont(font);
        if (null != degree) {
            g.rotate(Math.toRadians(degree));
        }
        if (null == x) {
            x = -50;
        }
        if (null == y) {
            y = srcImgHeight - Math.round(srcImgHeight / 4);
        }
        g.drawString(waterMarkContent, (int)x, (int)y);
        g.dispose();
        if (null == imageFormat || "".equals(imageFormat)) {
            imageFormat = ImageUtil.getImageFormat(inputStream);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufImg, imageFormat, os);
        return os.toByteArray();
    }

    public static String getImageFormat(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator.hasNext()) {
            return iterator.next().getFormatName();
        }
        return IMAGE_FORMAT_JPG;
    }

    private ImageUtil() {
    }
}

