/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.model.excel.CustomMergeStrategy;
import cn.gtmap.realestate.model.excel.CustomTemplateSheetHandler;
import cn.gtmap.realestate.model.excel.ExportSheet;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public class ExportExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] exportExcel(String templateFilePath, ExportSheet exportSheet) throws IOException {
        ExcelWriter excelWriter = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            excelWriter = null != exportSheet.getCls() ? EasyExcel.write((OutputStream)bos, (Class)exportSheet.getCls()).withTemplate(templateFilePath).build() : EasyExcel.write((OutputStream)bos).withTemplate(templateFilePath).build();
            ExportExcelUtil.WriteSheet(excelWriter, exportSheet);
        }
        finally {
            if (null != excelWriter) {
                excelWriter.finish();
            }
            bos.close();
        }
        return bos.toByteArray();
    }

    public static void WriteSheet(ExcelWriter excelWriter, ExportSheet exportSheet) {
        ExcelWriterSheetBuilder sheetBuilder = exportSheet.isUpdateSheetName() && !StringUtils.isEmpty((Object)exportSheet.getSheetName()) ? (ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)exportSheet.getSheetNo()).registerWriteHandler((WriteHandler)new CustomTemplateSheetHandler(exportSheet.getSheetNo(), exportSheet.getSheetName())) : (!StringUtils.isEmpty((Object)exportSheet.getSheetName()) ? EasyExcel.writerSheet((String)exportSheet.getSheetName()) : EasyExcel.writerSheet());
        if (exportSheet.isMergeCol()) {
            sheetBuilder.registerWriteHandler((WriteHandler)new CustomMergeStrategy(exportSheet.getMergeColIndexs(), exportSheet.getBodys() != null ? exportSheet.getBodys().size() : 0));
        }
        WriteSheet writeSheet = sheetBuilder.build();
        if (!CollectionUtils.isEmpty((Collection)exportSheet.getBodys())) {
            if (StringUtils.isEmpty((Object)exportSheet.getBodyKey())) {
                excelWriter.fill((Object)exportSheet.getBodys(), writeSheet);
            } else {
                excelWriter.fill((Object)new FillWrapper(exportSheet.getBodyKey(), (Collection)exportSheet.getBodys()), writeSheet);
            }
        }
        if (null != exportSheet.getHead()) {
            excelWriter.fill(exportSheet.getHead(), writeSheet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static byte[] exportExcel(String templateFilePath, List list, Object obj) throws IOException {
        ExcelWriter excelWriter = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            excelWriter = EasyExcel.write((OutputStream)bos).withTemplate(templateFilePath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                excelWriter.fill((Object)list, writeSheet);
            }
            if (null != obj) {
                excelWriter.fill(obj, writeSheet);
            }
        }
        finally {
            if (null != excelWriter) {
                excelWriter.finish();
            }
            bos.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static byte[] exportExcel(String filePath, List list) throws IOException {
        ExcelWriter excelWriter = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            excelWriter = EasyExcel.write((OutputStream)bos).withTemplate(filePath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                excelWriter.fill((Object)list, writeSheet);
            }
        }
        finally {
            if (null != excelWriter) {
                excelWriter.finish();
            }
            bos.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void exportExcel(String filePath, String resultFilePath, List list) {
        ExcelWriter excelWriter = null;
        try {
            excelWriter = EasyExcel.write((String)resultFilePath).withTemplate(filePath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                excelWriter.fill((Object)list, writeSheet);
            }
        }
        finally {
            if (null != excelWriter) {
                excelWriter.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void exportExcel(String filePath, String resultFilePath, List list, Object obj) {
        ExcelWriter excelWriter = null;
        try {
            excelWriter = EasyExcel.write((String)resultFilePath).withTemplate(filePath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                excelWriter.fill((Object)list, writeSheet);
            }
            if (null != obj) {
                excelWriter.fill(obj, writeSheet);
            }
        }
        finally {
            if (null != excelWriter) {
                excelWriter.finish();
            }
        }
    }
}

