/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.model.sftp;

import com.alibaba.excel.util.StringUtils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SftpConnect {
    private static final int CLIENT_TIMEOUT = 3600000;
    private ChannelSftp channelSftp;
    private Session session;
    private String serverIP;
    private Integer port;
    private String username;
    private String password;

    public void connectFtp() {
        try {
            this.session = new JSch().getSession(this.username, this.serverIP, this.port.intValue());
            this.session.setTimeout(3600000);
            if (!StringUtils.isEmpty((Object)this.password)) {
                this.session.setPassword(this.password);
            }
            Properties properties = new Properties();
            properties.setProperty("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
            this.session.connect();
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.channelSftp = (ChannelSftp)channel;
            this.channelSftp.setFilenameEncoding("UTF-8");
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
    }

    public void checkConnect() throws Exception {
        if (null == this.channelSftp || this.channelSftp.isClosed()) {
            if (null == this.session || !this.session.isConnected()) {
                this.connectFtp();
            } else {
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.channelSftp = (ChannelSftp)channel;
                this.channelSftp.setFilenameEncoding("UTF-8");
            }
        }
    }

    public void disConnect() {
        if (this.channelSftp != null) {
            this.channelSftp.quit();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public void uploadFile(InputStream localInputStream, String remoteFile) throws Exception {
        this.checkConnect();
        String fileNameAbsolute = remoteFile.replaceAll("\\\\", "/");
        String remoteDirectory = fileNameAbsolute.substring(0, fileNameAbsolute.lastIndexOf("/"));
        this.mkdirs(remoteDirectory);
        this.channelSftp.put(localInputStream, remoteFile.replaceAll("\\\\", "/"));
    }

    void mkdirs(String remoteDirectory) throws Exception {
        this.checkConnect();
        try {
            this.channelSftp.cd(remoteDirectory);
        }
        catch (SftpException e) {
            String[] dirs = remoteDirectory.replaceAll("\\\\", "/").split("/");
            String tempPath = "";
            for (String dir : dirs) {
                if (StringUtils.isEmpty((Object)dir)) continue;
                tempPath = tempPath + "/" + dir;
                try {
                    this.channelSftp.cd(tempPath);
                }
                catch (SftpException sftpException) {
                    this.channelSftp.mkdir(tempPath);
                    this.channelSftp.cd(tempPath);
                }
            }
        }
        this.channelSftp.cd(remoteDirectory.replaceAll("\\\\", "/"));
    }

    public InputStream sftpWriter(String remoteFile) throws Exception {
        this.checkConnect();
        return this.channelSftp.get(remoteFile);
    }

    public void ftpDelete(String remoteFile) throws Exception {
        this.checkConnect();
        this.channelSftp.rm(remoteFile);
    }

    public List<String> findFiles(String remoteFileDirectory) throws Exception {
        this.checkConnect();
        ArrayList<String> listFile = new ArrayList<String>();
        Vector vector = this.channelSftp.ls(remoteFileDirectory.replaceAll("\\\\", "/"));
        for (Object obj : vector) {
            ChannelSftp.LsEntry entry;
            if (obj == null || (entry = (ChannelSftp.LsEntry)obj).getAttrs().isDir()) continue;
            listFile.add(entry.getFilename());
        }
        return listFile;
    }

    public void moveFile(String srcFile, String destFile) throws Exception {
        this.checkConnect();
        this.channelSftp.rename(srcFile.replaceAll("\\\\", "/"), destFile.replaceAll("\\\\", "/"));
    }

    public SftpConnect(String serverIP, Integer port, String username, String password) {
        this.serverIP = serverIP;
        if (port != null) {
            this.port = port;
        }
        this.username = username;
        this.password = password;
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    public void setChannelSftp(ChannelSftp channelSftp) {
        this.channelSftp = channelSftp;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

