/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.model.excel;

import cn.gtmap.realestate.model.excel.MergeCellRangeAddress;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
extends AbstractMergeStrategy {
    private List<Integer> columnIndexs;
    private Integer startRow;
    private Integer count;
    private Map<Integer, MergeCellRangeAddress> startRowMap = new HashMap<Integer, MergeCellRangeAddress>(2);

    public CustomMergeStrategy(Integer[] columnIndexs, Integer count) {
        this.columnIndexs = Arrays.asList(columnIndexs);
        this.count = count;
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer integer) {
        this.mergeCol(sheet, cell);
    }

    private void mergeCol(Sheet sheet, Cell cell) {
        boolean lastRow;
        if (CollectionUtils.isEmpty(this.columnIndexs)) {
            return;
        }
        int rowIndex = cell.getRowIndex();
        int columIndex = cell.getColumnIndex();
        String cellValue = this.getCellValue(cell);
        if (null == this.startRow) {
            this.startRow = rowIndex;
        }
        boolean bl = lastRow = this.startRow + this.count - 1 == rowIndex;
        if (!StringUtils.isEmpty((Object)cellValue) && this.columnIndexs.contains(columIndex)) {
            MergeCellRangeAddress cellRangeAddress = this.startRowMap.get(columIndex);
            if (null == cellRangeAddress) {
                this.startRowMap.put(columIndex, new MergeCellRangeAddress(rowIndex, rowIndex, columIndex, columIndex, cellValue));
            } else if (cellValue.equals(cellRangeAddress.getCellValue())) {
                cellRangeAddress.setLastRow(rowIndex);
            } else {
                this.mergeGroupColumn(sheet, cellRangeAddress);
                this.startRowMap.remove(columIndex);
                if (!lastRow) {
                    this.startRowMap.put(columIndex, new MergeCellRangeAddress(rowIndex, rowIndex, columIndex, columIndex, cellValue));
                }
            }
            if (null != cellRangeAddress && lastRow) {
                this.mergeGroupColumn(sheet, cellRangeAddress);
            }
        }
    }

    private void mergeGroupColumn(Sheet sheet, CellRangeAddress cellRangeAddress) {
        if (cellRangeAddress.getLastRow() > cellRangeAddress.getFirstRow()) {
            sheet.addMergedRegionUnsafe(cellRangeAddress);
        }
    }

    private String getCellValue(Cell cell) {
        String cellValue = "";
        switch (cell.getCellTypeEnum()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = cell.toString();
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }
}

