/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);

    public static Claims parseJwt(String jsonWebToken, String base64Security) {
        Claims ex = null;
        try {
            JwtParser jwtParser = Jwts.parser();
            if (StringUtils.isNotBlank((CharSequence)base64Security)) {
                jwtParser.setSigningKey(base64Security.getBytes());
            }
            ex = (Claims)jwtParser.parseClaimsJws(jsonWebToken).getBody();
        }
        catch (Exception e) {
            logger.error("JwtUtil:parseJwt:token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        return ex;
    }

    public static String createJwt(Map<String, Object> claimMap, SignatureAlgorithm signature, long ttlMillis, String base64Security) {
        Date now = JwtUtil.getDateSecond();
        long nowMillis = now.getTime();
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"njgt");
        if (claimMap != null && claimMap.size() > 0) {
            for (String apiKeySecretBytes : claimMap.keySet()) {
                builder.claim(apiKeySecretBytes, claimMap.get(apiKeySecretBytes));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)base64Security)) {
            SignatureAlgorithm expMillis2 = signature != null && signature != SignatureAlgorithm.NONE ? signature : SignatureAlgorithm.HS256;
            byte[] apiKeySecretBytes1 = base64Security.getBytes();
            SecretKeySpec exp = new SecretKeySpec(apiKeySecretBytes1, expMillis2.getJcaName());
            builder.signWith(expMillis2, (Key)exp);
        }
        if (ttlMillis > 0L) {
            long expMillis1 = nowMillis + ttlMillis;
            Date exp1 = new Date(expMillis1);
            builder.setExpiration(exp1);
        }
        builder.setNotBefore(now);
        return builder.compact();
    }

    public static Date getDateSecond() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private JwtUtil() {
    }
}

