/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IDUtils {
    private static final String REGULAR_EXPRESSION = "(^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)";
    private static final Pattern CREDITCODE_PAT = Pattern.compile("^([0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}|[1-9]\\d{14})$");
    private static final String FOREIGN_ID_OLD_PAT = "(^([A-Z]{3}[1-8][0-9]{3}[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9][0-9Xx])$)";
    private static final String FOREIGN_ID_NEW_PAT = "(^([9][1-8][0-9][0-9]{3}[1-2][0-9]{3}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{3}[0-9Xx])$)";

    public static boolean isIdNumber(String idNumber) {
        if (idNumber == null || "".equals(idNumber)) {
            return false;
        }
        boolean matches = idNumber.matches(REGULAR_EXPRESSION);
        if (matches && idNumber.length() == 18) {
            return IDUtils.mod112(idNumber);
        }
        return matches;
    }

    public static boolean isLicense18(String businessCode) {
        if ("".equals(businessCode) || businessCode.length() != 18) {
            return false;
        }
        String baseCode = "0123456789ABCDEFGHJKLMNPQRTUWXY";
        char[] baseCodeArray = baseCode.toCharArray();
        HashMap<Character, Integer> codes = new HashMap<Character, Integer>(2);
        for (int i = 0; i < baseCode.length(); ++i) {
            codes.put(Character.valueOf(baseCodeArray[i]), i);
        }
        char[] businessCodeArray = businessCode.toCharArray();
        Character check = Character.valueOf(businessCodeArray[17]);
        if (baseCode.indexOf(check.charValue()) == -1) {
            return false;
        }
        int[] wi = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            Character key = Character.valueOf(businessCodeArray[i]);
            if (baseCode.indexOf(key.charValue()) == -1) {
                return false;
            }
            sum += (Integer)codes.get(key) * wi[i];
        }
        int value = 31 - sum % 31;
        return value == (Integer)codes.get(check);
    }

    public static boolean isValidSocialCreditCode(String businessCode) {
        Matcher m = CREDITCODE_PAT.matcher(businessCode);
        return m.matches();
    }

    public static boolean isValidForeignerIdCodeOld(String idNumber) {
        if (!idNumber.matches(FOREIGN_ID_OLD_PAT)) {
            return false;
        }
        String yearString = idNumber.substring(7, 9);
        String[] yearArray = new String[]{"0", "1", "2"};
        List<String> yearList = Arrays.asList(yearArray);
        yearString = yearList.contains(yearString.substring(0, 1)) ? "20" + yearString : "19" + yearString;
        Integer year = Integer.parseInt(yearString);
        Integer month = Integer.parseInt(idNumber.substring(9, 11));
        Integer day = Integer.parseInt(idNumber.substring(11, 13));
        return IDUtils.checkDate(year, month, day);
    }

    public static boolean isValidForeignerIdCodeNew(String idNumber) {
        Integer day;
        Integer month;
        if (!idNumber.matches(FOREIGN_ID_NEW_PAT)) {
            return false;
        }
        Integer year = Integer.parseInt(idNumber.substring(6, 10));
        return IDUtils.checkDate(year, month = Integer.valueOf(Integer.parseInt(idNumber.substring(10, 12))), day = Integer.valueOf(Integer.parseInt(idNumber.substring(12, 14)))) && IDUtils.mod112(idNumber);
    }

    private static boolean checkDate(Integer year, Integer month, Integer day) {
        Boolean leapYear = year % 4 == 0 && year % 100 != 0;
        Integer[] dayOfMonth = new Integer[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (leapYear.booleanValue()) {
            dayOfMonth[1] = 29;
        }
        return day <= dayOfMonth[month - 1];
    }

    private static boolean mod112(String idCode) {
        try {
            char[] charArray = idCode.toCharArray();
            int[] idCardWi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
            String[] idCardY = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
            int sum = 0;
            for (int i = 0; i < idCardWi.length; ++i) {
                int current = Integer.parseInt(String.valueOf(charArray[i]));
                int count = current * idCardWi[i];
                sum += count;
            }
            char idCardLast = charArray[17];
            int idCardMod = sum % 11;
            return idCardY[idCardMod].toUpperCase().equals(String.valueOf(idCardLast).toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

