/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.support.mybatis.page.dialect;

import cn.gtmap.realestate.core.support.mybatis.page.dialect.AbstractDialect;
import org.apache.commons.lang3.StringUtils;

public class SqlServerDialect
extends AbstractDialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        return this.getLimitString(sql, offset, limit, Integer.toString(limit));
    }

    private String getLimitString(String querySqlString, int offset, int limit, String limitPlaceholder) {
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = SqlServerDialect.getOrderByPart(querySqlString);
        String distinctStr = "";
        String loweredString = querySqlString.toLowerCase();
        String sqlPartString = querySqlString;
        if (loweredString.trim().startsWith("select")) {
            int result = 6;
            if (loweredString.startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                result = 15;
            }
            sqlPartString = querySqlString.substring(result);
        }
        pagingBuilder.append(sqlPartString);
        if (StringUtils.isBlank((CharSequence)orderby)) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        StringBuilder result1 = new StringBuilder();
        result1.append("WITH query AS (SELECT ").append(distinctStr).append("TOP 100 PERCENT ").append(" ROW_NUMBER() OVER (").append(orderby).append(") as __row_number__, ").append((CharSequence)pagingBuilder).append(") SELECT * FROM query WHERE __row_number__ BETWEEN ").append(offset + 1).append(" AND ").append(offset + limit).append(" ORDER BY __row_number__");
        return result1.toString();
    }

    private static String getOrderByPart(String sql) {
        String loweredString = sql.toLowerCase();
        int orderByIndex = loweredString.indexOf("order by");
        return orderByIndex != -1 ? sql.substring(orderByIndex) : "";
    }
}

