/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.support.mybatis.mapper;

import cn.gtmap.realestate.core.support.mybatis.mapper.AbstractMapperTemplate;
import cn.gtmap.realestate.core.support.mybatis.mapper.EntityHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class MapperHelper {
    private final Map<String, Boolean> msIdSkip = new HashMap<String, Boolean>();
    private Map<Class<?>, AbstractMapperTemplate> registerMapper = new HashMap();
    private Map<String, AbstractMapperTemplate> msIdCache = new HashMap<String, AbstractMapperTemplate>();
    private Set<Collection<MappedStatement>> collectionSet = new HashSet<Collection<MappedStatement>>();
    private boolean spring = false;
    private boolean spring4 = false;
    private String springVersion;
    private boolean notEmpty = false;
    private List<SqlSession> sqlSessions = new ArrayList<SqlSession>();
    private Config config = new Config();

    public MapperHelper() {
    }

    public MapperHelper(Properties properties) {
        this.setProperties(properties);
    }

    public void setSqlSessions(SqlSession[] sqlSessions) {
        if (sqlSessions != null && sqlSessions.length > 0) {
            this.sqlSessions.addAll(Arrays.asList(sqlSessions));
        }
    }

    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public void initMapper() {
        this.initSpringVersion();
        for (SqlSession sqlSession : this.sqlSessions) {
            this.processConfiguration(sqlSession.getConfiguration());
        }
    }

    private void initSpringVersion() {
        try {
            Class<?> e = Class.forName("org.springframework.core.SpringVersion");
            this.springVersion = (String)e.getDeclaredMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
            this.spring = true;
            if (this.springVersion.indexOf(".") > 0) {
                int majorVersion = Integer.parseInt(this.springVersion.substring(0, this.springVersion.indexOf(".")));
                this.spring4 = majorVersion > 3;
            }
        }
        catch (Exception var3) {
            this.spring = false;
            this.spring4 = false;
        }
    }

    public boolean isSpring4() {
        return this.spring4;
    }

    public boolean isSpring() {
        return this.spring;
    }

    public String getSpringVersion() {
        return this.springVersion;
    }

    private AbstractMapperTemplate fromMapperClass(Class<?> mapperClass) {
        Method[] methods = mapperClass.getDeclaredMethods();
        Class templateClass = null;
        Class tempClass = null;
        HashSet<String> methodSet = new HashSet<String>();
        Method[] mapperTemplate = methods;
        int iMethods = methods.length;
        for (int methodName = 0; methodName < iMethods; ++methodName) {
            Method e = mapperTemplate[methodName];
            if (e.isAnnotationPresent(SelectProvider.class)) {
                SelectProvider provider = e.getAnnotation(SelectProvider.class);
                tempClass = provider.type();
                methodSet.add(e.getName());
            } else if (e.isAnnotationPresent(InsertProvider.class)) {
                InsertProvider var16 = e.getAnnotation(InsertProvider.class);
                tempClass = var16.type();
                methodSet.add(e.getName());
            } else if (e.isAnnotationPresent(DeleteProvider.class)) {
                DeleteProvider var17 = e.getAnnotation(DeleteProvider.class);
                tempClass = var17.type();
                methodSet.add(e.getName());
            } else if (e.isAnnotationPresent(UpdateProvider.class)) {
                UpdateProvider var18 = e.getAnnotation(UpdateProvider.class);
                tempClass = var18.type();
                methodSet.add(e.getName());
            }
            if (templateClass == null) {
                templateClass = tempClass;
                continue;
            }
            if (templateClass == tempClass) continue;
            throw new RuntimeException("\u4e00\u4e2a\u901a\u7528Mapper\u4e2d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2aMapperTemplate\u5b50\u7c7b!");
        }
        if (templateClass != null && AbstractMapperTemplate.class.isAssignableFrom(templateClass)) {
            AbstractMapperTemplate var13;
            mapperTemplate = null;
            try {
                var13 = (AbstractMapperTemplate)templateClass.getConstructor(Class.class, MapperHelper.class).newInstance(mapperClass, this);
            }
            catch (Exception var12) {
                throw new RuntimeException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + var12.getMessage());
            }
            for (String var15 : methodSet) {
                try {
                    var13.addMethodMap(var15, templateClass.getMethod(var15, MappedStatement.class));
                }
                catch (NoSuchMethodException var11) {
                    throw new RuntimeException(templateClass.getCanonicalName() + "\u4e2d\u7f3a\u5c11" + var15 + "\u65b9\u6cd5!");
                }
            }
            return var13;
        }
        throw new RuntimeException("\u63a5\u53e3\u4e2d\u4e0d\u5b58\u5728\u5305\u542btype\u4e3aMapperTemplate\u7684Provider\u6ce8\u89e3\uff0c\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u901a\u7528Mapper\u63a5\u53e3\u7c7b!");
    }

    public void registerMapper(Class<?> mapperClass) {
        if (this.registerMapper.get(mapperClass) != null) {
            throw new RuntimeException("\u5df2\u7ecf\u6ce8\u518c\u8fc7\u7684\u901a\u7528Mapper[" + mapperClass.getCanonicalName() + "]\u4e0d\u80fd\u591a\u6b21\u6ce8\u518c!");
        }
        this.registerMapper.put(mapperClass, this.fromMapperClass(mapperClass));
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException var3) {
            throw new RuntimeException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public void setMappers(String[] mappers) {
        if (mappers != null && mappers.length > 0) {
            String[] arrs = mappers;
            int len = mappers.length;
            for (int i = 0; i < len; ++i) {
                String mapper = arrs[i];
                this.registerMapper(mapper);
            }
        }
    }

    public void setOrder(String order) {
        this.config.before = "before".equalsIgnoreCase(order);
    }

    public void setCatalog(String catalog) {
        this.config.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.config.schema = schema;
    }

    public String getPrefix() {
        return this.config.catalog != null && this.config.catalog.length() > 0 ? this.config.catalog : (this.config.schema != null && this.config.schema.length() > 0 ? this.config.catalog : "");
    }

    public String getUuid() {
        return this.config.uuid != null && this.config.uuid.length() > 0 ? this.config.uuid : "@java.util.uuid@randomUUID().toString().replace(\"-\", \"\")";
    }

    public void setUuid(String uuid) {
        this.config.uuid = uuid;
    }

    public String getIdentity() {
        return this.config.identity != null && this.config.identity.length() > 0 ? this.config.identity : IdentityDialect.MYSQL.getIdentityRetrievalStatement();
    }

    public void setIdentity(String identity) {
        IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect(identity);
        if (identityDialect != null) {
            this.config.identity = identityDialect.getIdentityRetrievalStatement();
        } else {
            this.config.identity = identity;
        }
    }

    public boolean getBefore() {
        return this.config.before;
    }

    public String getSeqFormat() {
        return this.config.seqFormat != null && this.config.seqFormat.length() > 0 ? this.config.seqFormat : "{0}.nextval";
    }

    public void setSeqFormat(String seqFormat) {
        this.config.seqFormat = seqFormat;
    }

    public String getTableName(Class<?> entityClass) {
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if ("".equals(prefix)) {
            prefix = this.getPrefix();
        }
        return !"".equals(prefix) ? prefix + "." + entityTable.getName() : entityTable.getName();
    }

    public boolean isMapperMethod(String msId) {
        Map.Entry<Class<?>, AbstractMapperTemplate> entry;
        if (this.msIdSkip.get(msId) != null) {
            return this.msIdSkip.get(msId);
        }
        Iterator<Map.Entry<Class<?>, AbstractMapperTemplate>> iMappers = this.registerMapper.entrySet().iterator();
        do {
            if (iMappers.hasNext()) continue;
            this.msIdSkip.put(msId, false);
            return false;
        } while (!(entry = iMappers.next()).getValue().supportMethod(msId));
        this.msIdSkip.put(msId, true);
        return true;
    }

    private AbstractMapperTemplate getMapperTemplate(String msId) {
        AbstractMapperTemplate mapperTemplate = null;
        if (this.msIdCache.get(msId) != null) {
            mapperTemplate = this.msIdCache.get(msId);
        } else {
            for (Map.Entry<Class<?>, AbstractMapperTemplate> entry : this.registerMapper.entrySet()) {
                if (!entry.getValue().supportMethod(msId)) continue;
                mapperTemplate = entry.getValue();
                break;
            }
            this.msIdCache.put(msId, mapperTemplate);
        }
        return mapperTemplate;
    }

    public void setSqlSource(MappedStatement ms) {
        AbstractMapperTemplate mapperTemplate = this.getMapperTemplate(ms.getId());
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception var4) {
            throw new RuntimeException("\u8c03\u7528\u65b9\u6cd5\u5f02\u5e38:" + var4.getMessage());
        }
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            String mapper;
            String notEmpty;
            String order;
            String schema;
            String catalog;
            String seqFormat;
            String identity;
            String uuid = properties.getProperty("uuid");
            if (uuid != null && uuid.length() > 0) {
                this.setUuid(uuid);
            }
            if ((identity = properties.getProperty("identity")) != null && identity.length() > 0) {
                this.setIdentity(identity);
            }
            if ((seqFormat = properties.getProperty("seqFormat")) != null && seqFormat.length() > 0) {
                this.setSeqFormat(seqFormat);
            }
            if ((catalog = properties.getProperty("catalog")) != null && catalog.length() > 0) {
                this.setCatalog(catalog);
            }
            if ((schema = properties.getProperty("schema")) != null && schema.length() > 0) {
                this.setSchema(schema);
            }
            if ((order = properties.getProperty("ORDER")) != null && order.length() > 0) {
                this.setOrder(order);
            }
            if ((notEmpty = properties.getProperty("notEmpty")) != null && notEmpty.length() > 0) {
                this.notEmpty = "TRUE".equalsIgnoreCase(notEmpty);
            }
            if ((mapper = properties.getProperty("mappers")) != null && mapper.length() > 0) {
                String[] mappers;
                String[] arr = mappers = mapper.split(",");
                int len = mappers.length;
                for (int i = 0; i < len; ++i) {
                    String mapperClass = arr[i];
                    if (mapperClass.length() <= 0) continue;
                    this.registerMapper(mapperClass);
                }
            }
        }
    }

    public void processConfiguration(Configuration configuration) {
        Collection collection = configuration.getMappedStatements();
        if (!this.collectionSet.contains(collection)) {
            this.collectionSet.add(collection);
            int size = collection.size();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MappedStatement ms;
                Object object = iterator.next();
                if (object instanceof MappedStatement && this.isMapperMethod((ms = (MappedStatement)object).getId()) && ms.getSqlSource() instanceof ProviderSqlSource) {
                    this.setSqlSource(ms);
                }
                if (collection.size() == size) continue;
                size = collection.size();
                iterator = collection.iterator();
            }
        }
    }

    public static enum IdentityDialect {
        DB2("VALUES IDENTITY_VAL_LOCAL()"),
        MYSQL("SELECT LAST_INSERT_ID()"),
        SQLSERVER("SELECT SCOPE_IDENTITY()"),
        CLOUDSCAPE("VALUES IDENTITY_VAL_LOCAL()"),
        DERBY("VALUES IDENTITY_VAL_LOCAL()"),
        HSQLDB("CALL identity()"),
        SYBASE("SELECT @@identity"),
        DB2_MF("SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1"),
        INFORMIX("select dbinfo('sqlca.sqlerrd1') from systables where tabid=1");

        private String identityRetrievalStatement;

        private IdentityDialect(String identityRetrievalStatement) {
            this.identityRetrievalStatement = identityRetrievalStatement;
        }

        public static IdentityDialect getDatabaseDialect(String database) {
            IdentityDialect returnValue = null;
            if ("DB2".equalsIgnoreCase(database)) {
                returnValue = DB2;
            } else if ("MySQL".equalsIgnoreCase(database)) {
                returnValue = MYSQL;
            } else if ("SqlServer".equalsIgnoreCase(database)) {
                returnValue = SQLSERVER;
            } else if ("Cloudscape".equalsIgnoreCase(database)) {
                returnValue = CLOUDSCAPE;
            } else if ("Derby".equalsIgnoreCase(database)) {
                returnValue = DERBY;
            } else if ("HSQLDB".equalsIgnoreCase(database)) {
                returnValue = HSQLDB;
            } else if ("SYBASE".equalsIgnoreCase(database)) {
                returnValue = SYBASE;
            } else if ("DB2_MF".equalsIgnoreCase(database)) {
                returnValue = DB2_MF;
            } else if ("Informix".equalsIgnoreCase(database)) {
                returnValue = INFORMIX;
            }
            return returnValue;
        }

        public String getIdentityRetrievalStatement() {
            return this.identityRetrievalStatement;
        }
    }

    private class Config {
        private String uuid;
        private String identity;
        private boolean before = false;
        private String seqFormat;
        private String catalog;
        private String schema;

        private Config() {
        }
    }
}

