/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.support.mybatis.mapper;

import cn.gtmap.realestate.core.support.mybatis.mapper.MapperHelper;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

public class EntityHelper {
    private static final Map<Class<?>, EntityTable> ENTITY_TABLE_MAP = new HashMap(2);

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = ENTITY_TABLE_MAP.get(entityClass);
        if (entityTable == null) {
            EntityHelper.initEntityNameMap(entityClass);
            entityTable = ENTITY_TABLE_MAP.get(entityClass);
        }
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPkColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassPkColumns();
    }

    public static Map<String, String> getColumnAlias(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        if (entityTable.aliasMap != null) {
            return entityTable.aliasMap;
        }
        Set<EntityColumn> columnList = entityTable.getEntityClassColumns();
        entityTable.aliasMap = new HashMap(columnList.size());
        for (EntityColumn column : columnList) {
            entityTable.aliasMap.put(column.getColumn(), column.getProperty());
        }
        return entityTable.aliasMap;
    }

    public static String getSelectColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                selectBuilder.append(" ").append(entityColumn.getProperty().toUpperCase()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        Set<EntityColumn> entityColumns = EntityHelper.getPkColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumn()).append(" = ?").append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass) {
        if (ENTITY_TABLE_MAP.get(entityClass) == null) {
            Table fieldList;
            EntityTable entityTable = null;
            if (entityClass.isAnnotationPresent(Table.class) && !"".equals((fieldList = entityClass.getAnnotation(Table.class)).name())) {
                entityTable = new EntityTable();
                entityTable.setTable(fieldList);
            }
            if (entityTable == null) {
                entityTable = new EntityTable();
                entityTable.name = EntityHelper.camelhumpToUnderline(entityClass.getSimpleName()).toUpperCase();
            }
            List<Field> fieldList1 = EntityHelper.getAllField(entityClass, null);
            HashSet<EntityColumn> columnSet = new HashSet<EntityColumn>();
            HashSet<EntityColumn> pkColumnSet = new HashSet<EntityColumn>();
            Iterator<Field> i = fieldList1.iterator();
            while (true) {
                if (!i.hasNext()) {
                    entityTable.entityClassColumns = columnSet;
                    if (pkColumnSet.size() == 0) {
                        entityTable.entityClassPkColumns = columnSet;
                    } else {
                        entityTable.entityClassPkColumns = pkColumnSet;
                    }
                    ENTITY_TABLE_MAP.put(entityClass, entityTable);
                    return;
                }
                Field field = i.next();
                if (field.isAnnotationPresent(Transient.class)) continue;
                EntityColumn entityColumn = new EntityColumn();
                if (field.isAnnotationPresent(Id.class)) {
                    entityColumn.setId(true);
                }
                String columnName = null;
                if (field.isAnnotationPresent(Column.class)) {
                    Column generatedValue = field.getAnnotation(Column.class);
                    columnName = generatedValue.name();
                }
                if (columnName == null || "".equals(columnName)) {
                    columnName = EntityHelper.camelhumpToUnderline(field.getName());
                }
                entityColumn.setProperty(field.getName());
                entityColumn.setColumn(columnName.toUpperCase());
                entityColumn.setJavaType(field.getType());
                if (field.isAnnotationPresent(OrderBy.class)) {
                    OrderBy generatedValue1 = field.getAnnotation(OrderBy.class);
                    if ("".equals(generatedValue1.value())) {
                        entityColumn.setOrderBy("ASC");
                    } else {
                        entityColumn.setOrderBy(generatedValue1.value());
                    }
                }
                if (field.isAnnotationPresent(SequenceGenerator.class)) {
                    SequenceGenerator generatedValue2 = field.getAnnotation(SequenceGenerator.class);
                    if ("".equals(generatedValue2.sequenceName())) {
                        throw new RuntimeException(entityClass + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
                    }
                    entityColumn.setSequenceName(generatedValue2.sequenceName());
                } else if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue3 = field.getAnnotation(GeneratedValue.class);
                    if ("UUID".equals(generatedValue3.generator())) {
                        if (!field.getType().equals(String.class)) {
                            throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u4e3aUUID\uff0c\u4f46\u8be5\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fString");
                        }
                        entityColumn.setUuid(true);
                    } else if ("JDBC".equals(generatedValue3.generator())) {
                        if (!Number.class.isAssignableFrom(field.getType())) {
                            throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u4e3aUUID\uff0c\u4f46\u8be5\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fString");
                        }
                        entityColumn.setIdentity(true);
                        entityColumn.setGenerator("JDBC");
                    } else {
                        if (generatedValue3.strategy() != GenerationType.IDENTITY) {
                            throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\")\n2.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n3.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
                        }
                        entityColumn.setIdentity(true);
                        if (!"".equals(generatedValue3.generator())) {
                            String generator = null;
                            MapperHelper.IdentityDialect identityDialect = MapperHelper.IdentityDialect.getDatabaseDialect(generatedValue3.generator());
                            generator = identityDialect != null ? identityDialect.getIdentityRetrievalStatement() : generatedValue3.generator();
                            entityColumn.setGenerator(generator);
                        }
                    }
                }
                columnSet.add(entityColumn);
                if (!entityColumn.isId()) continue;
                pkColumnSet.add(entityColumn);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(EntityHelper.camelhumpToUnderline("userName"));
        System.out.println(EntityHelper.camelhumpToUnderline("userPassWord"));
        System.out.println(EntityHelper.camelhumpToUnderline("ISO9001"));
        System.out.println(EntityHelper.camelhumpToUnderline("hello_world"));
    }

    public static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(EntityHelper.toUpperAscii(c));
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toUpperAscii(char c) {
        if (EntityHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        Field[] superClass = fields = entityClass.getDeclaredFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            Field field = superClass[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> var7 = entityClass.getSuperclass();
        return var7 != null && !var7.equals(Object.class) && (var7.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(var7) && !Collection.class.isAssignableFrom(var7)) ? EntityHelper.getAllField(entityClass.getSuperclass(), fieldList) : fieldList;
    }

    public static Map<String, Object> map2AliasMap(Map<String, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        Map<String, String> alias = EntityHelper.getColumnAlias(beanClass);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Iterator<String> i = map.keySet().iterator();
        while (i.hasNext()) {
            String name;
            String alia = name = i.next();
            if (alias.containsKey(name)) {
                alia = alias.get(name);
            }
            result.put(alia, map.get(name));
        }
        return result;
    }

    public static Object map2Bean(Map<String, Object> map, Class<?> beanClass) {
        try {
            if (map == null) {
                return null;
            }
            Map<String, Object> e = EntityHelper.map2AliasMap(map, beanClass);
            return JSON.parseObject((String)JSON.toJSONString(e), beanClass);
        }
        catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    public static List<?> maplist2BeanList(List<?> mapList, Class<?> beanClass) {
        if (mapList != null && mapList.size() != 0) {
            ArrayList<Object> list = new ArrayList<Object>(mapList.size());
            for (Object map : mapList) {
                list.add(EntityHelper.map2Bean((Map)map, beanClass));
            }
            mapList.clear();
            mapList.addAll(list);
            return mapList;
        }
        return null;
    }

    public static class EntityTable {
        private String name;
        private String catalog;
        private String schema;
        private Set<EntityColumn> entityClassColumns;
        private Set<EntityColumn> entityClassPkColumns;
        private Map<String, String> aliasMap;

        public void setTable(Table table) {
            this.name = table.name();
            this.catalog = table.catalog();
            this.schema = table.schema();
        }

        public String getName() {
            return this.name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getPrefix() {
            return this.catalog != null && this.catalog.length() > 0 ? this.catalog : (this.schema != null && this.schema.length() > 0 ? this.catalog : "");
        }

        public Set<EntityColumn> getEntityClassColumns() {
            return this.entityClassColumns;
        }

        public Set<EntityColumn> getEntityClassPkColumns() {
            return this.entityClassPkColumns;
        }

        public Map<String, String> getAliasMap() {
            return this.aliasMap;
        }
    }

    public static class EntityColumn {
        private String property;
        private String column;
        private Class<?> javaType;
        private String sequenceName;
        private boolean id = false;
        private boolean uuid = false;
        private boolean identity = false;
        private String generator;
        private String orderBy;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public void setJavaType(Class<?> javaType) {
            this.javaType = javaType;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public boolean isId() {
            return this.id;
        }

        public void setId(boolean id) {
            this.id = id;
        }

        public boolean isUuid() {
            return this.uuid;
        }

        public void setUuid(boolean uuid) {
            this.uuid = uuid;
        }

        public boolean isIdentity() {
            return this.identity;
        }

        public void setIdentity(boolean identity) {
            this.identity = identity;
        }

        public String getGenerator() {
            return this.generator;
        }

        public void setGenerator(String generator) {
            this.generator = generator;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                EntityColumn that = (EntityColumn)o;
                if (this.id != that.id) {
                    return false;
                }
                if (this.identity != that.identity) {
                    return false;
                }
                if (this.uuid != that.uuid) {
                    return false;
                }
                if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
                    return false;
                }
                if (this.generator != null ? !this.generator.equals(that.generator) : that.generator != null) {
                    return false;
                }
                if (!(this.javaType != null ? this.javaType.equals(that.javaType) : that.javaType == null)) {
                    return false;
                }
                if (!(this.orderBy != null ? this.orderBy.equals(that.orderBy) : that.orderBy == null)) {
                    return false;
                }
                if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
                    return false;
                }
                return !(this.sequenceName != null ? !this.sequenceName.equals(that.sequenceName) : that.sequenceName != null);
            }
            return false;
        }

        public int hashCode() {
            int result = this.property != null ? this.property.hashCode() : 0;
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
            result = 31 * result + (this.sequenceName != null ? this.sequenceName.hashCode() : 0);
            result = 31 * result + (this.id ? 1 : 0);
            result = 31 * result + (this.uuid ? 1 : 0);
            result = 31 * result + (this.identity ? 1 : 0);
            result = 31 * result + (this.generator != null ? this.generator.hashCode() : 0);
            result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
            return result;
        }
    }
}

