/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.support.mybatis.mapper;

import cn.gtmap.realestate.core.support.mybatis.mapper.AbstractMapperTemplate;
import cn.gtmap.realestate.core.support.mybatis.mapper.BaseProvider;
import cn.gtmap.realestate.core.support.mybatis.mapper.EntityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

public class CommonProvider
extends BaseProvider {
    public String select(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject orderBy = AbstractMapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = orderBy.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
                StringBuilder orderBy1 = new StringBuilder();
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.getOrderBy() == null) continue;
                    orderBy1.append(column.getColumn()).append(" ").append(column.getOrderBy()).append(",");
                }
                if (orderBy1.length() > 0) {
                    this.ORDER_BY(orderBy1.substring(0, orderBy1.length() - 1));
                }
            }
        }.toString();
    }

    public String count(final Map<String, Object> params) {
        return new SQL(){
            {
                Class<?> entityClass;
                Object entity = CommonProvider.this.getEntity(params);
                if (entity instanceof Class) {
                    entityClass = (Class<?>)entity;
                    entity = null;
                } else {
                    entityClass = CommonProvider.this.getEntityClass(params);
                }
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String selectByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entityTable.getEntityClassPkColumns().size() == 1) {
                    EntityHelper.EntityColumn metaObject = entityTable.getEntityClassPkColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(metaObject.getProperty(), entity);
                    this.WHERE(metaObject.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject1 = AbstractMapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPkColumns()) {
                        Object value = metaObject1.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String insert(final Map<String, Object> params) {
        return new SQL(){
            {
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String insertSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (null == value) continue;
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String insertBatchSelective(Map<String, Object> params) {
        String insertBatchSql = "";
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        insertBatchSql = insertBatchSql + "insert into " + entityTable.getName();
        if (params.containsKey("record") && params.get("record") != null && (params.get("record") instanceof List || params.get("record") instanceof ArrayList)) {
            List list = (List)params.get("record");
            for (int i = 0; i < list.size(); ++i) {
                StringBuilder str = new StringBuilder("select ");
                MetaObject metaObject = AbstractMapperTemplate.forObject(list.get(i));
                int j = 0;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    ++j;
                    metaObject.getValue(column.getProperty());
                    if (i == 0) {
                        columns.add(column.getColumn());
                    }
                    String type = this.getjdbcType(column.getJavaType().getSimpleName());
                    if (j == entityTable.getEntityClassColumns().size()) {
                        str.append("#{record[" + i + "].").append(column.getProperty()).append(",").append(type).append("}");
                        continue;
                    }
                    str.append("#{record[" + i + "].").append(column.getProperty()).append(",").append(type).append("},");
                }
                str.append(" from dual");
                values.add(str.toString());
            }
        }
        insertBatchSql = insertBatchSql + " " + this.batchSql(columns, ",");
        insertBatchSql = insertBatchSql + " " + this.batchSql(values, "union all");
        return insertBatchSql;
    }

    private String batchSql(List<?> list, String split) {
        StringBuilder str = new StringBuilder("(");
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                str.append(list.get(i)).append(" ");
                if (list.size() - i == 1) continue;
                str.append(split).append(" ");
            }
        }
        str.append(")");
        return str.toString();
    }

    private String getjdbcType(String type) {
        String str = "";
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DATE")) {
            str = "jdbcType=TIMESTAMP";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"STRING")) {
            str = "jdbcType=VARCHAR";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"INTEGER")) {
            str = "jdbcType=INTEGER";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DOUBLE")) {
            str = "jdbcType=DOUBLE";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"FLOAT")) {
            str = "jdbcType=FLOAT";
        }
        return str;
    }

    public String delete(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.DELETE_FROM(entityTable.getName());
                boolean hasValue = false;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    if (column.getJavaType().equals(String.class)) {
                        if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        hasValue = true;
                        continue;
                    }
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    hasValue = true;
                }
                if (!hasValue) {
                    throw new UnsupportedOperationException("delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u5168\u8868\u7684\u64cd\u4f5c!");
                }
            }
        }.toString();
    }

    public String deleteByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                if (entityTable.getEntityClassPkColumns().size() == 1) {
                    EntityHelper.EntityColumn metaObject = entityTable.getEntityClassPkColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(metaObject.getProperty(), entity);
                    this.WHERE(metaObject.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject1 = AbstractMapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPkColumns()) {
                        Object value = metaObject1.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPkColumns().size() == 1) {
                    EntityHelper.EntityColumn i1 = entityTable.getEntityClassPkColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(i1.getProperty(), metaObject.getValue(i1.getProperty()));
                    this.WHERE(i1.getColumn() + "=#{record." + i1.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPkColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKeyNull(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    String value = CommonProvider.this.getjdbcType(column.getJavaType().getSimpleName());
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "," + value + "}");
                }
                if (entityTable.getEntityClassPkColumns().size() == 1) {
                    EntityHelper.EntityColumn i1 = entityTable.getEntityClassPkColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(i1.getProperty(), metaObject.getValue(i1.getProperty()));
                    this.WHERE(i1.getColumn() + "=#{record." + i1.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPkColumns()) {
                        Object value1 = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value1);
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKeySelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null || column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPkColumns().size() == 1) {
                    EntityHelper.EntityColumn i1 = entityTable.getEntityClassPkColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(i1.getProperty(), metaObject.getValue(i1.getProperty()));
                    this.WHERE(i1.getColumn() + "=#{record." + i1.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPkColumns()) {
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String countByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String deleteByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String selectByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
                CommonProvider.this.applyOrderBy(this, example);
            }
        }.toString();
    }

    public String updateByExampleSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = AbstractMapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String updateByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }
}

