/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.support.mybatis.mapper;

import cn.gtmap.realestate.core.support.mybatis.mapper.EntityHelper;
import cn.gtmap.realestate.core.support.mybatis.mapper.MapperHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.session.Configuration;

public abstract class AbstractMapperTemplate {
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private Map<String, Method> methodMap = new HashMap<String, Method>();
    private Class<?> mapperClass;
    private MapperHelper mapperHelper;

    public AbstractMapperTemplate(Class<?> mapperClass, MapperHelper mapperHelper) {
        this.mapperClass = mapperClass;
        this.mapperHelper = mapperHelper;
    }

    public static MetaObject forObject(Object object) {
        return MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
    }

    public static Class<?> getMapperClass(String msId) {
        if (msId.indexOf(".") == -1) {
            throw new RuntimeException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf("."));
        try {
            return Class.forName(mapperClassStr);
        }
        catch (ClassNotFoundException var3) {
            return null;
        }
    }

    public static String getMethodName(MappedStatement ms) {
        return AbstractMapperTemplate.getMethodName(ms.getId());
    }

    public static String getMethodName(String msId) {
        return msId.substring(msId.lastIndexOf(".") + 1);
    }

    public String dynamicSql(Object record) {
        return "dynamicSql";
    }

    public void addMethodMap(String methodName, Method method) {
        this.methodMap.put(methodName, method);
    }

    public String getUuid() {
        return this.mapperHelper.getUuid();
    }

    public String getIdentity() {
        return this.mapperHelper.getIdentity();
    }

    public boolean getBefore() {
        return this.mapperHelper.getBefore();
    }

    public boolean supportMethod(String msId) {
        Class<?> mapperClass = AbstractMapperTemplate.getMapperClass(msId);
        if (mapperClass != null && this.mapperClass.isAssignableFrom(mapperClass)) {
            String methodName = AbstractMapperTemplate.getMethodName(msId);
            return this.methodMap.get(methodName) != null;
        }
        return false;
    }

    protected void setResultType(MappedStatement ms, Class<?> entityClass) {
        ResultMap resultMap = (ResultMap)ms.getResultMaps().get(0);
        MetaObject metaObject = AbstractMapperTemplate.forObject(resultMap);
        metaObject.setValue("type", entityClass);
    }

    protected void setSqlSource(MappedStatement ms, SqlSource sqlSource) {
        MetaObject msObject = AbstractMapperTemplate.forObject(ms);
        msObject.setValue("sqlSource", (Object)sqlSource);
    }

    public void setSqlSource(MappedStatement ms) throws Exception {
        if (this.mapperClass == AbstractMapperTemplate.getMapperClass(ms.getId())) {
            if (!this.mapperHelper.isSpring4()) {
                if (this.mapperHelper.isSpring()) {
                    throw new RuntimeException("Spring4.x.x \u53ca\u4ee5\u4e0a\u7248\u672c\u652f\u6301\u6cdb\u578b\u6ce8\u5165,\u60a8\u5f53\u524d\u7684Spring\u7248\u672c\u4e3a" + this.mapperHelper.getSpringVersion() + ",\u4e0d\u80fd\u4f7f\u7528\u6cdb\u578b\u6ce8\u5165,\u56e0\u6b64\u5728\u914d\u7f6eMapperScannerConfigurer\u65f6,\u4e0d\u8981\u626b\u63cf\u901a\u7528Mapper\u63a5\u53e3\u7c7b,\u4e5f\u4e0d\u8981\u5728\u60a8Mybatis\u7684xml\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684<mappers>\u4e2d\u6307\u5b9a\u901a\u7528Mapper\u63a5\u53e3\u7c7b.");
                }
                throw new RuntimeException("\u8bf7\u4e0d\u8981\u5728\u60a8Mybatis\u7684xml\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684<mappers>\u4e2d\u6307\u5b9a\u901a\u7528Mapper\u63a5\u53e3\u7c7b.");
            }
        } else {
            Method method = this.methodMap.get(AbstractMapperTemplate.getMethodName(ms));
            try {
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)this, ms);
                } else {
                    if (!SqlNode.class.isAssignableFrom(method.getReturnType())) {
                        throw new RuntimeException("\u81ea\u5b9a\u4e49Mapper\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u9519\u8bef,\u53ef\u9009\u7684\u8fd4\u56de\u7c7b\u578b\u4e3avoid\u548cSqlNode!");
                    }
                    SqlNode e = (SqlNode)method.invoke((Object)this, ms);
                    DynamicSqlSource dynamicSqlSource = new DynamicSqlSource(ms.getConfiguration(), e);
                    this.setSqlSource(ms, (SqlSource)dynamicSqlSource);
                }
            }
            catch (IllegalAccessException var5) {
                throw new RuntimeException(var5);
            }
            catch (InvocationTargetException var6) {
                throw new RuntimeException(var6.getTargetException() != null ? var6.getTargetException() : var6);
            }
        }
    }

    public Class<?> getSelectReturnType(MappedStatement ms) {
        Type[] types;
        String msId = ms.getId();
        Class<?> mapperClass = AbstractMapperTemplate.getMapperClass(msId);
        Type[] arr = types = mapperClass.getGenericInterfaces();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ParameterizedType t;
            Type type = arr[i];
            if (!(type instanceof ParameterizedType) || (t = (ParameterizedType)type).getRawType() != this.mapperClass) continue;
            Class returnType = (Class)t.getActualTypeArguments()[0];
            return returnType;
        }
        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6Mapper<T>\u6cdb\u578b\u7c7b\u578b:" + msId);
    }

    protected List<ParameterMapping> getPrimaryKeyParameterMappings(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        Set<EntityHelper.EntityColumn> entityColumns = EntityHelper.getPkColumns(entityClass);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (EntityHelper.EntityColumn column : entityColumns) {
            ParameterMapping.Builder builder = new ParameterMapping.Builder(ms.getConfiguration(), column.getProperty(), column.getJavaType());
            builder.mode(ParameterMode.IN);
            parameterMappings.add(builder.build());
        }
        return parameterMappings;
    }

    protected String getSeqNextVal(EntityHelper.EntityColumn column) {
        return MessageFormat.format(this.mapperHelper.getSeqFormat(), column.getSequenceName(), column.getColumn(), column.getProperty());
    }

    protected String tableName(Class<?> entityClass) {
        return this.mapperHelper.getTableName(entityClass);
    }

    protected SqlNode getIfNotNull(EntityHelper.EntityColumn column, SqlNode columnNode) {
        return this.getIfNotNull(column, columnNode, false);
    }

    protected SqlNode getIfNotNull(EntityHelper.EntityColumn column, SqlNode columnNode, boolean empty) {
        return new IfSqlNode(columnNode, column.getProperty() + " != null " + (empty ? " and " + column.getProperty() + " != ''" : ""));
    }

    protected SqlNode getIfIsNull(EntityHelper.EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + " == null ");
    }

    protected SqlNode getIfCacheNotNull(EntityHelper.EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + "_cache != null ");
    }

    protected SqlNode getIfCacheIsNull(EntityHelper.EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + "_cache == null ");
    }

    protected SqlNode getColumnEqualsProperty(EntityHelper.EntityColumn column, boolean first) {
        return new StaticTextSqlNode((first ? "" : " AND ") + column.getColumn() + " = #{" + column.getProperty() + "} ");
    }

    protected SqlNode getAllIfColumnNode(Class<?> entityClass) {
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        ArrayList<SqlNode> ifNodes = new ArrayList<SqlNode>();
        boolean first = true;
        for (EntityHelper.EntityColumn column : columnList) {
            ifNodes.add(this.getIfNotNull(column, this.getColumnEqualsProperty(column, first), this.mapperHelper.isNotEmpty()));
            first = false;
        }
        return new MixedSqlNode(ifNodes);
    }

    protected List<ParameterMapping> getColumnParameterMappings(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        Set<EntityHelper.EntityColumn> entityColumns = EntityHelper.getColumns(entityClass);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (EntityHelper.EntityColumn column : entityColumns) {
            ParameterMapping.Builder builder = new ParameterMapping.Builder(ms.getConfiguration(), column.getProperty(), column.getJavaType());
            builder.mode(ParameterMode.IN);
            parameterMappings.add(builder.build());
        }
        return parameterMappings;
    }

    protected void newSelectKeyMappedStatement(MappedStatement ms, EntityHelper.EntityColumn column) {
        String keyId = ms.getId() + "!selectKey";
        if (!ms.getConfiguration().hasKeyGenerator(keyId)) {
            String identity;
            Class<?> entityClass = this.getSelectReturnType(ms);
            Configuration configuration = ms.getConfiguration();
            Jdbc3KeyGenerator keyGenerator = null;
            Boolean executeBefore = this.getBefore();
            String string = identity = column.getGenerator() != null && !"".equals(column.getGenerator()) ? column.getGenerator() : this.getIdentity();
            if ("JDBC".equalsIgnoreCase(identity)) {
                keyGenerator = new Jdbc3KeyGenerator();
            } else {
                RawSqlSource e = new RawSqlSource(configuration, identity, entityClass);
                MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, keyId, (SqlSource)e, SqlCommandType.SELECT);
                statementBuilder.resource(ms.getResource());
                statementBuilder.fetchSize((Integer)null);
                statementBuilder.statementType(StatementType.STATEMENT);
                statementBuilder.keyGenerator((KeyGenerator)new NoKeyGenerator());
                statementBuilder.keyProperty(column.getProperty());
                statementBuilder.keyColumn((String)null);
                statementBuilder.databaseId((String)null);
                statementBuilder.lang(configuration.getDefaultScriptingLanguageInstance());
                statementBuilder.resultOrdered(false);
                statementBuilder.resultSets((String)null);
                statementBuilder.timeout(configuration.getDefaultStatementTimeout());
                ArrayList parameterMappings = new ArrayList();
                ParameterMap.Builder inlineParameterMapBuilder = new ParameterMap.Builder(configuration, statementBuilder.id() + "-Inline", entityClass, parameterMappings);
                statementBuilder.parameterMap(inlineParameterMapBuilder.build());
                ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
                ResultMap.Builder inlineResultMapBuilder = new ResultMap.Builder(configuration, statementBuilder.id() + "-Inline", column.getJavaType(), new ArrayList(), (Boolean)null);
                resultMaps.add(inlineResultMapBuilder.build());
                statementBuilder.resultMaps(resultMaps);
                statementBuilder.resultSetType((ResultSetType)null);
                statementBuilder.flushCacheRequired(false);
                statementBuilder.useCache(false);
                statementBuilder.cache((Cache)null);
                MappedStatement statement = statementBuilder.build();
                configuration.addMappedStatement(statement);
                MappedStatement keyStatement = configuration.getMappedStatement(keyId, false);
                keyGenerator = new SelectKeyGenerator(keyStatement, executeBefore.booleanValue());
                configuration.addKeyGenerator(keyId, (KeyGenerator)keyGenerator);
            }
            try {
                MetaObject e1 = AbstractMapperTemplate.forObject(ms);
                e1.setValue("keyGenerator", (Object)keyGenerator);
                e1.setValue("keyProperties", (Object)new String[]{column.getProperty()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IfSqlNode exampleValidSqlNode(Configuration configuration) {
        ArrayList<IfSqlNode> whenSqlNodes = new ArrayList<IfSqlNode>();
        IfSqlNode noValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode("and ${criterion.condition}"), "criterion.noValue");
        whenSqlNodes.add(noValueSqlNode);
        IfSqlNode singleValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode("and ${criterion.condition} #{criterion.value}"), "criterion.singleValue");
        whenSqlNodes.add(singleValueSqlNode);
        IfSqlNode betweenValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode("and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}"), "criterion.betweenValue");
        whenSqlNodes.add(betweenValueSqlNode);
        ArrayList<Object> listValueContentSqlNodes = new ArrayList<Object>();
        listValueContentSqlNodes.add(new TextSqlNode("and ${criterion.condition}"));
        ForEachSqlNode listValueForEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)new StaticTextSqlNode("#{listItem}"), "criterion.value", (String)null, "listItem", "(", ")", ",");
        listValueContentSqlNodes.add(listValueForEachSqlNode);
        IfSqlNode listValueSqlNode = new IfSqlNode((SqlNode)new MixedSqlNode(listValueContentSqlNodes), "criterion.noValue");
        whenSqlNodes.add(listValueSqlNode);
        ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, (SqlNode)null);
        ForEachSqlNode criteriaSqlNode = new ForEachSqlNode(configuration, (SqlNode)chooseSqlNode, "criteria.criteria", (String)null, "criterion", (String)null, (String)null, (String)null);
        TrimSqlNode trimSqlNode = new TrimSqlNode(configuration, (SqlNode)criteriaSqlNode, "(", "and", ")", (String)null);
        IfSqlNode validSqlNode = new IfSqlNode((SqlNode)trimSqlNode, "criteria.valid");
        return validSqlNode;
    }

    public WhereSqlNode exampleWhereClause(Configuration configuration) {
        ForEachSqlNode forEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)this.exampleValidSqlNode(configuration), "oredCriteria", (String)null, "criteria", (String)null, (String)null, "or");
        WhereSqlNode whereSqlNode = new WhereSqlNode(configuration, (SqlNode)forEachSqlNode);
        return whereSqlNode;
    }

    public WhereSqlNode updateByExampleWhereClause(Configuration configuration) {
        ForEachSqlNode forEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)this.exampleValidSqlNode(configuration), "example.oredCriteria", (String)null, "criteria", (String)null, (String)null, "or");
        WhereSqlNode whereSqlNode = new WhereSqlNode(configuration, (SqlNode)forEachSqlNode);
        return whereSqlNode;
    }
}

