/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.model.dzzzgl;

import cn.gtmap.realestate.core.model.abstraction.Qrcode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;

public class ZxingQrcode
extends Qrcode {
    private int width;
    private int height;

    @Override
    public BufferedImage createQrCode() {
        BufferedImage bufferedImage = null;
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            HashMap<Object, Object> hints = new HashMap<Object, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            BitMatrix bitMatrix = multiFormatWriter.encode(this.content, BarcodeFormat.QR_CODE, this.width, this.height, hints);
            bitMatrix = this.deleteWhite(bitMatrix);
            bufferedImage = this.toBufferedImageDelWhite(bitMatrix);
        }
        catch (Exception e) {
            this.logger.error("ZxingQrcode:createQrCode", (Throwable)e);
        }
        return bufferedImage;
    }

    @Override
    public BufferedImage createQrCodeLogo() throws IOException {
        return super.createQrCodeLogo();
    }

    public BufferedImage toBufferedImage(BitMatrix matrix) {
        BufferedImage image = new BufferedImage(matrix.getWidth(), matrix.getHeight(), 1);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public BufferedImage toBufferedImageDelWhite(BitMatrix matrix) {
        BufferedImage image = new BufferedImage(matrix.getWidth(), matrix.getHeight(), 1);
        for (int x = 0; x < matrix.getWidth(); ++x) {
            for (int y = 0; y < matrix.getHeight(); ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public ZxingQrcode(String content) {
        this.width = 500;
        this.height = 500;
        this.content = content;
    }

    public ZxingQrcode(String content, int width, int height) {
        this.width = width;
        this.height = height;
        this.content = content;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

