/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.core.model.abstraction;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Qrcode {
    public final Logger logger = LoggerFactory.getLogger(Qrcode.class);
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final String QRCODE_FORMAT_PNG = "png";
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 500;
    public String logoDataPath;
    public int logoWidth = 200;
    public int logoHeight = 200;
    protected float qrcodeAbsoluteX;
    protected float qrcodeAbsoluteY;
    protected String content;

    public BufferedImage createQrCode() {
        return null;
    }

    public BufferedImage createQrCodeLogo() throws IOException {
        BufferedImage matrixImage = this.createQrCode();
        Graphics2D g2 = matrixImage.createGraphics();
        int matrixWidth = matrixImage.getWidth();
        int matrixHeigh = matrixImage.getHeight();
        BufferedImage logo = ImageIO.read(new File(this.logoDataPath));
        g2.drawImage(logo, (matrixWidth - this.logoWidth) / 2 + 2, (matrixHeigh - this.logoHeight) / 2 + 1, this.logoWidth, this.logoHeight, null);
        g2.dispose();
        return matrixImage;
    }

    public static byte[] writeToStream(BufferedImage bufferedImage, String format) {
        byte[] qrcodeByte = null;
        if (null != bufferedImage) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                bufferedImage.flush();
                if (ImageIO.write((RenderedImage)bufferedImage, format, out)) {
                    qrcodeByte = out.toByteArray();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return qrcodeByte;
    }

    public float getQrcodeAbsoluteX() {
        return this.qrcodeAbsoluteX;
    }

    public void setQrcodeAbsoluteX(float qrcodeAbsoluteX) {
        this.qrcodeAbsoluteX = qrcodeAbsoluteX;
    }

    public float getQrcodeAbsoluteY() {
        return this.qrcodeAbsoluteY;
    }

    public void setQrcodeAbsoluteY(float qrcodeAbsoluteY) {
        this.qrcodeAbsoluteY = qrcodeAbsoluteY;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getLogoWidth() {
        return this.logoWidth;
    }

    public void setLogoWidth(int logoWidth) {
        this.logoWidth = logoWidth;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public void setLogoHeight(int logoHeight) {
        this.logoHeight = logoHeight;
    }

    public String getLogoDataPath() {
        return this.logoDataPath;
    }

    public void setLogoDataPath(String logoDataPath) {
        this.logoDataPath = logoDataPath;
    }
}

