<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>自然幢查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <table class="layui-table" lay-skin="nob">
                <colgroup>
                    <col width="12%">
                    <col width="26%">
                    <col width="12%">
                    <col width="26%">
                    <col>
                </colgroup>
                <tbody>
                <tr>
                    <td class="form-tb-lable">自然幢号:</td>
                    <td>
                        <input type="text" name="zrzh" class="layui-input" placeholder="请输入自然幢号">
                    </td>
                    <td class="form-tb-lable">坐落地址:</td>
                    <td>
                        <input type="text" name="zldz" class="layui-input" placeholder="请输入坐落地址">
                    </td>
                    <td>
                        <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query"
                                lay-filter="query"
                                type="button">
                            查询
                        </button>
                        <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="zrzList" lay-data="{id: 'zdList'}" lay-filter="dataTable"></table>
</div>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    var lszd = "${lszd!}";
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('zrzList', data.field);
            return false;
        });

        var param = "";
        if(lszd){
            param = "?lszd=" + lszd;
        }
        var tableConfig = {
            url: '../zrz/listbypage' + param//数据接口
            , cols: [[
                {field: 'zrzh', title: '自然幢号',
                    templet: function (d) {
                        return '<div><a href="javascript:void(0);" onclick="" ' +
                                'lay-event="pickZrz" class="layui-table-link">'+d.zrzh+'</a></div>';
                    }
                },
                {
                    field: 'lszd', title: '隶属宗地',
                    templet: function (d) {
                        return splitDjh(d.lszd || '');
                    }
                },
                {field: 'zldz', title: '坐落地址'},
                {field: 'fwmc', title: '房屋名称'},
                {field: 'fwcs', title: '房屋层数'}
            ]]
        }

        //加载表格
        loadDataTablbeByUrl("#zrzList", tableConfig);

        //父页面的该页面索引
        var index = parent.layer.getFrameIndex(window.name);
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data) {
                if (obj.event === "pickZrz") {
                    if (parent.pickZrzCallBack) {
                        parent.pickZrzCallBack(data)
                        parent.layer.close(index);
                    }
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

    })
</script>
</body>

</html>
